/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.misc.signaller;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import sonar.core.network.sync.BaseSyncListPart;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncEnum;
import sonar.core.network.sync.SyncNBTAbstract;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.sync.SyncUnidentifiedObject;
import sonar.logistics.api.core.tiles.displays.info.IComparableInfo;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.displays.info.comparators.ComparableObject;
import sonar.logistics.api.core.tiles.displays.info.comparators.InputTypes;
import sonar.logistics.api.core.tiles.displays.info.comparators.LogicOperator;
import sonar.logistics.api.core.tiles.displays.info.comparators.LogicState;
import sonar.logistics.base.statements.ILogisticsStatement;
import sonar.logistics.base.statements.comparators.ComparatorHelper;
import sonar.logistics.base.statements.comparators.ILogicComparator;
import sonar.logistics.network.sync.SyncInfoUUID;

public class RedstoneSignallerStatement<T>
extends BaseSyncListPart
implements ILogisticsStatement {
    private ILogicComparator<T> comparator;
    public SyncTagType.INT hashCode = new SyncTagType.INT(-1);
    public SyncTagType.STRING comparatorID = new SyncTagType.STRING(0);
    public SyncEnum<LogicOperator> operator = new SyncEnum((Enum[])LogicOperator.values(), 1);
    public SyncEnum<InputTypes> useInfo = new SyncEnum((Enum[])InputTypes.values(), 2);
    public SyncNBTAbstract<InfoUUID> uuid1 = new SyncInfoUUID(3).setObject(InfoUUID.newInvalid());
    public SyncNBTAbstract<InfoUUID> uuid2 = new SyncInfoUUID(4).setObject(InfoUUID.newInvalid());
    public SyncTagType.STRING key1 = new SyncTagType.STRING(5);
    public SyncTagType.STRING key2 = new SyncTagType.STRING(6);
    public SyncUnidentifiedObject obj = new SyncUnidentifiedObject(7);
    public SyncTagType.BOOLEAN wasTrue = new SyncTagType.BOOLEAN(9);

    public RedstoneSignallerStatement() {
        this.syncList.addParts(new IDirtyPart[]{this.hashCode, this.comparatorID, this.operator, this.useInfo, this.uuid1, this.uuid2, this.key1, this.key2, this.obj, this.wasTrue});
        this.hashCode.setObject((Object)UUID.randomUUID().hashCode());
    }

    public RedstoneSignallerStatement(ILogicComparator<T> comparator) {
        this.syncList.addParts(new IDirtyPart[]{this.hashCode, this.comparatorID, this.operator, this.useInfo, this.uuid1, this.uuid2, this.key1, this.key2, this.obj, this.wasTrue});
        this.comparatorID.setObject((Object)comparator.getName());
        this.operator.setObject((Enum)comparator.getValidOperators().get(0));
        this.hashCode.setObject((Object)UUID.randomUUID().hashCode());
    }

    public void addRequiredUUIDs(List<InfoUUID> uuids) {
        if (InfoUUID.valid((InfoUUID)this.uuid1.getObject()) && !uuids.contains(this.uuid1.getObject())) {
            uuids.add((InfoUUID)this.uuid1.getObject());
        }
        if (((InputTypes)this.useInfo.getObject()).usesInfo() && InfoUUID.valid((InfoUUID)this.uuid2.getObject()) && !uuids.contains(this.uuid2.getObject())) {
            uuids.add((InfoUUID)this.uuid2.getObject());
        }
    }

    public ILogicComparator<T> getComparator() {
        return ComparatorHelper.getComparator((String)this.comparatorID.getObject());
    }

    public Object getObject(Map<InfoUUID, IInfo> info, int pos) {
        if (pos == 0) {
            return this.getObject(info, (InfoUUID)this.uuid1.getObject(), (String)this.key1.getObject());
        }
        if (((InputTypes)this.useInfo.getObject()).usesInfo()) {
            return this.getObject(info, (InfoUUID)this.uuid2.getObject(), (String)this.key2.getObject());
        }
        if (this.obj.get() != null && this.getComparator().isValidObject(this.obj.get())) {
            return this.obj.get();
        }
        return null;
    }

    public Object getObject(Map<InfoUUID, IInfo> info, InfoUUID id, String key) {
        IComparableInfo provider1;
        ComparableObject obj;
        IInfo info1;
        if (InfoUUID.valid(id) && key != null && (info1 = info.get(id)) instanceof IComparableInfo && (obj = ComparableObject.getComparableObject((provider1 = (IComparableInfo)info1).getComparableObjects(new ArrayList<ComparableObject>()), key)) != null && this.getComparator() != null && this.getComparator().isValidObject(obj.object)) {
            return obj.object;
        }
        return null;
    }

    @Override
    public LogicState isMatching(Map<InfoUUID, IInfo> info) {
        Object num1 = this.getObject(info, 0);
        Object num2 = this.getObject(info, 1);
        if (num1 != null && num2 != null) {
            return this.getComparator().getLogicState((LogicOperator)this.operator.getObject(), num1, num2);
        }
        return LogicState.FALSE;
    }

    @Override
    public LogicOperator getOperator() {
        return (LogicOperator)this.operator.getObject();
    }

    @Override
    public List<LogicOperator> validOperators() {
        return this.getComparator().getValidOperators();
    }

    public int hashCode() {
        return (Integer)this.hashCode.getObject();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RedstoneSignallerStatement) {
            return obj.hashCode() == this.hashCode();
        }
        return false;
    }

    public InputTypes getInputType() {
        return (InputTypes)this.useInfo.getObject();
    }

    public void incrementInputType() {
        this.useInfo.incrementEnum();
    }

    public void incrementOperator() {
        int ordinal;
        LogicOperator current = (LogicOperator)this.operator.getObject();
        List<LogicOperator> valid = this.validOperators();
        int pos = -1;
        int currentPos = 0;
        for (LogicOperator op : this.validOperators()) {
            if (op == current) {
                pos = currentPos;
                break;
            }
            ++currentPos;
        }
        if (pos == -1) {
            this.operator.setObject((Enum)valid.get(0));
        }
        if ((ordinal = pos + 1) < valid.size()) {
            this.operator.setObject((Enum)valid.get(ordinal));
        } else {
            this.operator.setObject((Enum)valid.get(0));
        }
    }
}

