/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.RenderHelper;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.INameableInfo;
import sonar.logistics.core.tiles.displays.info.elements.DisplayElementHelper;
import sonar.logistics.core.tiles.displays.info.elements.base.HeightAlignment;
import sonar.logistics.core.tiles.displays.info.elements.base.WidthAlignment;
import sonar.logistics.core.tiles.displays.info.types.general.LogicInfo;

public class InfoRenderHelper {
    public static final double zLevel = 0.0;
    public static final double barOffset = 0.001;
    public static int left_offset = 13;
    public static int middle_offset = 136;
    public static int right_offset = 245;

    public static void renderCenteredStringsWithAdaptiveScaling(double width, double height, double maxScale, int spacing, double percentageFill, int colour, List<String> toDisplay) {
        double maxIndividualHeight = height / (double)toDisplay.size();
        double compressedHeight = 0.0;
        double maximumWidth = 0.0;
        int unscaledMaximumWidth = 0;
        ArrayList<Double[]> matrices = new ArrayList<Double[]>();
        for (String s : toDisplay) {
            int unscaledWidth = InfoRenderHelper.getStringWidth(s);
            int unscaledHeight = InfoRenderHelper.getStringHeight();
            double scale = Math.min(width / (double)unscaledWidth, maxIndividualHeight / (double)unscaledHeight);
            double maxWidth = (double)unscaledWidth * scale * percentageFill;
            double maxHeight = (double)unscaledHeight * scale * percentageFill;
            matrices.add(new Double[]{maxWidth, maxHeight, scale});
            if (maxWidth > maximumWidth) {
                maximumWidth = maxWidth;
                unscaledMaximumWidth = unscaledWidth;
            }
            compressedHeight += maxHeight;
        }
        GlStateManager.func_179137_b((double)((width - maximumWidth) / 2.0), (double)((height - compressedHeight) / 2.0), (double)0.0);
        for (int i = 0; i < toDisplay.size(); ++i) {
            String s;
            s = toDisplay.get(i);
            Double[] matrix = (Double[])matrices.get(i);
            GlStateManager.func_179094_E();
            int unscaledWidth = InfoRenderHelper.getStringWidth(s);
            int unscaledHeight = InfoRenderHelper.getStringHeight();
            double scale = Math.min(width / (double)unscaledWidth, matrix[1] / (double)unscaledHeight);
            double maxWidth = (double)unscaledWidth * scale;
            double maxHeight = (double)unscaledHeight * scale;
            GlStateManager.func_179137_b((double)((maximumWidth - maxWidth) / 2.0), (double)0.0, (double)0.0);
            GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
            GlStateManager.func_179094_E();
            RenderHelper.fontRenderer.func_78276_b(s, 0, 0, colour);
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
            GlStateManager.func_179137_b((double)0.0, (double)maxHeight, (double)0.0);
        }
    }

    public static void renderCenteredStringsWithUniformScaling(List<String> toDisplay, double width, double height, int spacing, double percentageFill, int colour) {
        GlStateManager.func_179094_E();
        int unscaledWidth = InfoRenderHelper.getMaxWidth(toDisplay);
        int unscaledHeight = InfoRenderHelper.getMaxHeight(toDisplay, spacing);
        double scale = Math.min(width / (double)unscaledWidth, height / (double)unscaledHeight) * percentageFill;
        double maxWidth = (double)unscaledWidth * scale;
        double maxHeight = (double)unscaledHeight * scale;
        DisplayElementHelper.align(new double[]{width, height, 1.0}, new double[]{maxWidth, maxHeight, 1.0}, WidthAlignment.CENTERED, HeightAlignment.CENTERED);
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
        for (int i = 0; i < toDisplay.size(); ++i) {
            if (i != 0) {
                GlStateManager.func_179109_b((float)0.0f, (float)(spacing + InfoRenderHelper.getStringHeight()), (float)0.0f);
            }
            String s = toDisplay.get(i);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(unscaledWidth / 2 - InfoRenderHelper.getStringWidth(s) / 2), (float)0.0f, (float)0.0f);
            RenderHelper.fontRenderer.func_78276_b(s, 0, 0, colour);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }

    public static int getMaxWidth(List<String> toDisplay) {
        int width = 0;
        for (String s : toDisplay) {
            int w = RenderHelper.fontRenderer.func_78256_a(s);
            if (w <= width) continue;
            width = w;
        }
        return width;
    }

    public static int getMaxHeight(List<String> toDisplay, int spacing) {
        int height = toDisplay.size() * InfoRenderHelper.getStringHeight();
        int spacings = toDisplay.size() - 1;
        if (spacings > 0) {
            height += spacings * spacing;
        }
        return height;
    }

    public static int getStringWidth(String s) {
        return RenderHelper.fontRenderer.func_78256_a(s);
    }

    public static int getStringHeight() {
        return RenderHelper.fontRenderer.field_78288_b;
    }

    public static void renderProgressBarWithSprite(TextureAtlasSprite sprite, double width, double height, double progress, double maxProgress) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        double minX = -0.001;
        double minY = -0.001;
        double maxX = width + 0.001;
        double maxY = height + 0.001;
        double barWidth = progress * (maxX - minX) / maxProgress;
        double divide = Math.max(maxX - minX, maxY - minY);
        double widthnew = (double)sprite.func_94209_e() + barWidth * (double)(sprite.func_94212_f() - sprite.func_94209_e()) / (maxX - minX);
        double heightnew = (double)sprite.func_94206_g() + (maxY - minY) * (double)(sprite.func_94210_h() - sprite.func_94206_g()) / (maxX - minX);
        vertexbuffer.func_181662_b(minX + 0.0, maxY, 0.0).func_187315_a((double)sprite.func_94209_e(), heightnew).func_181675_d();
        vertexbuffer.func_181662_b(minX + barWidth, maxY, 0.0).func_187315_a(widthnew, heightnew).func_181675_d();
        vertexbuffer.func_181662_b(minX + barWidth, minY + 0.0, 0.0).func_187315_a(widthnew, (double)sprite.func_94206_g()).func_181675_d();
        vertexbuffer.func_181662_b(minX + 0.0, minY + 0.0, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderMonitorInfoInGUI(IInfo info, int yPos, int colour) {
        if (info instanceof INameableInfo) {
            INameableInfo directInfo = (INameableInfo)info;
            if (!directInfo.isHeader() && directInfo.isValid()) {
                InfoRenderHelper.renderTripleStringIntoGUI(directInfo.getClientIdentifier(), directInfo.getClientObject(), directInfo.getClientType(), yPos, colour);
            } else if (directInfo instanceof LogicInfo) {
                String category = ((LogicInfo)directInfo).getRegistryType().name();
                FontHelper.text((String)(category.substring(0, 1) + category.substring(1).toLowerCase()), (int)(left_offset + 4), (int)yPos, (int)colour);
            }
        }
    }

    public static void renderTripleStringIntoGUI(String left, String middle, String right, int yPos, int colour) {
        left = FontHelper.trimToWidthWithParentheses((String)left, (String)"...", (int)(middle_offset - left_offset - 1), (double)1.0);
        FontHelper.text((String)left, (int)left_offset, (int)yPos, (int)colour);
        FontHelper.text((String)middle, (int)middle_offset, (int)yPos, (int)colour);
        FontHelper.text((String)right, (int)right_offset, (int)yPos, (int)colour);
    }
}

