/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.gsi.packets;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.SonarCore;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.FlexibleGuiHandler;
import sonar.logistics.PL2;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.base.ServerInfoHandler;
import sonar.logistics.base.requests.info.IInfoRequirement;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.gsi.modes.GSICreateInfo;
import sonar.logistics.core.tiles.displays.gsi.packets.GSIElementPacket;
import sonar.logistics.core.tiles.displays.gsi.storage.DisplayElementContainer;
import sonar.logistics.core.tiles.displays.gsi.storage.DisplayGSISaveHandler;
import sonar.logistics.core.tiles.displays.info.elements.DisplayElementHelper;
import sonar.logistics.core.tiles.displays.info.elements.UnconfiguredInfoElement;
import sonar.logistics.core.tiles.displays.info.elements.base.IDisplayElement;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;
import sonar.logistics.network.packets.gsi.PacketGSIElement;

public class GSIElementPacketHelper {
    public static GSIElementPacket.IGSIElementPacketHandler handler = GSIElementPacketHelper::runGSIElementPacket;
    public static final String PACKET_ID = "PktID";

    public static void sendGSIPacket(NBTTagCompound tag, int elementID, DisplayGSI gsi) {
        if (!tag.func_82582_d()) {
            PL2.network.sendToServer((IMessage)new PacketGSIElement(gsi.getDisplayGSIIdentity(), elementID, tag));
        }
    }

    public static void runGSIElementPacket(DisplayGSI gsi, IDisplayElement element, EntityPlayer player, NBTTagCompound clickTag) {
        GSIElementPacketHelper.readPacketID((NBTTagCompound)clickTag).logic.runGSIElementPacket(gsi, element, player, clickTag);
    }

    public static NBTTagCompound createBasicPacket(GSIElementPacket packet) {
        return GSIElementPacketHelper.writePacketID(new NBTTagCompound(), packet);
    }

    public static NBTTagCompound writePacketID(NBTTagCompound tag, GSIElementPacket packet) {
        tag.func_74768_a(PACKET_ID, packet.ordinal());
        return tag;
    }

    public static GSIElementPacket readPacketID(NBTTagCompound tag) {
        return GSIElementPacket.values()[tag.func_74762_e(PACKET_ID)];
    }

    public static NBTTagCompound createInfoAdditionPacket(double[] translate, double[] scale, double pScale, GSICreateInfo type) {
        NBTTagCompound tag = new NBTTagCompound();
        GSIElementPacketHelper.writePacketID(tag, GSIElementPacket.INFO_ADDITION);
        NBTHelper.writeDoubleArray((NBTTagCompound)tag, (double[])translate, (String)"translate");
        NBTHelper.writeDoubleArray((NBTTagCompound)tag, (double[])scale, (String)"scale");
        tag.func_74780_a("pscale", pScale);
        tag.func_74768_a("type", type.ordinal());
        return tag;
    }

    public static void doInfoAdditionPacket(DisplayGSI gsi, IDisplayElement element, EntityPlayer player, NBTTagCompound packetTag) {
        double[] translate = NBTHelper.readDoubleArray((NBTTagCompound)packetTag, (String)"translate", (int)3);
        double[] scale = NBTHelper.readDoubleArray((NBTTagCompound)packetTag, (String)"scale", (int)3);
        double pScale = packetTag.func_74769_h("pscale");
        DisplayElementContainer c = gsi.addElementContainer(translate, scale, pScale);
        IDisplayElement e = GSICreateInfo.values()[packetTag.func_74762_e((String)"type")].logic.create(c);
        gsi.sendInfoContainerPacket(DisplayGSISaveHandler.DisplayGSISavedData.ALL_DATA);
    }

    public static NBTTagCompound createGuiRequestPacket(int guiID, NBTTagCompound packetTag) {
        NBTTagCompound tag = new NBTTagCompound();
        GSIElementPacketHelper.writePacketID(tag, GSIElementPacket.GUI_REQUEST);
        tag.func_74768_a("GUI_ID", guiID);
        tag.func_74782_a("gui_tag", (NBTBase)packetTag);
        return tag;
    }

    public static void doGuiRequestPacket(DisplayGSI gsi, IDisplayElement element, EntityPlayer player, NBTTagCompound packetTag) {
        if (gsi.getDisplay().getActualDisplay() instanceof TileAbstractDisplay) {
            NBTTagCompound tag = packetTag.func_74775_l("gui_tag");
            int slotID = ((TileAbstractDisplay)gsi.getDisplay().getActualDisplay()).getSlotID();
            if (slotID == -1) {
                tag.func_74757_a(FlexibleGuiHandler.TILEENTITY, true);
            } else {
                tag.func_74757_a(FlexibleGuiHandler.MULTIPART, true);
                tag.func_74768_a(FlexibleGuiHandler.SLOT_ID, slotID);
            }
            if (!tag.func_74764_b("ELE_ID")) {
                tag.func_74768_a("ELE_ID", element == null ? -1 : element.getElementIdentity());
            }
            if (!tag.func_74764_b("CONT_ID")) {
                tag.func_74768_a("CONT_ID", element == null ? -1 : element.getHolder().getContainer().getContainerIdentity());
            }
            SonarCore.instance.guiHandler.openGui(false, player, player.func_130014_f_(), gsi.getDisplay().getCoords().getBlockPos(), packetTag.func_74762_e("GUI_ID"), tag);
        }
    }

    public static NBTTagCompound createInfoRequirementPacket(List<InfoUUID> uuids) {
        NBTTagCompound tag = new NBTTagCompound();
        GSIElementPacketHelper.writePacketID(tag, GSIElementPacket.INFO_SET);
        NBTTagList list = new NBTTagList();
        uuids.forEach(uuid -> list.func_74742_a((NBTBase)uuid.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE)));
        tag.func_74782_a("uuids", (NBTBase)list);
        return tag;
    }

    public static void doInfoRequirementPacket(DisplayGSI gsi, IDisplayElement element, EntityPlayer player, NBTTagCompound packetTag) {
        if (element instanceof IInfoRequirement) {
            IInfoRequirement require = (IInfoRequirement)((Object)element);
            NBTTagList tag = packetTag.func_150295_c("uuids", 10);
            ArrayList<InfoUUID> required = new ArrayList<InfoUUID>();
            for (int i = 0; i < tag.func_74745_c(); ++i) {
                NBTTagCompound nbt = tag.func_150305_b(i);
                InfoUUID uuid = (InfoUUID)NBTHelper.instanceNBTSyncable(InfoUUID.class, (NBTTagCompound)nbt);
                if (!InfoUUID.valid(uuid)) continue;
                required.add(uuid);
            }
            if (required.size() == require.getRequired()) {
                require.doInfoRequirementPacket(gsi, player, required);
            }
        }
    }

    public static NBTTagCompound createDeleteContainersPacket(List<Integer> toDelete) {
        NBTTagCompound tag = new NBTTagCompound();
        GSIElementPacketHelper.writePacketID(tag, GSIElementPacket.DELETE_CONTAINERS);
        NBTTagList list = new NBTTagList();
        toDelete.forEach(del -> list.func_74742_a((NBTBase)new NBTTagInt(del.intValue())));
        tag.func_74782_a("del", (NBTBase)list);
        return tag;
    }

    public static void doDeleteContainersPacket(DisplayGSI gsi, IDisplayElement element, EntityPlayer player, NBTTagCompound packetTag) {
        NBTTagList tag = packetTag.func_150295_c("del", 3);
        ArrayList<Integer> toDelete = new ArrayList<Integer>();
        for (int i = 0; i < tag.func_74745_c(); ++i) {
            toDelete.add(tag.func_186858_c(i));
        }
        toDelete.forEach(gsi::removeElementContainer);
        gsi.sendInfoContainerPacket(DisplayGSISaveHandler.DisplayGSISavedData.ALL_DATA);
    }

    public static NBTTagCompound createDeleteElementsPacket(List<Integer> toDelete) {
        NBTTagCompound tag = new NBTTagCompound();
        GSIElementPacketHelper.writePacketID(tag, GSIElementPacket.DELETE_ELEMENTS);
        NBTTagList list = new NBTTagList();
        toDelete.forEach(del -> list.func_74742_a((NBTBase)new NBTTagInt(del.intValue())));
        tag.func_74782_a("del", (NBTBase)list);
        return tag;
    }

    public static void doDeleteElementsPacket(DisplayGSI gsi, IDisplayElement element, EntityPlayer player, NBTTagCompound packetTag) {
        NBTTagList tag = packetTag.func_150295_c("del", 3);
        ArrayList<Integer> toDelete = new ArrayList<Integer>();
        for (int i = 0; i < tag.func_74745_c(); ++i) {
            toDelete.add(tag.func_186858_c(i));
        }
        toDelete.forEach(gsi::removeElement);
        gsi.sendInfoContainerPacket(DisplayGSISaveHandler.DisplayGSISavedData.ALL_DATA);
    }

    public static NBTTagCompound createResizeContainerPacket(int containerID, double[] translate, double[] scale, double pScale) {
        NBTTagCompound tag = new NBTTagCompound();
        GSIElementPacketHelper.writePacketID(tag, GSIElementPacket.RESIZE_CONTAINER);
        tag.func_74768_a("CONT_ID", containerID);
        NBTHelper.writeDoubleArray((NBTTagCompound)tag, (double[])translate, (String)"translate");
        NBTHelper.writeDoubleArray((NBTTagCompound)tag, (double[])scale, (String)"scale");
        tag.func_74780_a("pscale", pScale);
        return tag;
    }

    public static void doResizeContainerPacket(DisplayGSI gsi, IDisplayElement element, EntityPlayer player, NBTTagCompound packetTag) {
        int containerID = packetTag.func_74762_e("CONT_ID");
        double[] translate = NBTHelper.readDoubleArray((NBTTagCompound)packetTag, (String)"translate", (int)3);
        double[] scale = NBTHelper.readDoubleArray((NBTTagCompound)packetTag, (String)"scale", (int)3);
        double pScale = packetTag.func_74769_h("pscale");
        DisplayElementContainer c = gsi.getContainer(containerID);
        if (c != null) {
            c.resize(translate, scale, pScale);
            c.updateActualScaling();
            gsi.sendInfoContainerPacket(DisplayGSISaveHandler.DisplayGSISavedData.CONTAINERS);
        }
    }

    public static NBTTagCompound createConfigureInfoPacket(UnconfiguredInfoElement element) {
        NBTTagCompound tag = new NBTTagCompound();
        GSIElementPacketHelper.writePacketID(tag, GSIElementPacket.CONFIGURE_INFO_ELEMENT);
        NBTTagList list = new NBTTagList();
        for (IDisplayElement e : element.elements) {
            if (e == null) continue;
            list.func_74742_a((NBTBase)DisplayElementHelper.saveElement(new NBTTagCompound(), e, NBTHelper.SyncType.SAVE));
        }
        tag.func_74782_a("elements", (NBTBase)list);
        return tag;
    }

    public static void doConfigureInfoPacket(DisplayGSI gsi, IDisplayElement element, EntityPlayer player, NBTTagCompound packetTag) {
        if (element instanceof UnconfiguredInfoElement) {
            element.getHolder().getElements().removeElement(element);
            NBTTagList tag = packetTag.func_150295_c("elements", 10);
            for (int i = 0; i < tag.func_74745_c(); ++i) {
                NBTTagCompound nbt = tag.func_150305_b(i);
                nbt.func_74768_a("identity", ServerInfoHandler.instance().getNextIdentity());
                IDisplayElement e = DisplayElementHelper.loadElement(nbt, element.getHolder());
                element.getHolder().getElements().addElement(e);
            }
            gsi.sendInfoContainerPacket(DisplayGSISaveHandler.DisplayGSISavedData.ALL_DATA);
        }
    }

    public static NBTTagCompound createEditElementPacket(IDisplayElement e) {
        NBTTagCompound tag = new NBTTagCompound();
        GSIElementPacketHelper.writePacketID(tag, GSIElementPacket.EDIT_ELEMENT);
        tag.func_74782_a("edits", (NBTBase)e.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE));
        return tag;
    }

    public static void doEditElementPacket(DisplayGSI gsi, IDisplayElement element, EntityPlayer player, NBTTagCompound packetTag) {
        NBTTagCompound tag = packetTag.func_74775_l("edits");
        tag.func_74768_a("identity", element.getElementIdentity());
        element.readData(tag, NBTHelper.SyncType.SAVE);
        element.onElementChanged();
        gsi.sendInfoContainerPacket(DisplayGSISaveHandler.DisplayGSISavedData.ALL_DATA);
    }

    public static NBTTagCompound createEditModePacket(boolean set) {
        NBTTagCompound tag = new NBTTagCompound();
        GSIElementPacketHelper.writePacketID(tag, GSIElementPacket.EDIT_MODE);
        tag.func_74757_a("edit_mode", set);
        return tag;
    }

    public static void doEditModePacket(DisplayGSI gsi, IDisplayElement element, EntityPlayer player, NBTTagCompound packetTag) {
        gsi.edit_mode.setObject((Object)packetTag.func_74767_n("edit_mode"));
        gsi.sendInfoContainerPacket(DisplayGSISaveHandler.DisplayGSISavedData.SYNC_PARTS);
    }

    public static NBTTagCompound createUpdateElementPacket(IDisplayElement element, NBTHelper.SyncType type) {
        NBTTagCompound tag = new NBTTagCompound();
        GSIElementPacketHelper.writePacketID(tag, GSIElementPacket.UPDATE_ELEMENT);
        tag.func_74782_a("update_tag", (NBTBase)element.writeData(new NBTTagCompound(), type));
        tag.func_74768_a("type", type.ordinal());
        return tag;
    }

    public static void doUpdateElementPacket(DisplayGSI gsi, IDisplayElement element, EntityPlayer player, NBTTagCompound packetTag) {
        NBTTagCompound tag = packetTag.func_74775_l("update_tag");
        element.readData(tag, NBTHelper.SyncType.values()[packetTag.func_74762_e("type")]);
    }

    public static NBTTagCompound createResetGSIPacket() {
        NBTTagCompound tag = new NBTTagCompound();
        GSIElementPacketHelper.writePacketID(tag, GSIElementPacket.RESET_GSI);
        return tag;
    }

    public static void doResetGSIPacket(DisplayGSI gsi, IDisplayElement element, EntityPlayer player, NBTTagCompound packetTag) {
        gsi.containers.clear();
        gsi.edit_mode.setObject((Object)true);
        gsi.sendInfoContainerPacket(DisplayGSISaveHandler.DisplayGSISavedData.ALL_DATA);
    }
}

