/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.gsi.gui;

import java.io.IOException;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.Tuple;
import sonar.core.client.gui.SonarTextField;
import sonar.core.client.gui.widgets.SonarScroller;
import sonar.logistics.core.tiles.displays.gsi.gui.GuiAbstractEditScreen;
import sonar.logistics.core.tiles.displays.gsi.interaction.DisplayScreenClick;
import sonar.logistics.core.tiles.displays.gsi.packets.GSIElementPacketHelper;
import sonar.logistics.core.tiles.displays.gsi.storage.DisplayElementContainer;
import sonar.logistics.core.tiles.displays.info.elements.DisplayElementHelper;
import sonar.logistics.core.tiles.displays.info.elements.base.IDisplayElement;
import sonar.logistics.core.tiles.displays.tiles.DisplayVectorHelper;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;

public class GuiAbstractEditContainer
extends GuiAbstractEditScreen {
    public DisplayElementContainer c;
    public SonarScroller scaling_scroller;
    public SonarScroller spacing_scroller;
    public SonarTextField scaling_field;
    public SonarTextField spacing_field;

    public GuiAbstractEditContainer(DisplayElementContainer c, TileAbstractDisplay display) {
        super(c.getGSI(), display);
        this.c = c;
    }

    public void save() {
        GSIElementPacketHelper.sendGSIPacket(GSIElementPacketHelper.createResizeContainerPacket(this.c.containerIdentity, this.c.getTranslation(), this.c.getContainerMaxScaling(), this.c.percentageScale), -1, this.c.getGSI());
    }

    @Override
    public void renderDisplayScreen(float partialTicks, int x, int y) {
        DisplayElementHelper.renderElementStorageHolder(this.c);
    }

    @Override
    public double[] getUnscaled() {
        return new double[]{this.c.getContainerMaxScaling()[0], this.c.getContainerMaxScaling()[1], 1.0};
    }

    @Override
    public boolean doDisplayScreenClick(double clickX, double clickY, int key) {
        Tuple<IDisplayElement, double[]> click = this.c.getClickBoxes(new double[]{0.0, 0.0, 0.0}, clickX, clickY);
        if (click != null) {
            DisplayScreenClick fakeClick = DisplayVectorHelper.createFakeClick(this.gsi, this.c.getTranslation()[0] + clickX, this.c.getTranslation()[1] + clickY, this.isDoubleClick(), key);
            this.onDisplayElementClicked((IDisplayElement)click.func_76341_a(), fakeClick, (double[])click.func_76340_b());
            return true;
        }
        return false;
    }

    public void onDisplayElementClicked(IDisplayElement e, DisplayScreenClick fakeClick, double[] subClick) {
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.fieldList.clear();
    }

    public void func_73863_a(int x, int y, float var) {
        super.func_73863_a(x, y, var);
        if (this.scaling_scroller != null) {
            this.scaling_scroller.drawScreen(x, y, true);
            this.setScalingScroller(this.scaling_scroller.currentScroll);
        }
        if (this.spacing_scroller != null) {
            this.spacing_scroller.drawScreen(x, y, true);
            this.setSpacingScroller(this.spacing_scroller.currentScroll);
        }
    }

    public void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
    }

    @Override
    public void func_146976_a(float partialTicks, int x, int y) {
        super.func_146976_a(partialTicks, x, y);
        GlStateManager.func_179140_f();
        if (this.scaling_scroller != null) {
            this.renderScroller(this.scaling_scroller);
        }
        if (this.spacing_scroller != null) {
            this.renderScroller(this.spacing_scroller);
        }
    }

    public void setScalingScroller(float scaling) {
        if (scaling == 0.0f) {
            scaling = 0.01f;
        }
        if (this.c.percentageScale != (double)scaling || this.scaling_scroller.currentScroll != scaling) {
            this.c.percentageScale = scaling;
            this.scaling_scroller.currentScroll = scaling;
            this.setContainerScaling();
            if (this.scaling_field != null) {
                this.scaling_field.func_146180_a(String.valueOf((int)(this.scaling_scroller.currentScroll * 100.0f)));
            }
        }
    }

    public void setSpacingScroller(float scaling) {
    }

    public void onTextFieldChanged(SonarTextField field) {
        super.onTextFieldChanged(field);
        if (this.scaling_field != null && field == this.scaling_field) {
            int value = field.getIntegerFromText();
            if (value > 100) {
                value = 100;
            }
            this.setScalingScroller((float)value / 100.0f);
            this.scaling_field.func_146180_a(String.valueOf(value));
        } else if (this.spacing_field != null && field == this.spacing_field) {
            int value = field.getIntegerFromText();
            if (value > 100) {
                value = 100;
            }
            this.setSpacingScroller((float)value / 100.0f);
            this.spacing_field.func_146180_a(String.valueOf(value));
        }
    }

    protected void func_73869_a(char c, int i) throws IOException {
        if (this.isCloseKey(i)) {
            this.save();
        }
        super.func_73869_a(c, i);
    }
}

