/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mcmultipart.api.slot.EnumFaceSlot;
import mcmultipart.api.slot.IPartSlot;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.logistics.api.core.tiles.connections.data.network.ILogisticsNetwork;
import sonar.logistics.api.core.tiles.displays.tiles.IDisplay;
import sonar.logistics.api.core.tiles.displays.tiles.ILargeDisplay;
import sonar.logistics.api.core.tiles.readers.IInfoProvider;
import sonar.logistics.base.listeners.ILogicListenable;
import sonar.logistics.core.tiles.displays.tiles.connected.ConnectedDisplay;

public class DisplayHelper {
    public static EnumFacing[] getScreenOrientation(EntityLivingBase placer, EnumFacing side) {
        EnumFacing facing = side;
        EnumFacing rotation = EnumFacing.NORTH;
        if (placer.field_70125_A > 75.0f || placer.field_70125_A < -75.0f) {
            rotation = placer.func_174811_aO().func_176734_d();
        } else {
            facing = placer.func_174811_aO().func_176734_d();
        }
        return new EnumFacing[]{facing, rotation};
    }

    public static List<ILogicListenable> getLocalProviders(IDisplay part, IBlockAccess world, BlockPos pos) {
        List<ILogicListenable> providers = new ArrayList<ILogicListenable>();
        if (part instanceof ILargeDisplay) {
            Optional<ConnectedDisplay> display = ((ILargeDisplay)part).getConnectedDisplay();
            providers = display.isPresent() ? display.get().getLocalProviders(providers) : DisplayHelper.getLocalProvidersFromDisplay(providers, world, pos, part);
        } else if (part instanceof ConnectedDisplay) {
            ConnectedDisplay display = (ConnectedDisplay)part;
            providers = display.getLocalProviders(providers);
        } else {
            providers = DisplayHelper.getLocalProvidersFromDisplay(providers, world, pos, part);
        }
        return providers;
    }

    public static List<ILogicListenable> getLocalProvidersFromDisplay(List<ILogicListenable> viewables, IBlockAccess world, BlockPos pos, IDisplay part) {
        ILogisticsNetwork networkCache = part.getNetwork();
        IBlockAccess actualWorld = SonarMultipartHelper.unwrapBlockAccess((IBlockAccess)world);
        Optional connectedPart = SonarMultipartHelper.getMultipartTile((IBlockAccess)actualWorld, (BlockPos)pos, (IPartSlot)EnumFaceSlot.fromFace((EnumFacing)part.getCableFace()), tile -> true);
        if (connectedPart.isPresent() && connectedPart.get() instanceof IInfoProvider) {
            if (!viewables.contains(connectedPart.get())) {
                viewables.add((IInfoProvider)connectedPart.get());
            }
        } else {
            for (IInfoProvider monitor : networkCache.getGlobalInfoProviders()) {
                if (viewables.contains(monitor)) continue;
                viewables.add(monitor);
            }
        }
        return viewables;
    }
}

