/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.connections.redstone.network;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sonar.core.helpers.ListHelper;
import sonar.core.listener.ISonarListenable;
import sonar.core.listener.ListenableList;
import sonar.logistics.api.core.tiles.connections.redstone.IRedstoneCable;
import sonar.logistics.api.core.tiles.connections.redstone.IRedstoneConnectable;
import sonar.logistics.api.core.tiles.connections.redstone.IRedstonePowerProvider;
import sonar.logistics.api.core.tiles.connections.redstone.network.IRedstoneNetwork;
import sonar.logistics.api.core.tiles.wireless.emitters.IRedstoneEmitter;
import sonar.logistics.api.core.tiles.wireless.receivers.IRedstoneReceiver;
import sonar.logistics.core.tiles.connections.redstone.handling.RedstoneConnectionHandler;
import sonar.logistics.core.tiles.connections.redstone.handling.RedstoneConnectionHelper;
import sonar.logistics.core.tiles.wireless.handling.WirelessRedstoneManager;

public class RedstoneNetwork
implements IRedstoneNetwork {
    public final List<IRedstonePowerProvider> providers = new ArrayList<IRedstonePowerProvider>();
    public final List<IRedstoneReceiver> receivers = new ArrayList<IRedstoneReceiver>();
    public final List<IRedstoneEmitter> emitters = new ArrayList<IRedstoneEmitter>();
    public final ListenableList<IRedstoneNetwork> subNetworks = new ListenableList((ISonarListenable)this, 2);
    public final List<IRedstoneConnectable> toAdd = new ArrayList<IRedstoneConnectable>();
    public final List<IRedstoneConnectable> toRemove = new ArrayList<IRedstoneConnectable>();
    public int registryID = -1;
    public int localPower = 0;
    public int globalPower = 0;
    public int actualPower = 0;
    public boolean cablesChanged = true;

    public RedstoneNetwork(int registryID) {
        this.registryID = registryID;
    }

    @Override
    public int getNetworkID() {
        return this.registryID;
    }

    @Override
    public void markCablesChanged() {
        this.cablesChanged = true;
    }

    @Override
    public boolean doCablesNeedUpdate() {
        return this.cablesChanged;
    }

    @Override
    public void tick() {
        this.toAdd.forEach(this::doAddConnection);
        this.toRemove.forEach(this::doRemoveConnection);
        if (this.doCablesNeedUpdate()) {
            this.updateCables();
        }
    }

    public void updateCables() {
        Lists.newArrayList(this.providers).forEach(this::removeConnection);
        Lists.newArrayList(this.receivers).forEach(this::removeConnection);
        Lists.newArrayList(this.emitters).forEach(this::removeConnection);
        List<IRedstoneCable> cables = RedstoneConnectionHandler.instance().getConnections(this.registryID);
        cables.forEach(cable -> RedstoneConnectionHelper.getConnectables(cable).forEach(this::addConnection));
        this.cablesChanged = false;
    }

    @Override
    public void addConnection(IRedstoneConnectable connectable) {
        ListHelper.addWithCheck(this.toAdd, (Object)connectable);
        this.toRemove.remove(connectable);
    }

    @Override
    public void removeConnection(IRedstoneConnectable connectable) {
        ListHelper.addWithCheck(this.toRemove, (Object)connectable);
        this.toAdd.remove(connectable);
    }

    public void doAddConnection(IRedstoneConnectable connection) {
        if (connection instanceof IRedstoneReceiver) {
            ListHelper.addWithCheck(this.receivers, (Object)((IRedstoneReceiver)connection));
            WirelessRedstoneManager.instance().connectReceiver(this, (IRedstoneReceiver)connection);
        } else if (connection instanceof IRedstoneEmitter) {
            ListHelper.addWithCheck(this.emitters, (Object)((IRedstoneEmitter)connection));
            WirelessRedstoneManager.instance().connectEmitter(this, (IRedstoneEmitter)connection);
        } else if (connection instanceof IRedstonePowerProvider) {
            ListHelper.addWithCheck(this.providers, (Object)((IRedstonePowerProvider)connection));
        }
        connection.onNetworkConnect(this);
        RedstoneConnectionHandler.instance().markPowerForUpdate(this.registryID);
    }

    public void doRemoveConnection(IRedstoneConnectable connection) {
        if (connection instanceof IRedstoneReceiver) {
            this.receivers.remove(connection);
            WirelessRedstoneManager.instance().disconnectReceiver(this, (IRedstoneReceiver)connection);
        } else if (connection instanceof IRedstoneEmitter) {
            this.emitters.remove(connection);
            WirelessRedstoneManager.instance().disconnectEmitter(this, (IRedstoneEmitter)connection);
        } else if (connection instanceof IRedstonePowerProvider) {
            this.providers.remove(connection);
        }
        connection.onNetworkDisconnect(this);
        RedstoneConnectionHandler.instance().markPowerForUpdate(this.registryID);
    }

    @Override
    public int getActualPower() {
        return this.actualPower;
    }

    @Override
    public int getLocalPower() {
        return this.localPower;
    }

    @Override
    public int getGlobalPower() {
        return this.globalPower;
    }

    @Override
    public int updateActualPower() {
        int newPower = this.getLocalPower();
        if (newPower == 0) {
            newPower = this.getGlobalPower();
        }
        if (newPower != this.actualPower) {
            this.actualPower = newPower;
            this.notifyWatchingNetworksOfChange();
            RedstoneConnectionHandler.instance().powerCache.put(this.registryID, this.actualPower);
        }
        List<IRedstoneCable> cables = RedstoneConnectionHandler.instance().getConnections(this.registryID);
        cables.forEach(cable -> cable.setNetworkPower(this.actualPower));
        return this.actualPower;
    }

    @Override
    public int updateLocalPower() {
        IRedstonePowerProvider provider;
        int newPower = 0;
        Iterator<IRedstonePowerProvider> iterator = this.providers.iterator();
        while (iterator.hasNext() && (newPower = (provider = iterator.next()).getCurrentPower()) <= 0) {
        }
        this.localPower = newPower;
        return this.localPower;
    }

    @Override
    public int updateGlobalPower() {
        int newPower = 0;
        for (IRedstoneReceiver receiver : this.receivers) {
            receiver.updatePower();
            newPower = receiver.getRedstonePower();
            if (newPower <= 0) continue;
            break;
        }
        this.globalPower = newPower;
        return this.globalPower;
    }

    @Override
    public void notifyWatchingNetworksOfChange() {
        List<IRedstoneNetwork> networks = RedstoneNetwork.getAllNetworks(this, 1);
        for (IRedstoneNetwork network : networks) {
            if (network == this) continue;
            network.onNetworkPowerChanged(this);
        }
    }

    @Override
    public void onNetworkPowerChanged(IRedstoneNetwork network) {
        if (this.isActive(Math.max(this.getLocalPower(), this.getGlobalPower())) != this.isActive(Math.max(network.getLocalPower(), network.getGlobalPower()))) {
            this.updateGlobalPower();
        }
    }

    public static List<IRedstoneNetwork> getAllNetworks(IRedstoneNetwork network, int networkType) {
        ArrayList<IRedstoneNetwork> networks = new ArrayList<IRedstoneNetwork>();
        RedstoneNetwork.addSubNetworks(networks, network, networkType);
        return networks;
    }

    public static void addSubNetworks(List<IRedstoneNetwork> building, IRedstoneNetwork network, int networkType) {
        building.add(network);
        List subNetworks = network.getListenerList().getListeners(new int[]{networkType});
        for (IRedstoneNetwork sub : subNetworks) {
            if (!sub.isValid() || building.contains(sub)) continue;
            RedstoneNetwork.addSubNetworks(building, sub, networkType);
        }
    }

    public boolean isActive(int power) {
        return power > 0;
    }

    public boolean isValid() {
        return true;
    }

    public ListenableList<IRedstoneNetwork> getListenerList() {
        return this.subNetworks;
    }
}

