/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.data;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import sonar.core.helpers.FunctionHelper;
import sonar.logistics.PL2;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.base.ServerInfoHandler;
import sonar.logistics.base.data.api.IData;
import sonar.logistics.base.data.api.IDataFactory;
import sonar.logistics.base.data.api.IDataGenerator;
import sonar.logistics.base.data.api.IDataHolder;
import sonar.logistics.base.data.api.IDataWatcher;
import sonar.logistics.base.data.holders.DataHolderEmpty;
import sonar.logistics.base.data.holders.DataHolderMultiSource;
import sonar.logistics.base.data.sources.IDataMultiSource;
import sonar.logistics.base.data.sources.IDataSource;

public class DataFactory {
    public List<IDataGenerator> GENERATORS = new ArrayList<IDataGenerator>();
    public List<IDataWatcher> ADDED_WATCHERS = new ArrayList<IDataWatcher>();
    public List<IDataWatcher> REMOVED_WATCHERS = new ArrayList<IDataWatcher>();
    public Map<InfoUUID, IDataWatcher> LOADED_WATCHERS = new HashMap<InfoUUID, IDataWatcher>();
    public Map<IDataSource, List<IDataHolder>> HOLDER_SOURCE_MAP = new HashMap<IDataSource, List<IDataHolder>>();
    public Map<IDataMultiSource, List<DataHolderMultiSource>> HOLDER_MULTI_SOURCE_MAP = new HashMap<IDataMultiSource, List<DataHolderMultiSource>>();

    public static DataFactory instance() {
        return PL2.proxy.dataFactory;
    }

    public void removeAll() {
        this.ADDED_WATCHERS.clear();
        this.REMOVED_WATCHERS.clear();
        this.LOADED_WATCHERS.clear();
        this.HOLDER_SOURCE_MAP.clear();
        this.HOLDER_MULTI_SOURCE_MAP.clear();
    }

    public void flushWatchers() {
        this.ADDED_WATCHERS.forEach(watcher -> watcher.getDataHolders().stream().filter(h -> h != null).forEach(h -> h.addWatcher((IDataWatcher)watcher)));
        this.REMOVED_WATCHERS.forEach(watcher -> watcher.getDataHolders().stream().filter(h -> h != null).forEach(h -> h.removeWatcher((IDataWatcher)watcher)));
        this.ADDED_WATCHERS.clear();
        this.REMOVED_WATCHERS.clear();
    }

    public void flushUpdates() {
        this.HOLDER_SOURCE_MAP.values().forEach(l -> l.forEach(h -> {
            h.tick();
            if (h.canUpdateData()) {
                h.getGenerator().generateData(h, h.getData(), h.getSource());
                h.onDataChanged();
            }
        }));
        this.HOLDER_MULTI_SOURCE_MAP.values().forEach(l -> l.forEach(h -> {
            h.tick();
            if (h.canUpdateData()) {
                h.updateMultiSourceData();
            }
        }));
    }

    @Nonnull
    public <D extends IData> IDataHolder<D> getOrCreateDataHolder(IDataSource source, IDataFactory<D> factory, int tickRate) {
        Optional<IDataHolder<D>> holder = this.getDataHolder(source, factory.create());
        if (holder.isPresent()) {
            return holder.get();
        }
        if (source instanceof IDataMultiSource) {
            IDataMultiSource multiSource = (IDataMultiSource)source;
            DataHolderMultiSource newHolder = new DataHolderMultiSource(multiSource, factory, tickRate);
            multiSource.getDataSources().forEach(s -> {
                IDataHolder created = this.getOrCreateDataHolder((IDataSource)s, factory, tickRate);
                if (created.isValid()) {
                    newHolder.addDataHolder(created);
                }
            });
            if (!newHolder.getDataHolders().isEmpty()) {
                newHolder.getDataHolders().forEach(h -> ((IDataHolder)h).addWatcher(newHolder));
                this.HOLDER_MULTI_SOURCE_MAP.computeIfAbsent(multiSource, FunctionHelper.ARRAY).add(newHolder);
                return newHolder;
            }
        } else {
            D data = factory.create();
            IDataHolder<D> newHolder = data.createHolder(source, data, tickRate);
            if (newHolder != null) {
                this.HOLDER_SOURCE_MAP.computeIfAbsent(source, FunctionHelper.ARRAY).add(newHolder);
                return newHolder;
            }
        }
        return new DataHolderEmpty(source, (IData)factory.create(), tickRate);
    }

    public <D extends IData> Optional<IDataHolder<D>> getDataHolder(IDataSource source, D falseData) {
        List holders = (source instanceof IDataMultiSource ? this.HOLDER_MULTI_SOURCE_MAP : this.HOLDER_SOURCE_MAP).get(source);
        if (holders != null && !holders.isEmpty()) {
            for (IDataHolder holder : holders) {
                if (falseData.getClass() != holder.getData().getClass()) continue;
                return Optional.of(holder);
            }
        }
        return Optional.empty();
    }

    @Nullable
    public Optional<IDataGenerator> getValidGenerator(IDataSource source, IData data) {
        return this.GENERATORS.stream().filter(G -> G.canGenerateForSource(source) && G.canGenerateForData(data)).findFirst();
    }

    public void addDataSource(IDataSource source) {
    }

    public void removeDataSource(IDataSource source) {
        List<IDataHolder> holders = this.HOLDER_SOURCE_MAP.get(source);
        if (holders != null && !holders.isEmpty()) {
            holders.forEach(h -> h.onHolderDestroyed());
            holders.clear();
        }
    }

    public List<IDataGenerator> getDataGenerators() {
        return this.GENERATORS;
    }

    public Map<InfoUUID, IDataWatcher> getDataWatchers() {
        return this.LOADED_WATCHERS;
    }

    public void addWatcher(IDataWatcher watcher) {
        this.ADDED_WATCHERS.add(watcher);
    }

    public void removeWatcher(IDataWatcher watcher) {
        this.REMOVED_WATCHERS.add(watcher);
    }

    public void onWatcherChanged(IDataWatcher watcher) {
        watcher.getDataHolders().forEach(holder -> holder.onWatchersChanged());
    }

    public void onMultiSourceChanged(IDataMultiSource multiSource) {
        List<DataHolderMultiSource> holders = this.HOLDER_MULTI_SOURCE_MAP.get(multiSource);
        if (holders != null && !holders.isEmpty()) {
            for (DataHolderMultiSource mHolder : holders) {
                ArrayList oldHolders = Lists.newArrayList(mHolder.subDataHolders);
                ArrayList newHolders = new ArrayList();
                multiSource.getDataSources().forEach(s -> newHolders.add(this.getOrCreateDataHolder((IDataSource)s, mHolder.factory, mHolder.tickRate)));
                ArrayList<IDataHolder> removed = new ArrayList<IDataHolder>();
                for (IDataHolder ref : oldHolders) {
                    if (!newHolders.contains(ref)) {
                        removed.add(ref);
                        continue;
                    }
                    newHolders.remove(ref);
                }
                if (newHolders.isEmpty() && removed.isEmpty()) continue;
                newHolders.forEach(holder -> mHolder.addDataHolder(holder));
                removed.forEach(holder -> mHolder.removeDataHolder(holder));
            }
        }
    }

    public void sendInfoPackets() {
        for (Map.Entry<InfoUUID, IDataWatcher> entry : this.LOADED_WATCHERS.entrySet()) {
            if (!entry.getValue().isWatched()) continue;
            IInfo iInfo = ServerInfoHandler.instance().getInfoMap().get(entry.getKey());
        }
    }
}

