/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics;

import mcmultipart.api.slot.IPartSlot;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sonar.logistics.PL2ASMLoader;
import sonar.logistics.PL2Blocks;
import sonar.logistics.PL2Config;
import sonar.logistics.PL2Crafting;
import sonar.logistics.PL2Items;
import sonar.logistics.base.events.PL2Events;
import sonar.logistics.base.utils.commands.CommandResetInfoRegistry;
import sonar.logistics.base.utils.slots.EnumDisplayFaceSlot;
import sonar.logistics.base.utils.worlddata.ConnectedDisplayData;
import sonar.logistics.base.utils.worlddata.GSIData;
import sonar.logistics.base.utils.worlddata.IdentityCountData;
import sonar.logistics.base.utils.worldgen.SapphireOreGen;
import sonar.logistics.core.tiles.displays.info.MasterInfoRegistry;
import sonar.logistics.core.tiles.displays.tiles.holographic.EntityHolographicDisplay;
import sonar.logistics.network.PL2Common;

@Mod.EventBusSubscriber
@Mod(modid="practicallogistics2", name="Practical Logistics 2", dependencies="required-after:sonarcore@[5.0.18,);required-after:mcmultipart@[2.5.3,);", version="3.0.8", acceptedMinecraftVersions="[1.12.2]")
public class PL2 {
    @SidedProxy(clientSide="sonar.logistics.network.PL2Client", serverSide="sonar.logistics.network.PL2Common")
    public static PL2Common proxy;
    public static SimpleNetworkWrapper network;
    public static Logger logger;
    @Mod.Instance(value="practicallogistics2")
    public static PL2 instance;
    public static CreativeTabs creativeTab;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger.info("Releasing the Kraken");
        if (!Loader.isModLoaded((String)"SonarCore") && !Loader.isModLoaded((String)"sonarcore")) {
            logger.fatal("Sonar Core is not loaded");
        } else {
            logger.info("Successfully loaded with Sonar Core");
        }
        network = NetworkRegistry.INSTANCE.newSimpleChannel("practicallogistics2");
        logger.info("Registered Network");
        PL2Common.registerPackets();
        logger.info("Registered Packets");
        PL2Config.initConfiguration(event);
        logger.info("Loaded Configuration");
        PL2Blocks.registerBlocks();
        logger.info("Loaded Blocks");
        PL2Items.registerItems();
        logger.info("Loaded Items");
        if (PL2Config.sapphireOre) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new SapphireOreGen(), (int)1);
            logger.info("Registered Sapphire World Generator");
        } else {
            logger.info("Sapphire Ore Generation is disabled in the config");
        }
        PL2ASMLoader.init(event);
        MasterInfoRegistry.INSTANCE.init();
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        logger.info("Breaking into the pentagon");
        PL2Crafting.addRecipes();
        logger.info("Registered Crafting Recipes");
        for (EnumDisplayFaceSlot slot : EnumDisplayFaceSlot.values()) {
            GameRegistry.findRegistry(IPartSlot.class).register((IForgeRegistryEntry)slot);
        }
        OreDictionary.registerOre((String)"oreSapphire", (Block)PL2Blocks.sapphire_ore);
        OreDictionary.registerOre((String)"gemSapphire", (Item)PL2Items.sapphire);
        OreDictionary.registerOre((String)"dustSapphire", (Item)PL2Items.sapphire_dust);
        logger.info("Registered OreDict");
        MinecraftForge.EVENT_BUS.register((Object)new PL2Events());
        logger.info("Registered Event Handlers");
        proxy.load(event);
    }

    @Mod.EventHandler
    public void postLoad(FMLPostInitializationEvent evt) {
        logger.info("Please Wait: We are saving Harambe with a time machine");
        proxy.postLoad(evt);
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandResetInfoRegistry());
        MapStorage storage = DimensionManager.getWorld((int)0).func_175693_T();
        if (storage.func_75742_a(IdentityCountData.class, "sonar.logistics.base.connections.identitycount") == null) {
            storage.func_75745_a("sonar.logistics.base.connections.identitycount", (WorldSavedData)new IdentityCountData());
        }
        if (storage.func_75742_a(ConnectedDisplayData.class, "sonar.logistics.base.connections.gsiMap") == null) {
            storage.func_75745_a("sonar.logistics.base.connections.gsiMap", (WorldSavedData)new ConnectedDisplayData());
        }
        if (storage.func_75742_a(GSIData.class, "sonar.logistics.base.connections.gsi") == null) {
            storage.func_75745_a("sonar.logistics.base.connections.gsi", (WorldSavedData)new GSIData());
        }
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> e) {
        EntityEntry holographic_display = new EntityEntry(EntityHolographicDisplay.class, "pl2_holographic_display"){

            public EntityList.EntityEggInfo getEgg() {
                return null;
            }

            public void setEgg(EntityList.EntityEggInfo egg) {
            }
        };
        e.getRegistry().register(holographic_display.setRegistryName("practicallogistics2", "pl2_holographic_display"));
    }

    @Mod.EventHandler
    public void serverClose(FMLServerStoppedEvent event) {
        proxy.removeAll();
    }

    static {
        logger = LogManager.getLogger((String)"practicallogistics2");
        creativeTab = new CreativeTabs("Practical Logistics 2"){

            public ItemStack func_78016_d() {
                return new ItemStack(PL2Items.etched_plate);
            }
        };
    }
}

