/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.network;

import com.m4thg33k.tombmanygraves.network.BaseThreadsafePacket;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PacketFileNames
extends BaseThreadsafePacket {
    private List<String> files = new ArrayList<String>();
    private BlockPos pos;

    public PacketFileNames() {
    }

    public PacketFileNames(BlockPos pos, List<String> fileNames) {
        this.pos = pos;
        this.files.addAll(fileNames);
    }

    @Override
    public void handleClientSafe(NetHandlerPlayClient netHandler) {
    }

    @Override
    public void handleServerSafe(NetHandlerPlayServer netHandler) {
        throw new UnsupportedOperationException("Client-side only!");
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = this.readPos(buf);
        this.files = new ArrayList<String>();
        for (int size = buf.readInt(); size > 0; --size) {
            this.files.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        this.writePos(this.pos, buf);
        buf.writeInt(this.files.size());
        for (String file : this.files) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)file);
        }
    }
}

