/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.themes;

import jaredbgreat.dldungeons.builder.DBlock;
import jaredbgreat.dldungeons.nbt.NBTHelper;
import jaredbgreat.dldungeons.parser.Tokenizer;
import jaredbgreat.dldungeons.pieces.chests.LootCategory;
import jaredbgreat.dldungeons.pieces.chests.LootHandler;
import jaredbgreat.dldungeons.pieces.chests.LootItem;
import jaredbgreat.dldungeons.pieces.chests.LootListSet;
import jaredbgreat.dldungeons.pieces.chests.TreasureChest;
import jaredbgreat.dldungeons.setup.Externalizer;
import jaredbgreat.dldungeons.themes.Element;
import jaredbgreat.dldungeons.themes.SizeElement;
import jaredbgreat.dldungeons.themes.Theme;
import jaredbgreat.dldungeons.themes.ThemeFlags;
import jaredbgreat.dldungeons.themes.ThemeType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraftforge.common.BiomeDictionary;

public class ThemeReader {
    private static File configDir;
    private static File themesDir;
    private static File chestDir;
    private static final String chestDirName = "SpecialChests";
    private static ArrayList<File> files;
    private static final String ESTRING = "";

    public static void setThemesDir(File dir) {
        System.out.println("[DLDUNGEONS] themesdir is " + dir);
        themesDir = dir;
    }

    public static void setConfigDir(File dir) {
        System.out.println("[DLDUNGEONS] themesdir is " + dir);
        configDir = dir;
    }

    public static String getThemesDir() {
        return themesDir + File.separator;
    }

    public static String getConfigDir() {
        return configDir + File.separator;
    }

    private static int findChestFiles(File dir) {
        int num = 0;
        files = new ArrayList();
        String[] fileNames = dir.list();
        if (fileNames.length < 1) {
            return 0;
        }
        for (String name : fileNames) {
            if (name.length() < 5 || !name.substring(name.length() - 4).equals(".cfg")) continue;
            files.add(new File(name));
            ++num;
        }
        return num;
    }

    private static int findThemeFiles(File dir) {
        int num = 0;
        files = new ArrayList();
        String[] fileNames = dir.list();
        if (fileNames.length < 1) {
            Externalizer exporter = new Externalizer(dir.toString() + File.separator);
            exporter.makeThemes();
            fileNames = dir.list();
        }
        if (fileNames.length < 1) {
            return 0;
        }
        for (String name : fileNames) {
            if (name.length() < 5 || name.equals("template.cfg") || !name.substring(name.length() - 4).equals(".cfg")) continue;
            files.add(new File(name));
            ++num;
        }
        return num;
    }

    public static void readThemes() {
        TreasureChest.initSlots();
        ThemeReader.openNBTConfig();
        ThemeReader.openLoot("chests.cfg", true);
        chestDir = new File(configDir.toString() + File.separator + chestDirName);
        if (!chestDir.exists()) {
            chestDir.mkdir();
        }
        int num = ThemeReader.findChestFiles(chestDir);
        System.out.println("[DLDUNGEONS] Found " + num + " special chest configs.");
        for (File file : files) {
            ThemeReader.openLoot(file.toString(), false);
        }
        num = ThemeReader.findThemeFiles(themesDir);
        System.out.println("[DLDUNGEONS] Found " + num + " themes.");
        for (File file : files) {
            ThemeReader.readTheme(file);
        }
    }

    public static void openNBTConfig() {
        BufferedReader instream = null;
        File nbtconfig = new File(configDir.toString() + File.separator + "nbt.cfg");
        if (nbtconfig.exists()) {
            try {
                instream = new BufferedReader(new FileReader(nbtconfig.toString()));
                ThemeReader.readNBT(instream);
                if (instream != null) {
                    instream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("[DLDUNGEONS] File nbt.cfg is missing; will fallabck on default loot");
        }
    }

    public static void readNBT(BufferedReader instream) throws IOException {
        System.out.println("[DLDUNGEONS] Loading custom NBT tags (nbt.cfg)");
        Object tokens = null;
        String line = null;
        while ((line = instream.readLine()) != null) {
            if (line.length() < 2 || line.charAt(0) == '#') continue;
            NBTHelper.parseNBTLine(line);
        }
    }

    public static void openLoot(String name, boolean isMain) {
        LootCategory cat = LootHandler.getLootHandler().createCategory(name);
        BufferedReader instream = null;
        File chests = isMain ? new File(configDir.toString() + File.separator + name) : new File(configDir.toString() + File.separator + chestDirName + File.separator + name);
        if (chests.exists()) {
            try {
                instream = new BufferedReader(new FileReader(chests.toString()));
                ThemeReader.readLoot(instream, name, cat.getLists());
                if (instream != null) {
                    instream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("[DLDUNGEONS] File " + name + " is missing; will fallabck on default loot");
            cat.getLists().addDefaultLoot();
        }
    }

    public static void readLoot(BufferedReader instream, String filename, LootListSet loots) throws IOException {
        System.out.println("[DLDUNGEONS] Loading chest loot file (" + filename + ")");
        Tokenizer tokens = null;
        String line = null;
        while ((line = instream.readLine()) != null) {
            if (line.length() < 2 || line.charAt(0) == '#' || !(tokens = new Tokenizer(line, " ,;:\t\n\r\f=")).hasMoreTokens()) continue;
            String type = tokens.nextToken().toLowerCase();
            if (!tokens.hasMoreTokens()) continue;
            int level = ThemeReader.intParser(tokens);
            if (!tokens.hasMoreTokens() || level == 0) continue;
            String modid = tokens.nextToken();
            if (modid.toLowerCase().equals("item") || modid.toLowerCase().equals("block")) {
                modid = "minecraft";
            }
            if (!tokens.hasMoreTokens()) continue;
            String name = tokens.nextToken();
            if (!tokens.hasMoreTokens()) continue;
            int min = ThemeReader.intParser(tokens);
            if (!tokens.hasMoreTokens() || min < 1) continue;
            int max = ThemeReader.intParser(tokens);
            String item = modid + ":" + name;
            LootItem loot = new LootItem(item, min, max);
            if (item == null || loot == null) continue;
            while (tokens.hasMoreTokens()) {
                loot.addNbt(tokens.nextToken());
            }
            loot.trimNbt();
            loots.addItem(loot, type, level);
        }
        loots.addDiscs();
    }

    private static void readTheme(File file) {
        BufferedReader instream = null;
        try {
            instream = new BufferedReader(new FileReader(themesDir.toString() + File.separator + file.toString()));
            ThemeReader.parseTheme(instream, file.toString());
            if (instream != null) {
                instream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchElementException e) {
            File errorFile;
            if (instream != null) {
                try {
                    instream.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            System.err.println("[DLDUNGEONS] Theme " + file.toString() + " contained a fatal error!");
            e.printStackTrace();
            File broken = new File(themesDir.toString() + File.separator + file.toString());
            File errorDir = new File(themesDir.toString() + File.separator + "errors");
            if (!errorDir.exists()) {
                errorDir.mkdir();
            }
            int i = 0;
            while ((errorFile = new File(errorDir.toString() + File.separator + file.toString() + ".err" + i++)).exists()) {
            }
            if (!broken.renameTo(errorFile)) {
                try {
                    Files.move(broken.toPath(), errorFile.toPath(), new CopyOption[0]);
                }
                catch (IOException ex) {
                    Logger.getLogger(ThemeReader.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (errorFile.exists()) {
                System.err.println("[DLDUNGEONS] Theme " + errorFile + " was renamed to prevent  further reading attempts; please fix it.");
            }
            System.err.println("[DLDUNGEONS] Theme " + errorFile + " was NOT renamed to prevent  further reading attempts (please fix it); something went wrong!");
        }
    }

    public static void parseTheme(BufferedReader instream, String name) throws IOException, NoSuchElementException {
        Theme theme = new Theme();
        theme.name = name;
        theme.version = 1.0f;
        Tokenizer tokens = null;
        String line = null;
        String delimeters = " ,:;\t\n\r\f=";
        while ((line = instream.readLine()) != null) {
            if (line.length() < 2 || line.charAt(0) == '#' || !(tokens = new Tokenizer(line, delimeters)).hasMoreTokens()) continue;
            String token = tokens.nextToken().toLowerCase();
            if (token.equals("miny")) {
                theme.minY = ThemeReader.intParser(theme.minY, tokens);
                continue;
            }
            if (token.equals("maxy")) {
                theme.maxY = ThemeReader.intParser(theme.maxY, tokens);
                continue;
            }
            if (token.equals("buildfoundation")) {
                theme.buildFoundation = ThemeReader.booleanParser(theme.buildFoundation, tokens);
                continue;
            }
            if (token.equals("sizes")) {
                theme.sizes = ThemeReader.sizeParser(theme.sizes, tokens);
                continue;
            }
            if (token.equals("dimensionwhitelist")) {
                theme.dimensionWhitelist = ThemeReader.dimensionParser(tokens);
                continue;
            }
            if (token.equals("outside")) {
                theme.outside = ThemeReader.elementParser(theme.outside, tokens);
                continue;
            }
            if (token.equals("liquids")) {
                theme.liquids = ThemeReader.elementParser(theme.liquids, tokens);
                continue;
            }
            if (token.equals("subrooms")) {
                theme.subrooms = ThemeReader.elementParser(theme.subrooms, tokens);
                continue;
            }
            if (token.equals("islands")) {
                theme.islands = ThemeReader.elementParser(theme.islands, tokens);
                continue;
            }
            if (token.equals("pillars")) {
                theme.pillars = ThemeReader.elementParser(theme.pillars, tokens);
                continue;
            }
            if (token.equals("symmetry")) {
                theme.symmetry = ThemeReader.elementParser(theme.symmetry, tokens);
                continue;
            }
            if (token.equals("variability")) {
                theme.variability = ThemeReader.elementParser(theme.variability, tokens);
                continue;
            }
            if (token.equals("degeneracy")) {
                theme.degeneracy = ThemeReader.elementParser(theme.degeneracy, tokens);
                continue;
            }
            if (token.equals("complexity")) {
                theme.complexity = ThemeReader.elementParser(theme.complexity, tokens);
                continue;
            }
            if (token.equals("verticle")) {
                theme.verticle = ThemeReader.elementParser(theme.verticle, tokens);
                continue;
            }
            if (token.equals("naturals")) {
                theme.naturals = ThemeReader.elementParser(theme.naturals, tokens);
                continue;
            }
            if (token.equals("entrances")) {
                theme.entrances = ThemeReader.elementParser(theme.entrances, tokens);
                continue;
            }
            if (token.equals("walls")) {
                theme.walls = ThemeReader.blockParser(theme.walls, tokens, theme.version);
                continue;
            }
            if (token.equals("caveblock")) {
                theme.caveWalls = ThemeReader.blockParser(theme.caveWalls, tokens, theme.version);
                continue;
            }
            if (token.equals("floors")) {
                theme.floors = ThemeReader.blockParser(theme.floors, tokens, theme.version);
                continue;
            }
            if (token.equals("ceilings")) {
                theme.ceilings = ThemeReader.blockParser(theme.ceilings, tokens, theme.version);
                continue;
            }
            if (token.equals("fencing")) {
                theme.fencing = ThemeReader.blockParser(theme.fencing, tokens, theme.version);
                continue;
            }
            if (token.equals("liquid")) {
                theme.liquid = ThemeReader.blockParser(theme.liquid, tokens, theme.version);
                continue;
            }
            if (token.equals("pillarblock")) {
                theme.pillarBlock = ThemeReader.blockParser(theme.pillarBlock, tokens, theme.version);
                continue;
            }
            if (token.equals("commonmobs")) {
                theme.commonMobs = ThemeReader.parseMobs(theme.commonMobs, tokens);
                continue;
            }
            if (token.equals("hardmobs")) {
                theme.hardMobs = ThemeReader.parseMobs(theme.hardMobs, tokens);
                continue;
            }
            if (token.equals("brutemobs")) {
                theme.bruteMobs = ThemeReader.parseMobs(theme.bruteMobs, tokens);
                continue;
            }
            if (token.equals("elitemobs")) {
                theme.eliteMobs = ThemeReader.parseMobs(theme.eliteMobs, tokens);
                continue;
            }
            if (token.equals("bossmobs")) {
                theme.bossMobs = ThemeReader.parseMobs(theme.bossMobs, tokens);
                continue;
            }
            if (token.equals("biomes")) {
                theme.biomes = ThemeReader.biomeParser(tokens);
                continue;
            }
            if (token.equals("notinbiomes")) {
                theme.notIn = ThemeReader.biomeParser(tokens);
                continue;
            }
            if (token.equals("chestsfile")) {
                theme.lootCat = tokens.nextToken();
                continue;
            }
            if (token.equals("type")) {
                theme.type = ThemeReader.typeParser(tokens);
                for (ThemeType type : theme.type) {
                    ThemeType.addThemeToType(theme, type);
                }
                if (theme.version > 1.4f) continue;
                if (theme.type.contains((Object)ThemeType.WATER)) {
                    theme.flags.add(ThemeFlags.WATER);
                }
                if (!theme.type.contains((Object)ThemeType.SWAMP)) continue;
                theme.flags.add(ThemeFlags.SWAMPY);
                continue;
            }
            if (token.equals("flags")) {
                theme.flags = ThemeReader.flagParser(tokens);
                continue;
            }
            if (!token.equals("version")) continue;
            theme.version = ThemeReader.floatParser(theme.version, tokens);
            if ((double)theme.version > 1.6) {
                delimeters = " ,;\t\n\r\f=";
                continue;
            }
            delimeters = " ,;:\t\n\r\f=";
        }
        theme.fixMobs();
        theme.biomeRegister();
        if (theme.caveWalls.length < 1) {
            theme.caveWalls = theme.walls;
        }
    }

    private static Element elementParser(Element el, Tokenizer tokens) {
        boolean valid = false;
        int[] values = new int[]{0, 0, 0, 0, 0, 0};
        for (int i = 0; i < values.length && tokens.hasMoreTokens(); ++i) {
            String num = tokens.nextToken();
            values[i] = Integer.parseInt(num);
            if (values[i] < 0) {
                values[i] = 0;
            }
            if (values[i] <= 0) continue;
            valid = true;
        }
        if (valid) {
            return new Element(values[0], values[1], values[2], values[3], values[4], values[5]);
        }
        return el;
    }

    private static SizeElement sizeParser(SizeElement el, Tokenizer tokens) {
        boolean valid = false;
        int[] values = new int[]{0, 0, 0, 0, 0};
        for (int i = 0; i < values.length && tokens.hasMoreTokens(); ++i) {
            String num = tokens.nextToken();
            values[i] = Integer.parseInt(num);
            if (values[i] < 0) {
                values[i] = 0;
            }
            if (values[i] <= 0) continue;
            valid = true;
        }
        if (valid) {
            return new SizeElement(values[0], values[1], values[2], values[3], values[4]);
        }
        return el;
    }

    private static int[] dimensionParser(Tokenizer tokens) {
        if (tokens.getToken(1) == null || tokens.getToken(1).equalsIgnoreCase("all")) {
            return new int[0];
        }
        int[] rtn = new int[tokens.countTokens() - 1];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            rtn[i++] = Integer.parseInt(tokens.nextToken());
        }
        return rtn;
    }

    private static int intParser(int el, Tokenizer tokens) {
        boolean valid = false;
        int value = 0;
        String num = ESTRING;
        try {
            if (tokens.hasMoreTokens() && (value = Integer.parseInt(num = tokens.nextToken())) > 5 && value < 224) {
                valid = true;
            }
        }
        catch (Exception e) {
            System.err.println("[DLDUNGEONS] ThemeReader.intParser(int el, Tokenizer tokens) tried to read non-number as integer");
            System.err.println("[DLDUNGEONS] Value passed as and integer was: " + num);
            e.printStackTrace();
            return el;
        }
        if (valid) {
            return value;
        }
        return el;
    }

    private static float floatParser(float el, Tokenizer tokens) {
        float value = 0.0f;
        String num = ESTRING;
        try {
            if (tokens.hasMoreTokens()) {
                num = tokens.nextToken();
                value = Float.parseFloat(num);
            }
        }
        catch (Exception e) {
            System.err.println("[DLDUNGEONS] ThemeReader.floatParser(float el, Tokenizer tokens) tried to read non-number as float");
            System.err.println("[DLDUNGEONS] Value passed as and foat was: " + num);
            return el;
        }
        return value;
    }

    private static int intParser(Tokenizer tokens) {
        int value = 0;
        String num = ESTRING;
        try {
            if (tokens.hasMoreTokens()) {
                num = tokens.nextToken().trim();
                value = Integer.parseInt(num);
            }
        }
        catch (Exception e) {
            System.err.println("[DLDUNGEONS] ThemeReader.intParser(Tokenizer tokens) tried to read non-number as integer");
            System.err.println("[DLDUNGEONS] Value passed as and integer was: " + num);
            return -1;
        }
        return value;
    }

    private static boolean booleanParser(boolean el, Tokenizer tokens) {
        boolean valid = false;
        if (!tokens.hasMoreTokens()) {
            return el;
        }
        boolean bool = Boolean.parseBoolean(tokens.nextToken());
        return bool;
    }

    private static int[] blockParser(int[] el, Tokenizer tokens, float version) throws NoSuchElementException {
        int i;
        ArrayList<String> values = new ArrayList<String>();
        while (tokens.hasMoreTokens()) {
            String nums = tokens.nextToken();
            values.add(String.valueOf(DBlock.add(nums)));
        }
        int[] out = new int[values.size() + el.length];
        for (i = 0; i < el.length; ++i) {
            out[i] = el[i];
        }
        for (i = 0; i < values.size(); ++i) {
            out[i + el.length] = Integer.parseInt((String)values.get(i));
        }
        return out;
    }

    private static ArrayList<String> parseMobs(ArrayList<String> el, Tokenizer tokens) {
        ArrayList<String> mobs = el != null ? el : new ArrayList();
        while (tokens.hasMoreTokens()) {
            String nextMob = tokens.nextToken();
            mobs.add(nextMob);
        }
        return mobs;
    }

    private static HashSet<BiomeDictionary.Type> biomeParser(Tokenizer tokens) {
        HashSet<BiomeDictionary.Type> biomes = new HashSet<BiomeDictionary.Type>();
        while (tokens.hasMoreTokens()) {
            String name = tokens.nextToken().toUpperCase();
            if (name.equals("FOREST")) {
                biomes.add(BiomeDictionary.Type.FOREST);
                continue;
            }
            if (name.equals("PLAINS")) {
                biomes.add(BiomeDictionary.Type.PLAINS);
                continue;
            }
            if (name.equals("MOUNTAINS")) {
                biomes.add(BiomeDictionary.Type.MOUNTAIN);
                continue;
            }
            if (name.equals("HILLS")) {
                biomes.add(BiomeDictionary.Type.HILLS);
                continue;
            }
            if (name.equals("SWAMP")) {
                biomes.add(BiomeDictionary.Type.SWAMP);
                continue;
            }
            if (name.equals("WATER")) {
                biomes.add(BiomeDictionary.Type.WATER);
                continue;
            }
            if (name.equals("JUNGLE")) {
                biomes.add(BiomeDictionary.Type.JUNGLE);
                continue;
            }
            if (name.equals("WASTELAND")) {
                biomes.add(BiomeDictionary.Type.WASTELAND);
                continue;
            }
            if (name.equals("BEACH")) {
                biomes.add(BiomeDictionary.Type.BEACH);
                continue;
            }
            if (name.equals("NETHER")) {
                biomes.add(BiomeDictionary.Type.NETHER);
                continue;
            }
            if (name.equals("END")) {
                biomes.add(BiomeDictionary.Type.END);
                continue;
            }
            if (name.equals("MUSHROOM")) {
                biomes.add(BiomeDictionary.Type.MUSHROOM);
                continue;
            }
            if (name.equals("MAGICAL")) {
                biomes.add(BiomeDictionary.Type.MAGICAL);
                continue;
            }
            if (name.equals("HOT")) {
                biomes.add(BiomeDictionary.Type.HOT);
                continue;
            }
            if (name.equals("COLD")) {
                biomes.add(BiomeDictionary.Type.COLD);
                continue;
            }
            if (name.equals("DENSE")) {
                biomes.add(BiomeDictionary.Type.DENSE);
                continue;
            }
            if (name.equals("SPARSE")) {
                biomes.add(BiomeDictionary.Type.SPARSE);
                continue;
            }
            if (name.equals("WET")) {
                biomes.add(BiomeDictionary.Type.WET);
                continue;
            }
            if (name.equals("DRY")) {
                biomes.add(BiomeDictionary.Type.DRY);
                continue;
            }
            if (name.equals("SAVANNA")) {
                biomes.add(BiomeDictionary.Type.SAVANNA);
                continue;
            }
            if (name.equals("CONIFEROUS")) {
                biomes.add(BiomeDictionary.Type.CONIFEROUS);
                continue;
            }
            if (name.equals("SPOOKY")) {
                biomes.add(BiomeDictionary.Type.SPOOKY);
                continue;
            }
            if (name.equals("DEAD")) {
                biomes.add(BiomeDictionary.Type.DEAD);
                continue;
            }
            if (name.equals("LUSH")) {
                biomes.add(BiomeDictionary.Type.LUSH);
                continue;
            }
            if (name.equals("MESA")) {
                biomes.add(BiomeDictionary.Type.MESA);
                continue;
            }
            if (name.equals("SANDY")) {
                biomes.add(BiomeDictionary.Type.SANDY);
                continue;
            }
            if (!name.equals("SNOWY")) continue;
            biomes.add(BiomeDictionary.Type.SNOWY);
        }
        return biomes;
    }

    private static EnumSet<ThemeType> typeParser(Tokenizer tokens) {
        EnumSet<ThemeType> types = EnumSet.noneOf(ThemeType.class);
        while (tokens.hasMoreTokens()) {
            String name = tokens.nextToken().toUpperCase();
            if (name.equals("FOREST")) {
                types.add(ThemeType.FOREST);
                continue;
            }
            if (name.equals("PLAINS")) {
                types.add(ThemeType.PLAINS);
                continue;
            }
            if (name.equals("MOUNTAINS")) {
                types.add(ThemeType.MOUNTAIN);
                continue;
            }
            if (name.equals("SWAMP")) {
                types.add(ThemeType.SWAMP);
                continue;
            }
            if (name.equals("WATER")) {
                types.add(ThemeType.WATER);
                continue;
            }
            if (name.equals("DESERT")) {
                types.add(ThemeType.DESERT);
                continue;
            }
            if (name.equals("FROZEN")) {
                types.add(ThemeType.FROZEN);
                continue;
            }
            if (name.equals("JUNGLE")) {
                types.add(ThemeType.JUNGLE);
                continue;
            }
            if (name.equals("WASTELAND")) {
                types.add(ThemeType.WASTELAND);
                continue;
            }
            if (name.equals("NETHER")) {
                types.add(ThemeType.NETHER);
                continue;
            }
            if (name.equals("END")) {
                types.add(ThemeType.END);
                continue;
            }
            if (name.equals("MUSHROOM")) {
                types.add(ThemeType.MUSHROOM);
                continue;
            }
            if (name.equals("MAGICAL")) {
                types.add(ThemeType.MAGICAL);
                continue;
            }
            if (name.equals("DUNGEON")) {
                types.add(ThemeType.DUNGEON);
                continue;
            }
            if (name.equals("URBAN")) {
                types.add(ThemeType.URBAN);
                continue;
            }
            if (name.equals("NECRO")) {
                types.add(ThemeType.NECRO);
                continue;
            }
            if (name.equals("FIERY")) {
                types.add(ThemeType.FIERY);
                continue;
            }
            if (name.equals("SHADOW")) {
                types.add(ThemeType.SHADOW);
                continue;
            }
            if (name.equals("TECH")) {
                types.add(ThemeType.TECH);
                continue;
            }
            if (!name.equals("PARADISE")) continue;
            types.add(ThemeType.PARADISE);
        }
        return types;
    }

    private static EnumSet<ThemeFlags> flagParser(Tokenizer tokens) {
        EnumSet<ThemeFlags> flags = EnumSet.noneOf(ThemeFlags.class);
        while (tokens.hasMoreTokens()) {
            String name = tokens.nextToken().toUpperCase();
            if (name.equals("SWAMPY")) {
                flags.add(ThemeFlags.SWAMPY);
                continue;
            }
            if (name.equals("WATER")) {
                flags.add(ThemeFlags.WATER);
                continue;
            }
            if (!name.equals("SURFACE")) continue;
            flags.add(ThemeFlags.SURFACE);
        }
        return flags;
    }
}

