/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.builder;

import jaredbgreat.dldungeons.api.DLDEvent;
import jaredbgreat.dldungeons.debug.Logging;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.GameRegistry;

public final class DBlock {
    private final String id;
    private final IBlockState block;
    public static final Block spawner = Block.func_149684_b((String)"mob_spawner");
    public static final Block chest = Block.func_149684_b((String)"chest");
    public static final Block portal1 = Block.func_149684_b((String)"end_portal_frame");
    public static final Block portal2 = Block.func_149684_b((String)"end_portal");
    public static final Block quartz = Block.func_149684_b((String)"quartz_block");
    public static final Block lapis = Block.func_149684_b((String)"lapis_block");
    public static final Block water = Block.func_149684_b((String)"water");
    public static final Block air = Block.func_149684_b((String)"air");
    public static final int chestid = Block.func_149682_b((Block)chest);
    public static final int spawnerid = Block.func_149682_b((Block)spawner);
    public static final int portal1id = Block.func_149682_b((Block)portal1);
    public static final int portal2id = Block.func_149682_b((Block)portal2);
    public static final ArrayList<DBlock> registry = new ArrayList();

    private static Item getItem(String in) {
        return (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(in));
    }

    private DBlock(String id) throws NoSuchElementException {
        this.id = id;
        StringTokenizer nums = new StringTokenizer(id, ":({[]})");
        String modid = nums.nextToken();
        ResourceLocation name = new ResourceLocation(modid + ":" + nums.nextToken());
        Block theBlock = (Block)GameRegistry.findRegistry(Block.class).getValue(name);
        if (theBlock == null) {
            String error = "[DLDUNGEONS] ERROR! Block read as \"" + id + "\" was was not in registry (returned null).";
            Logging.LogError(error);
            throw new NoSuchElementException(error);
        }
        int meta = nums.hasMoreElements() ? Integer.parseInt(nums.nextToken()) : 0;
        this.block = theBlock.func_176203_a(meta);
        if (this.block.toString().contains("minecraft:air") && !id.contains("minecraft:air")) {
            String error = "[DLDUNGEONS] ERROR! Block read as \"" + id + "\" parsed into an air block!";
            Logging.LogError(error);
            throw new NoSuchElementException(error);
        }
    }

    @Deprecated
    public void placeNoMeta(World world, int x, int y, int z) {
        if (DBlock.isProtectedBlock(world, x, y, z)) {
            return;
        }
        BlockPos pos = new BlockPos(x, y, z);
        if (MinecraftForge.TERRAIN_GEN_BUS.post((Event)new DLDEvent.PlaceDBlock(world, pos, this))) {
            return;
        }
        world.func_175656_a(new BlockPos(x, y, z), this.block);
    }

    public void place(World world, int x, int y, int z) {
        if (DBlock.isProtectedBlock(world, x, y, z)) {
            return;
        }
        BlockPos pos = new BlockPos(x, y, z);
        if (MinecraftForge.TERRAIN_GEN_BUS.post((Event)new DLDEvent.PlaceDBlock(world, pos, this))) {
            return;
        }
        world.func_175656_a(pos, this.block);
    }

    public static void place(World world, int x, int y, int z, int block) {
        if (!DBlock.isProtectedBlock(world, x, y, z)) {
            registry.get(block).place(world, x, y, z);
        }
    }

    public static int add(String id) throws NoSuchElementException {
        DBlock block = new DBlock(id);
        if (!registry.contains(block)) {
            registry.add(block);
        }
        return registry.indexOf(block);
    }

    public static boolean placeBlock(World world, int x, int y, int z, Block block) {
        if (DBlock.isProtectedBlock(world, x, y, z)) {
            return false;
        }
        BlockPos pos = new BlockPos(x, y, z);
        if (MinecraftForge.TERRAIN_GEN_BUS.post((Event)new DLDEvent.PlaceBlock(world, pos, block))) {
            return false;
        }
        world.func_175656_a(pos, block.func_176223_P());
        return true;
    }

    public static void placeBlock(World world, int x, int y, int z, Block block, int a, int b) {
        if (DBlock.isProtectedBlock(world, x, y, z)) {
            return;
        }
        world.func_175656_a(new BlockPos(x, y, z), block.func_176203_a(a));
    }

    public static void deleteBlock(World world, int x, int y, int z) {
        if (DBlock.isProtectedBlock(world, x, y, z)) {
            return;
        }
        world.func_175698_g(new BlockPos(x, y, z));
    }

    public static void deleteBlock(World world, int x, int y, int z, boolean flooded) {
        if (DBlock.isProtectedBlock(world, x, y, z)) {
            return;
        }
        if (flooded) {
            DBlock.placeBlock(world, x, y, z, water);
        } else {
            world.func_175698_g(new BlockPos(x, y, z));
        }
    }

    public static void placeChest(World world, int x, int y, int z) {
        DBlock.placeBlock(world, x, y, z, chest);
    }

    public static void placeSpawner(World world, int x, int y, int z, String mob) {
        BlockPos pos = new BlockPos(x, y, z);
        if (MinecraftForge.TERRAIN_GEN_BUS.post((Event)new DLDEvent.BeforePlaceSpawner(world, pos, mob))) {
            return;
        }
        if (DBlock.isProtectedBlock(world, x, y, z)) {
            return;
        }
        if (!DBlock.placeBlock(world, x, y, z, spawner)) {
            return;
        }
        TileEntityMobSpawner theSpawner = (TileEntityMobSpawner)world.func_175625_s(pos);
        MobSpawnerBaseLogic logic = theSpawner.func_145881_a();
        NBTTagCompound spawnData = new NBTTagCompound();
        spawnData.func_74778_a("id", mob);
        logic.func_184993_a(new WeightedSpawnerEntity(1, spawnData));
    }

    public static boolean isGroundBlock(World world, int x, int y, int z) {
        IBlockState bs = world.func_180495_p(new BlockPos(x, y, z));
        Material mat = bs.func_185904_a();
        return mat == Material.field_151577_b || mat == Material.field_151573_f || mat == Material.field_151578_c || mat == Material.field_151595_p || mat == Material.field_151576_e || mat == Material.field_151571_B || y < 0;
    }

    public static boolean isProtectedBlock(World world, int x, int y, int z) {
        int block = Block.func_149682_b((Block)world.func_180495_p(new BlockPos(x, y, z)).func_177230_c());
        return block == chestid || block == spawnerid || block == portal1id || block == portal2id;
    }

    public boolean equals(Object other) {
        if (!(other instanceof DBlock)) {
            return false;
        }
        return this.block.equals(((DBlock)other).block);
    }

    public int hashCode() {
        return this.block.hashCode();
    }
}

