/*
 * Decompiled with CFR 0.152.
 */
package QuantumStorage.multiblock;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;
import reborncore.common.multiblock.IMultiblockPart;
import reborncore.common.multiblock.MultiblockControllerBase;
import reborncore.common.multiblock.MultiblockValidationException;

public class MultiBlockCrate
extends MultiblockControllerBase {
    ItemStackHandler inv = new ItemStackHandler(this.size);
    public int size = 5;

    public MultiBlockCrate(World world) {
        super(world);
    }

    public void onAttachedPartWithMultiblockData(IMultiblockPart part, NBTTagCompound data) {
        this.readFromNBT(data);
    }

    protected void onBlockAdded(IMultiblockPart newPart) {
    }

    protected void onBlockRemoved(IMultiblockPart oldPart) {
        this.updateInfo();
    }

    protected void onMachineAssembled() {
        this.updateInfo();
    }

    protected void onMachineRestored() {
    }

    protected void onMachinePaused() {
    }

    protected void onMachineDisassembled() {
    }

    protected int getMinimumNumberOfBlocksForAssembledMachine() {
        return 1;
    }

    protected int getMaximumXSize() {
        return 16;
    }

    protected int getMaximumZSize() {
        return 16;
    }

    protected int getMaximumYSize() {
        return 16;
    }

    protected int getMinimumXSize() {
        return 1;
    }

    protected int getMinimumYSize() {
        return 1;
    }

    protected int getMinimumZSize() {
        return 1;
    }

    protected void isMachineWhole() throws MultiblockValidationException {
    }

    protected void onAssimilate(MultiblockControllerBase assimilated) {
    }

    protected void onAssimilated(MultiblockControllerBase assimilator) {
    }

    protected boolean updateServer() {
        return true;
    }

    protected void updateClient() {
    }

    public void writeToNBT(NBTTagCompound data) {
        data.func_74768_a("invSize", this.inv.getSlots());
        data.func_179237_a(this.inv.serializeNBT());
    }

    public void readFromNBT(NBTTagCompound data) {
        if (data.func_74764_b("invSize")) {
            this.inv = new ItemStackHandler(data.func_74762_e("invSize"));
            this.size = data.func_74762_e("invSize");
        } else {
            this.inv = new ItemStackHandler(5);
        }
        this.inv.deserializeNBT(data);
    }

    public void formatDescriptionPacket(NBTTagCompound data) {
        this.writeToNBT(data);
    }

    public void decodeDescriptionPacket(NBTTagCompound data) {
        this.readFromNBT(data);
    }

    public void updateInfo() {
        this.size = 0;
        for (IMultiblockPart part : this.connectedParts) {
            if (part.isConnected() && !part.isVisited()) {
                this.size += 5;
                part.setVisited();
            }
            part.setUnvisited();
            this.setSize(this.size);
        }
        if (this.connectedParts.size() == 1) {
            this.setSize(5);
        }
    }

    public void setSize(int size) {
        this.size = size;
        if (this.isAssembled()) {
            ItemStackHandler copy = new ItemStackHandler(size);
            for (int slot = 0; slot < Math.min(this.inv.getSlots(), copy.getSlots()); ++slot) {
                ItemStack stack = this.inv.getStackInSlot(slot);
                if (stack.func_190926_b()) continue;
                copy.setStackInSlot(slot, stack);
                this.inv.setStackInSlot(slot, ItemStack.field_190927_a);
            }
            this.inv = copy;
        }
    }

    public ItemStackHandler getInv() {
        return this.inv;
    }

    protected void addSlotlessItemHandler() {
        ItemStackHandler iItemHandler = this.getInv();
    }
}

