/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.items;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.energy.wires.IWireCoil;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.industrialwires.IWConfig;
import malte0811.industrialwires.IndustrialWires;
import malte0811.industrialwires.util.ConversionUtil;
import malte0811.industrialwires.wires.MixedWireType;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemIC2Coil
extends Item
implements IWireCoil {
    public static final String[] subNames = new String[]{"tin", "copper", "gold", "hv", "glass", "tin_ins", "copper_ins", "gold_ins"};
    public static final String lengthKey = "wireLength";
    public static final String NAME = "ic2_wire_coil";

    public ItemIC2Coil() {
        this.func_77655_b("industrialwires.ic2_wire_coil");
        this.func_77627_a(true);
        this.func_77637_a(IndustrialWires.creativeTab);
        this.func_77625_d(1);
        this.setRegistryName(new ResourceLocation("industrialwires", NAME));
        IndustrialWires.items.add(this);
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < subNames.length; ++i) {
                ItemStack tmp = new ItemStack((Item)this, 1, i);
                ItemIC2Coil.setLength(tmp, ItemIC2Coil.getMaxWireLength(tmp));
                subItems.add((Object)tmp);
            }
        }
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "." + subNames[stack.func_77960_j()];
    }

    public MixedWireType getWireType(ItemStack stack) {
        return MixedWireType.ALL[stack.func_77960_j()];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int[] link;
        tooltip.add(I18n.func_135052_a((String)"industrialwires.desc.wireLength", (Object[])new Object[]{ItemIC2Coil.getLength(stack)}));
        MixedWireType wireType = MixedWireType.ALL[stack.func_77960_j()];
        double ioRate = wireType.getIORate();
        double transferRate = ioRate * (double)wireType.getFactor();
        tooltip.add(I18n.func_135052_a((String)"industrialwires.tooltip.transfer_rate", (Object[])new Object[]{transferRate * ConversionUtil.euPerJoule(), transferRate * ConversionUtil.ifPerJoule() * IWConfig.wireRatio}));
        tooltip.add(I18n.func_135052_a((String)"industrialwires.tooltip.input_rate", (Object[])new Object[]{ioRate * ConversionUtil.euPerJoule(), ioRate * ConversionUtil.ifPerJoule() * IWConfig.wireRatio}));
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("linkingPos") && (link = stack.func_77978_p().func_74759_k("linkingPos")).length > 3) {
            tooltip.add(I18n.func_135052_a((String)"desc.immersiveengineering.info.attachedToDim", (Object[])new Object[]{link[1], link[2], link[3], link[0]}));
        }
        tooltip.add(I18n.func_135052_a((String)"industrialwires.desc.recipe", (Object[])new Object[0]));
    }

    @Nonnull
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return ApiUtils.doCoilUse((IWireCoil)this, (EntityPlayer)player, (World)world, (BlockPos)pos, (EnumHand)hand, (EnumFacing)side, (float)hitX, (float)hitY, (float)hitZ);
    }

    public static void setLength(ItemStack i, int blocks) {
        i.func_77983_a(lengthKey, (NBTBase)new NBTTagInt(blocks));
    }

    public static int getLength(ItemStack i) {
        if (i.func_77978_p() == null) {
            ItemIC2Coil.setLength(i, 4);
        }
        return ItemNBTHelper.getInt((ItemStack)i, (String)lengthKey) * i.func_190916_E();
    }

    public static int getMaxWireLength(ItemStack i) {
        return IWConfig.maxLengthOnCoil[i.func_77952_i() % 5];
    }

    public int getMaxLength(ItemStack stack) {
        return ItemIC2Coil.getLength(stack);
    }

    public void consumeWire(ItemStack stack, int lengthConsumed) {
        int lengthOnStack = ItemIC2Coil.getLength(stack);
        if (lengthConsumed < lengthOnStack) {
            ItemIC2Coil.setLength(stack, lengthOnStack - lengthConsumed);
        } else {
            stack.func_190918_g(1);
        }
    }
}

