/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.controlpanel;

import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import malte0811.industrialwires.client.RawQuad;
import malte0811.industrialwires.client.gui.GuiPanelCreator;
import malte0811.industrialwires.controlpanel.ControlPanelNetwork;
import malte0811.industrialwires.controlpanel.IConfigurableComponent;
import malte0811.industrialwires.controlpanel.PanelComponent;
import malte0811.industrialwires.controlpanel.PanelUtils;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

public class ToggleSwitch
extends PanelComponent
implements IConfigurableComponent {
    protected boolean active;
    @Nonnull
    protected ControlPanelNetwork.RSChannel outputChannel = ControlPanelNetwork.RSChannel.DEFAULT_CHANNEL;
    protected float sizeX = 0.0625f;
    protected float sizeY = 1.5f * this.sizeX;
    protected float rodRadius = this.sizeX * 0.25f;
    protected float rodLength = 0.09375f;

    public ToggleSwitch() {
        super("toggle_switch");
    }

    protected ToggleSwitch(String name) {
        super(name);
    }

    public ToggleSwitch(boolean active, @Nonnull ControlPanelNetwork.RSChannel outputChannel) {
        this();
        this.active = active;
        this.outputChannel = outputChannel;
    }

    @Override
    protected void writeCustomNBT(NBTTagCompound nbt, boolean toItem) {
        if (!toItem) {
            nbt.func_74757_a("active", this.active);
        }
        nbt.func_74774_a("rsChannel", this.outputChannel.getColor());
        nbt.func_74768_a("rsId", this.outputChannel.getController());
    }

    @Override
    protected void readCustomNBT(NBTTagCompound nbt) {
        this.active = nbt.func_74767_n("active");
        int rsController = nbt.func_74762_e("rsId");
        byte rsColor = nbt.func_74771_c("rsChannel");
        this.outputChannel = new ControlPanelNetwork.RSChannel(rsController, rsColor);
    }

    @Override
    public void setNetwork(ControlPanelNetwork net) {
        super.setNetwork(net);
        this.network.setOutputs(this, new ControlPanelNetwork.RSChannelState(this.outputChannel, (byte)(this.active ? 15 : 0)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<RawQuad> getQuads() {
        ArrayList<RawQuad> ret = new ArrayList<RawQuad>();
        PanelUtils.addColoredQuad(ret, new Vector3f(this.sizeX, 0.0f, (this.sizeY - this.sizeX) / 2.0f), new Vector3f(0.0f, 0.0f, (this.sizeY - this.sizeX) / 2.0f), new Vector3f(0.0f, 0.0f, (this.sizeY + this.sizeX) / 2.0f), new Vector3f(this.sizeX, 0.0f, (this.sizeY + this.sizeX) / 2.0f), EnumFacing.UP, GRAY);
        Matrix4 rot = new Matrix4();
        rot.translate((double)(this.sizeX / 2.0f), (double)-0.01f, (double)(this.sizeY / 2.0f));
        rot.rotate(0.19634954084936207 * (double)(this.active ? -1 : 1), 1.0, 0.0, 0.0);
        PanelUtils.addColoredBox(GRAY, GRAY, null, new Vector3f(-this.rodRadius, 0.0f, -this.rodRadius), new Vector3f(2.0f * this.rodRadius, this.rodLength, 2.0f * this.rodRadius), ret, false, rot);
        return ret;
    }

    @Override
    @Nonnull
    public PanelComponent copyOf() {
        ToggleSwitch ret = new ToggleSwitch(this.active, this.outputChannel);
        ret.setX(this.x);
        ret.setY(this.y);
        ret.panelHeight = this.panelHeight;
        return ret;
    }

    @Override
    @Nonnull
    public AxisAlignedBB getBlockRelativeAABB() {
        if (this.aabb == null) {
            this.aabb = new AxisAlignedBB((double)this.x, 0.0, (double)this.y, (double)(this.x + this.sizeX), (double)this.getHeight(), (double)(this.y + this.sizeY));
        }
        return this.aabb;
    }

    @Override
    public void interactWith(Vec3d hitRel, EntityPlayerMP player) {
        this.setOut(!this.active);
    }

    @Override
    public void update() {
    }

    @Override
    public float getHeight() {
        return 0.09375f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInGUI(GuiPanelCreator gui) {
        AxisAlignedBB aabb = this.getBlockRelativeAABB();
        double zOffset = (aabb.field_72334_f - aabb.field_72339_c - (double)this.sizeX) / 2.0;
        int left = (int)((double)gui.getX0() + aabb.field_72340_a * (double)gui.panelSize);
        int top = (int)Math.ceil((double)gui.getY0() + (aabb.field_72339_c + zOffset) * (double)gui.panelSize);
        int right = (int)((double)gui.getX0() + aabb.field_72336_d * (double)gui.panelSize);
        int bottom = (int)Math.floor((double)gui.getY0() + (aabb.field_72334_f - zOffset) * (double)gui.panelSize);
        Gui.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)-3092272);
        double xOffset = (aabb.field_72336_d - aabb.field_72340_a - (double)this.rodRadius) / 2.0;
        left = (int)((double)gui.getX0() + (aabb.field_72340_a + xOffset) * (double)gui.panelSize);
        top = (int)Math.floor((double)gui.getY0() + (aabb.field_72339_c + aabb.field_72334_f) / 2.0 * (double)gui.panelSize);
        right = (int)((double)gui.getX0() + (aabb.field_72336_d - xOffset) * (double)gui.panelSize);
        bottom = (int)Math.ceil((double)gui.getY0() + aabb.field_72334_f * (double)gui.panelSize);
        Gui.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)-2039584);
    }

    protected void setOut(boolean on) {
        this.active = on;
        this.network.setOutputs(this, new ControlPanelNetwork.RSChannelState(this.outputChannel, (byte)(this.active ? 15 : 0)));
        this.panel.func_70296_d();
        this.panel.triggerRenderUpdate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ToggleSwitch that = (ToggleSwitch)o;
        if (this.active != that.active) {
            return false;
        }
        if (Float.compare(that.sizeX, this.sizeX) != 0) {
            return false;
        }
        if (Float.compare(that.sizeY, this.sizeY) != 0) {
            return false;
        }
        if (Float.compare(that.rodRadius, this.rodRadius) != 0) {
            return false;
        }
        if (Float.compare(that.rodLength, this.rodLength) != 0) {
            return false;
        }
        return this.outputChannel.equals(that.outputChannel);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.active ? 1 : 0);
        result = 31 * result + this.outputChannel.hashCode();
        result = 31 * result + (this.sizeX != 0.0f ? Float.floatToIntBits(this.sizeX) : 0);
        result = 31 * result + (this.sizeY != 0.0f ? Float.floatToIntBits(this.sizeY) : 0);
        result = 31 * result + (this.rodRadius != 0.0f ? Float.floatToIntBits(this.rodRadius) : 0);
        result = 31 * result + (this.rodLength != 0.0f ? Float.floatToIntBits(this.rodLength) : 0);
        return result;
    }

    @Override
    public void applyConfigOption(IConfigurableComponent.ConfigType type, int id, NBTBase value) {
        switch (type) {
            case RS_CHANNEL: {
                this.outputChannel = this.outputChannel.withColor(value);
                break;
            }
            case INT: {
                this.outputChannel = this.outputChannel.withController(value);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String fomatConfigName(IConfigurableComponent.ConfigType type, int id) {
        switch (type) {
            case RS_CHANNEL: 
            case INT: {
                return null;
            }
            case FLOAT: {
                return I18n.func_135052_a((String)("industrialwires.desc." + (id == 0 ? "red" : (id == 1 ? "green" : "blue"))), (Object[])new Object[0]);
            }
        }
        return "INVALID";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String fomatConfigDescription(IConfigurableComponent.ConfigType type, int id) {
        switch (type) {
            case RS_CHANNEL: {
                return I18n.func_135052_a((String)"industrialwires.desc.rschannel_info", (Object[])new Object[0]);
            }
            case INT: {
                return I18n.func_135052_a((String)"industrialwires.desc.rsid_info", (Object[])new Object[0]);
            }
            case FLOAT: {
                return null;
            }
        }
        return "INVALID?";
    }

    @Override
    public IConfigurableComponent.RSColorConfig[] getRSChannelOptions() {
        return new IConfigurableComponent.RSColorConfig[]{new IConfigurableComponent.RSColorConfig("channel", 0, 0, this.outputChannel.getColor())};
    }

    @Override
    public IConfigurableComponent.IntConfig[] getIntegerOptions() {
        return new IConfigurableComponent.IntConfig[]{new IConfigurableComponent.IntConfig("rsId", 0, 50, this.outputChannel.getController(), 2, false)};
    }

    @Override
    public int getColor() {
        return -1;
    }
}

