/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.blocks.converter;

import blusunrize.immersiveengineering.api.energy.IRotationAcceptor;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import ic2.api.energy.tile.IKineticSource;
import javax.annotation.Nonnull;
import malte0811.industrialwires.IWConfig;
import malte0811.industrialwires.blocks.TileEntityIWBase;
import malte0811.industrialwires.util.ConversionUtil;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class TileEntityMechIEtoIC
extends TileEntityIWBase
implements IEBlockInterfaces.IDirectionalTile,
IRotationAcceptor,
IKineticSource {
    private EnumFacing dir = EnumFacing.DOWN;
    private double rotBuffer = 0.0;

    @Override
    public void writeNBT(NBTTagCompound out, boolean updatePacket) {
        out.func_74774_a("dir", (byte)this.dir.func_176745_a());
        out.func_74780_a("buffer", this.rotBuffer);
    }

    @Override
    public void readNBT(NBTTagCompound in, boolean updatePacket) {
        this.dir = EnumFacing.field_82609_l[in.func_74771_c("dir")];
        this.rotBuffer = in.func_74769_h("buffer");
    }

    @Nonnull
    public EnumFacing getFacing() {
        return this.dir;
    }

    public void setFacing(@Nonnull EnumFacing facing) {
        this.dir = facing;
        this.func_70296_d();
    }

    public int getFacingLimitation() {
        return 1;
    }

    public boolean mirrorFacingOnPlacement(@Nonnull EntityLivingBase placer) {
        return false;
    }

    public boolean canHammerRotate(@Nonnull EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull EntityLivingBase entity) {
        return true;
    }

    @Deprecated
    public int maxrequestkineticenergyTick(EnumFacing enumFacing) {
        return 0;
    }

    public int getConnectionBandwidth(EnumFacing f) {
        if (f == this.dir) {
            return (int)(ConversionUtil.kinPerRot() * this.rotBuffer);
        }
        return 0;
    }

    @Deprecated
    public int requestkineticenergy(EnumFacing enumFacing, int i) {
        return 0;
    }

    public int drawKineticEnergy(EnumFacing f, int requested, boolean simulate) {
        if (f == this.dir) {
            int stored = (int)(ConversionUtil.kinPerRot() * this.rotBuffer);
            int out = Math.min(requested, stored);
            if (!simulate) {
                this.rotBuffer -= (double)out * ConversionUtil.rotPerKin();
            }
            return (int)((double)out * IWConfig.MechConversion.rotToKinEfficiency);
        }
        return 0;
    }

    public void inputRotation(double rotation, @Nonnull EnumFacing side) {
        if (side == this.dir) {
            this.rotBuffer = Math.min(Math.max(this.rotBuffer, rotation), IWConfig.MechConversion.maxRotToKin);
        }
    }

    public boolean canRotate(@Nonnull EnumFacing axis) {
        return true;
    }
}

