/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.blocks.controlpanel;

import blusunrize.immersiveengineering.api.tool.IConfigurableTool;
import malte0811.industrialwires.blocks.ItemBlockIW;
import malte0811.industrialwires.blocks.controlpanel.BlockTypes_Panel;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;

public class ItemBlockPanel
extends ItemBlockIW
implements IConfigurableTool {
    public ItemBlockPanel(Block b) {
        super(b);
    }

    public boolean canConfigure(ItemStack stack) {
        return stack.func_77960_j() == BlockTypes_Panel.UNFINISHED.ordinal();
    }

    public IConfigurableTool.ToolConfig.ToolConfigBoolean[] getBooleanOptions(ItemStack stack) {
        return new IConfigurableTool.ToolConfig.ToolConfigBoolean[0];
    }

    public IConfigurableTool.ToolConfig.ToolConfigFloat[] getFloatOptions(ItemStack stack) {
        float angle;
        float height;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            height = 0.5f;
            angle = 0.0f;
        } else {
            height = nbt.func_74760_g("height");
            angle = nbt.func_74760_g("angle");
        }
        angle = (float)(((double)(angle * 180.0f) / Math.PI + 45.0) / 90.0);
        return new IConfigurableTool.ToolConfig.ToolConfigFloat[]{new IConfigurableTool.ToolConfig.ToolConfigFloat("height", 60, 20, height), new IConfigurableTool.ToolConfig.ToolConfigFloat("angle", 60, 40, angle)};
    }

    public void applyConfigOption(ItemStack stack, String key, Object value) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        switch (key) {
            case "height": {
                float angle = nbt.func_74760_g("angle");
                float halfH = (float)(0.5 * Math.tan(angle));
                nbt.func_74776_a("height", MathHelper.func_76131_a((float)(((Float)value).floatValue() + 0.001f), (float)halfH, (float)(1.0f - halfH)));
                break;
            }
            case "angle": {
                float height = nbt.func_74760_g("height");
                float angleMax = (float)Math.atan(2.0f * Math.min(height, 1.0f - height));
                float newAngle = (float)(1.5707963267948966 * ((double)((Float)value).floatValue() - 0.5));
                nbt.func_74776_a("angle", MathHelper.func_76131_a((float)newAngle, (float)(-angleMax), (float)angleMax));
            }
        }
    }

    public String fomatConfigName(ItemStack stack, IConfigurableTool.ToolConfig config) {
        switch (config.name) {
            case "height": {
                return I18n.func_135052_a((String)"industrialwires.desc.height", (Object[])new Object[0]);
            }
            case "angle": {
                return I18n.func_135052_a((String)"industrialwires.desc.angle", (Object[])new Object[0]);
            }
        }
        return null;
    }

    public String fomatConfigDescription(ItemStack stack, IConfigurableTool.ToolConfig config) {
        switch (config.name) {
            case "height": {
                return I18n.func_135052_a((String)"industrialwires.desc.height_info", (Object[])new Object[0]);
            }
            case "angle": {
                return I18n.func_135052_a((String)"industrialwires.desc.angle_info", (Object[])new Object[0]);
            }
        }
        return null;
    }
}

