/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items;

import com.brandon3055.brandonscore.items.ItemBCore;
import com.brandon3055.brandonscore.registry.Feature;
import com.brandon3055.brandonscore.registry.IRenderOverride;
import com.brandon3055.brandonscore.utils.InfoHelper;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.api.OreDictHelper;
import com.brandon3055.draconicevolution.api.fusioncrafting.FusionRecipeAPI;
import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionRecipe;
import com.brandon3055.draconicevolution.api.itemupgrade.FusionUpgradeRecipe;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ToolUpgrade
extends ItemBCore
implements IRenderOverride {
    public static final Map<Integer, String> ID_TO_NAME = new HashMap<Integer, String>();
    public static final Map<String, Integer> NAME_TO_ID = new HashMap<String, Integer>();
    public static final Map<String, Integer> NAME_MAX_LEVEL = new HashMap<String, Integer>();
    public static final String RF_CAPACITY = "rfCap";
    public static final String DIG_SPEED = "digSpeed";
    public static final String DIG_AOE = "digAOE";
    public static final String ATTACK_DAMAGE = "attackDmg";
    public static final String ATTACK_AOE = "attackAOE";
    public static final String ARROW_DAMAGE = "arrowDmg";
    public static final String DRAW_SPEED = "drawSpeed";
    public static final String ARROW_SPEED = "arrowSpeed";
    public static final String SHIELD_CAPACITY = "shieldCap";
    public static final String SHIELD_RECOVERY = "shieldRec";
    public static final String MOVE_SPEED = "moveSpeed";
    public static final String JUMP_BOOST = "jumpBoost";
    public static final Map<String, LinkedList<FusionUpgradeRecipe>> RECIPE_MAP = new HashMap<String, LinkedList<FusionUpgradeRecipe>>();
    public static final List<IFusionRecipe> upgradeRecipes = new ArrayList<IFusionRecipe>();
    private static final int[] UPGRADE_COST = new int[]{32000, 512000, 32000000, 256000000};
    private int tick;

    public ToolUpgrade() {
        this.func_77627_a(true);
    }

    private static void registerUpgrade(int id, String upgrade, int maxLevel) {
        ID_TO_NAME.put(id, upgrade);
        NAME_TO_ID.put(upgrade, id);
        NAME_MAX_LEVEL.put(upgrade, maxLevel);
    }

    private static void registerRecipe(String name, int level) {
        FusionUpgradeRecipe recipe = null;
        switch (level) {
            case 0: {
                recipe = new FusionUpgradeRecipe(name, new ItemStack((Item)DEFeatures.toolUpgrade, 1, NAME_TO_ID.get(name).intValue()), UPGRADE_COST[level], level, level + 1, new Object[]{Items.field_151153_ao, Items.field_151153_ao, "gemDiamond", "gemDiamond", Items.field_151061_bv, Items.field_151061_bv, DEFeatures.draconicCore});
                break;
            }
            case 1: {
                recipe = new FusionUpgradeRecipe(name, new ItemStack((Item)DEFeatures.toolUpgrade, 1, NAME_TO_ID.get(name).intValue()), UPGRADE_COST[level], level, level + 1, new Object[]{Items.field_151156_bN, Items.field_151156_bN, DEFeatures.draconicCore, DEFeatures.draconicCore, Items.field_151166_bC, Items.field_151166_bC, DEFeatures.wyvernCore});
                break;
            }
            case 2: {
                recipe = new FusionUpgradeRecipe(name, new ItemStack((Item)DEFeatures.toolUpgrade, 1, NAME_TO_ID.get(name).intValue()), UPGRADE_COST[level], level, level + 1, new Object[]{Items.field_151156_bN, Items.field_151156_bN, DEFeatures.wyvernCore, DEFeatures.wyvernCore, Blocks.field_150475_bE, Blocks.field_150475_bE, DEFeatures.awakenedCore});
                break;
            }
            case 3: {
                recipe = new FusionUpgradeRecipe(name, new ItemStack((Item)DEFeatures.toolUpgrade, 1, NAME_TO_ID.get(name).intValue()), UPGRADE_COST[level], level, level + 1, new Object[]{DEFeatures.wyvernCore, DEFeatures.wyvernCore, DEFeatures.awakenedCore, DEFeatures.awakenedCore, Blocks.field_150380_bt, Blocks.field_150380_bt, DEFeatures.chaoticCore});
            }
        }
        if (recipe != null) {
            if (!RECIPE_MAP.containsKey(name)) {
                RECIPE_MAP.put(name, new LinkedList());
            }
            RECIPE_MAP.get(name).add(recipe);
            FusionRecipeAPI.addRecipe(recipe);
            upgradeRecipes.add(recipe);
        }
    }

    public static Collection<IFusionRecipe> createUpgradeRecipes() {
        upgradeRecipes.clear();
        for (String upgrade : NAME_TO_ID.keySet()) {
            for (int i = 0; i < NAME_MAX_LEVEL.get(upgrade); ++i) {
                ToolUpgrade.registerRecipe(upgrade, i);
            }
        }
        return upgradeRecipes;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (Integer meta : ID_TO_NAME.keySet()) {
                subItems.add((Object)new ItemStack((Item)this, 1, meta.intValue()));
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + ID_TO_NAME.get(stack.func_77952_i());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        if (!InfoHelper.isShiftKeyDown()) {
            tooltip.add(I18n.func_135052_a((String)"upgrade.de.holdShiftForRecipes.info", (Object[])new Object[]{TextFormatting.AQUA + "" + TextFormatting.ITALIC, TextFormatting.RESET + "" + TextFormatting.GRAY}));
        } else if (ID_TO_NAME.containsKey(stack.func_77952_i()) && RECIPE_MAP.containsKey(ID_TO_NAME.get(stack.func_77952_i()))) {
            if (!InfoHelper.isCtrlKeyDown()) {
                this.tick = ClientEventHandler.elapsedTicks;
            }
            LinkedList<FusionUpgradeRecipe> recipes = RECIPE_MAP.get(ID_TO_NAME.get(stack.func_77952_i()));
            FusionUpgradeRecipe recipe = recipes.get(this.tick / 100 % recipes.size());
            tooltip.add(InfoHelper.ITC() + I18n.func_135052_a((String)"upgrade.de.level.info", (Object[])new Object[0]) + ": " + InfoHelper.HITC() + I18n.func_135052_a((String)("upgrade.level." + (recipe.getRecipeTier() + 1)), (Object[])new Object[0]) + TextFormatting.DARK_GRAY + " " + (5 - this.tick % 100 / 20));
            for (Object o : recipe.getRecipeIngredients()) {
                ItemStack ingredient = OreDictHelper.resolveObject(o);
                if (ingredient.func_190926_b()) continue;
                tooltip.add("-" + ingredient.func_82833_r());
            }
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"upgrade.de.holdCTRLToPause.info", (Object[])new Object[0]));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerRenderer(Feature feature) {
        for (Integer meta : ID_TO_NAME.keySet()) {
            String fullName = "draconicevolution:" + feature.getName();
            String variant = "type=" + ID_TO_NAME.get(meta).toLowerCase();
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)meta, (ModelResourceLocation)new ModelResourceLocation(fullName, variant));
        }
    }

    public boolean registerNormal(Feature feature) {
        return false;
    }

    static {
        ToolUpgrade.registerUpgrade(0, RF_CAPACITY, 4);
        ToolUpgrade.registerUpgrade(1, DIG_SPEED, 4);
        ToolUpgrade.registerUpgrade(2, DIG_AOE, 4);
        ToolUpgrade.registerUpgrade(3, ATTACK_DAMAGE, 4);
        ToolUpgrade.registerUpgrade(4, ATTACK_AOE, 4);
        ToolUpgrade.registerUpgrade(5, ARROW_DAMAGE, 4);
        ToolUpgrade.registerUpgrade(6, DRAW_SPEED, 3);
        ToolUpgrade.registerUpgrade(7, ARROW_SPEED, 4);
        ToolUpgrade.registerUpgrade(8, SHIELD_CAPACITY, 4);
        ToolUpgrade.registerUpgrade(9, SHIELD_RECOVERY, 4);
        ToolUpgrade.registerUpgrade(10, MOVE_SPEED, 4);
        ToolUpgrade.registerUpgrade(11, JUMP_BOOST, 4);
    }
}

