/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent;

import com.brandon3055.draconicevolution.client.gui.modwiki.GuiModWiki;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.DCHeading;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.DCImage;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.DCLink;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.DCRecipe;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.DCSplitContainer;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.DCStack;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.DCTextArea;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.DCVSpacer;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.DisplayComponentBase;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.IDisplayComponentFactory;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.guidoctree.TreeBranchRoot;
import com.brandon3055.draconicevolution.utils.LogHelper;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class DisplayComponentRegistry {
    public static final Map<String, IDisplayComponentFactory> REGISTRY = new LinkedHashMap<String, IDisplayComponentFactory>();

    private static void register(IDisplayComponentFactory factory) {
        REGISTRY.put(factory.getID(), factory);
    }

    public static DisplayComponentBase createComponent(GuiModWiki guiWiki, String componentID, Element element, TreeBranchRoot branch) {
        if (!REGISTRY.containsKey(componentID)) {
            LogHelper.error("Found Unknown Content Type: %s in branch: %s", componentID, branch.branchID);
            return null;
        }
        DisplayComponentBase displayComponent = REGISTRY.get(componentID).createNewInstance(guiWiki, branch);
        try {
            displayComponent.loadFromXML(element);
        }
        catch (Exception e) {
            LogHelper.error("An error occurred while loading %s element for branch: %s", componentID, branch.branchID);
            e.printStackTrace();
            return null;
        }
        return displayComponent;
    }

    static {
        DisplayComponentRegistry.register(new DCHeading.Factory());
        DisplayComponentRegistry.register(new DCTextArea.Factory());
        DisplayComponentRegistry.register(new DCImage.Factory());
        DisplayComponentRegistry.register(new DCLink.Factory());
        DisplayComponentRegistry.register(new DCRecipe.Factory());
        DisplayComponentRegistry.register(new DCStack.Factory());
        DisplayComponentRegistry.register(new DCVSpacer.Factory());
        DisplayComponentRegistry.register(new DCSplitContainer.Factory());
    }
}

