/*
 * Decompiled with CFR 0.152.
 */
package com.mmyzd.nmsot;

import com.mmyzd.nmsot.CommandManager;
import com.mmyzd.nmsot.ConfigManager;
import com.mmyzd.nmsot.SpawningEntry;
import com.mmyzd.nmsot.rule.RuleSet;
import java.util.Map;
import net.minecraft.command.ICommand;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="nmsot", useMetadata=true, guiFactory="com.mmyzd.nmsot.GuiFactory", acceptedMinecraftVersions="[1.12.2]")
public class NoMobSpawningOnTrees {
    public static final String MODID = "nmsot";
    @Mod.Instance(value="nmsot")
    public static NoMobSpawningOnTrees instance;
    public ConfigManager config;
    public RuleSet rules;
    public double accumulatedSpawningTries;
    public MinecraftServer server;

    @NetworkCheckHandler
    public boolean checkRemote(Map<String, String> name, Side side) {
        return true;
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandManager());
        this.server = event.getServer();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.config = new ConfigManager(event.getModConfigurationDirectory());
    }

    @Mod.EventHandler
    public void initialize(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this.config);
        this.rules = new RuleSet(this.config.blacklistRules.getStringList());
        this.accumulatedSpawningTries = 0.0;
    }

    @SubscribeEvent
    public void onMobSpawning(LivingSpawnEvent.CheckSpawn event) {
        SpawningEntry entry = new SpawningEntry();
        entry.init(event);
        if (this.rules.apply(entry)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side != Side.SERVER || event.phase != TickEvent.Phase.START || this.server == null) {
            return;
        }
        this.accumulatedSpawningTries += this.config.extraSpawningTries.getDouble(0.0);
        int spawningTries = (int)Math.floor(this.accumulatedSpawningTries);
        this.accumulatedSpawningTries -= (double)spawningTries;
        if (spawningTries == 0) {
            return;
        }
        WorldEntitySpawner spawner = new WorldEntitySpawner();
        Integer[] ids = DimensionManager.getIDs(((this.server.func_71259_af() & 0x1FF) == 0 ? 1 : 0) != 0);
        for (int i = 0; i < ids.length; ++i) {
            WorldServer worldserver;
            int id = ids[i];
            if (id != 0 && !this.server.func_71255_r() || !(worldserver = DimensionManager.getWorld((int)id)).func_82736_K().func_82766_b("doMobSpawning")) continue;
            for (int j = 0; j < spawningTries; ++j) {
                spawner.func_77192_a(worldserver, true, false, worldserver.func_72912_H().func_82573_f() % 400L == 0L);
            }
        }
    }
}

