/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.IEvaporationSolar;
import mekanism.api.TileNetworkList;
import mekanism.common.Mekanism;
import mekanism.common.base.IActiveState;
import mekanism.common.base.ITankManager;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.FluidInput;
import mekanism.common.recipe.machines.ThermalEvaporationRecipe;
import mekanism.common.recipe.outputs.FluidOutput;
import mekanism.common.tile.TileEntityThermalEvaporationBlock;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TileUtils;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityThermalEvaporationController
extends TileEntityThermalEvaporationBlock
implements IActiveState,
ITankManager {
    public static final int MAX_OUTPUT = 10000;
    public static final int MAX_SOLARS = 4;
    public static final int MAX_HEIGHT = 18;
    private static final int[] SLOTS = new int[]{0, 1, 2, 3};
    public FluidTank inputTank = new FluidTank(0);
    public FluidTank outputTank = new FluidTank(10000);
    public Set<Coord4D> tankParts = new HashSet<Coord4D>();
    public IEvaporationSolar[] solars = new IEvaporationSolar[4];
    public boolean temperatureSet = false;
    public double partialInput = 0.0;
    public double partialOutput = 0.0;
    public float biomeTemp = 0.0f;
    public float temperature = 0.0f;
    public float heatToAbsorb = 0.0f;
    public float lastGain = 0.0f;
    public int height = 0;
    public boolean structured = false;
    public boolean controllerConflict = false;
    public boolean isLeftOnFace;
    public int renderY;
    public boolean updatedThisTick = false;
    public int clientSolarAmount;
    public boolean clientStructured;
    public boolean cacheStructure = false;
    public float prevScale;
    public float totalLoss = 0.0f;

    public TileEntityThermalEvaporationController() {
        super("ThermalEvaporationController");
        this.inventory = NonNullList.func_191197_a((int)SLOTS.length, (Object)ItemStack.field_190927_a);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            this.updatedThisTick = false;
            if (this.ticker == 5) {
                this.refresh();
            }
            if (this.structured) {
                this.updateTemperature();
            }
            this.manageBuckets();
            ThermalEvaporationRecipe recipe = this.getRecipe();
            if (this.canOperate(recipe)) {
                int outputNeeded = this.outputTank.getCapacity() - this.outputTank.getFluidAmount();
                int inputStored = this.inputTank.getFluidAmount();
                double outputRatio = (double)((FluidOutput)recipe.recipeOutput).output.amount / (double)((FluidInput)recipe.recipeInput).ingredient.amount;
                double tempMult = (double)Math.max(0.0f, this.getTemperature()) * MekanismConfig.current().general.evaporationTempMultiplier.val();
                double inputToUse = tempMult * (double)((FluidInput)recipe.recipeInput).ingredient.amount * (double)((float)this.height / 18.0f);
                inputToUse = Math.min((double)this.inputTank.getFluidAmount(), inputToUse);
                inputToUse = Math.min(inputToUse, (double)outputNeeded / outputRatio);
                this.lastGain = (float)inputToUse / (float)((FluidInput)recipe.recipeInput).ingredient.amount;
                this.partialInput += inputToUse;
                if (this.partialInput >= 1.0) {
                    int inputInt = (int)Math.floor(this.partialInput);
                    this.inputTank.drain(inputInt, true);
                    this.partialInput %= 1.0;
                    this.partialOutput += (double)inputInt / (double)((FluidInput)recipe.recipeInput).ingredient.amount;
                }
                if (this.partialOutput >= 1.0) {
                    int outputInt = (int)Math.floor(this.partialOutput);
                    this.outputTank.fill(new FluidStack(((FluidOutput)recipe.recipeOutput).output.getFluid(), outputInt), true);
                    this.partialOutput %= 1.0;
                }
            } else {
                this.lastGain = 0.0f;
            }
            if (this.structured && (double)Math.abs((float)this.inputTank.getFluidAmount() / (float)this.inputTank.getCapacity() - this.prevScale) > 0.01) {
                Mekanism.packetHandler.sendUpdatePacket(this);
                this.prevScale = (float)this.inputTank.getFluidAmount() / (float)this.inputTank.getCapacity();
            }
        }
    }

    public ThermalEvaporationRecipe getRecipe() {
        return RecipeHandler.getThermalEvaporationRecipe(new FluidInput(this.inputTank.getFluid()));
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.refresh();
    }

    @Override
    public void onNeighborChange(Block block) {
        super.onNeighborChange(block);
        this.refresh();
    }

    public boolean hasRecipe(Fluid fluid) {
        if (fluid == null) {
            return false;
        }
        return RecipeHandler.Recipe.THERMAL_EVAPORATION_PLANT.containsRecipe(fluid);
    }

    protected void refresh() {
        if (!this.field_145850_b.field_72995_K && !this.updatedThisTick) {
            this.clearStructure();
            this.structured = this.buildStructure();
            if (this.structured != this.clientStructured) {
                Mekanism.packetHandler.sendUpdatePacket(this);
                this.clientStructured = this.structured;
            }
            if (this.structured) {
                this.inputTank.setCapacity(this.getMaxFluid());
                if (this.inputTank.getFluid() != null) {
                    this.inputTank.getFluid().amount = Math.min(this.inputTank.getFluid().amount, this.getMaxFluid());
                }
            } else {
                this.clearStructure();
            }
        }
    }

    public boolean canOperate(ThermalEvaporationRecipe recipe) {
        if (!this.structured || this.height < 3 || this.height > 18 || this.inputTank.getFluid() == null) {
            return false;
        }
        return recipe != null && recipe.canOperate(this.inputTank, this.outputTank);
    }

    private void manageBuckets() {
        if (this.outputTank.getFluid() != null && FluidContainerUtils.isFluidContainer((ItemStack)this.inventory.get(2))) {
            FluidContainerUtils.handleContainerItemFill(this, this.outputTank, 2, 3);
        }
        if (this.structured && FluidContainerUtils.isFluidContainer((ItemStack)this.inventory.get(0))) {
            FluidContainerUtils.handleContainerItemEmpty(this, this.inputTank, 0, 1, new FluidContainerUtils.FluidChecker(){

                @Override
                public boolean isValid(Fluid f) {
                    return TileEntityThermalEvaporationController.this.hasRecipe(f);
                }
            });
        }
    }

    private void updateTemperature() {
        float base;
        if (!this.temperatureSet) {
            this.biomeTemp = this.field_145850_b.getBiomeForCoordsBody(this.func_174877_v()).func_180626_a(this.func_174877_v());
            this.temperatureSet = true;
        }
        this.heatToAbsorb = (float)((double)this.heatToAbsorb + (double)this.getActiveSolars() * MekanismConfig.current().general.evaporationSolarMultiplier.val());
        this.temperature += this.heatToAbsorb / (float)this.height;
        float biome = this.biomeTemp - 0.5f;
        float f = base = biome > 0.0f ? biome * 20.0f : this.biomeTemp * 40.0f;
        if ((double)Math.abs(this.temperature - base) < 0.001) {
            this.temperature = base;
        }
        float incr = (float)Math.sqrt(Math.abs(this.temperature - base)) * (float)MekanismConfig.current().general.evaporationHeatDissipation.val();
        if (this.temperature > base) {
            incr = -incr;
        }
        float prev = this.temperature;
        this.temperature = (float)Math.min(MekanismConfig.current().general.evaporationMaxTemp.val(), (double)(this.temperature + incr / (float)this.height));
        this.totalLoss = incr < 0.0f ? prev - this.temperature : 0.0f;
        this.heatToAbsorb = 0.0f;
        MekanismUtils.saveChunk(this);
    }

    public float getTemperature() {
        return this.temperature;
    }

    public int getActiveSolars() {
        if (this.field_145850_b.field_72995_K) {
            return this.clientSolarAmount;
        }
        int ret = 0;
        for (IEvaporationSolar solar : this.solars) {
            if (solar == null || !solar.canSeeSun()) continue;
            ++ret;
        }
        return ret;
    }

    public boolean buildStructure() {
        EnumFacing right = MekanismUtils.getRight(this.facing);
        EnumFacing left = MekanismUtils.getLeft(this.facing);
        this.height = 0;
        this.controllerConflict = false;
        this.updatedThisTick = true;
        Coord4D startPoint = Coord4D.get(this);
        while (startPoint.offset(EnumFacing.UP).getTileEntity((IBlockAccess)this.field_145850_b) instanceof TileEntityThermalEvaporationBlock) {
            startPoint = startPoint.offset(EnumFacing.UP);
        }
        Coord4D test = startPoint.offset(EnumFacing.DOWN).offset(right, 2);
        this.isLeftOnFace = test.getTileEntity((IBlockAccess)this.field_145850_b) instanceof TileEntityThermalEvaporationBlock;
        if (!this.scanTopLayer(startPoint = startPoint.offset(left, this.isLeftOnFace ? 1 : 2))) {
            return false;
        }
        this.height = 1;
        Coord4D middlePointer = startPoint.offset(EnumFacing.DOWN);
        while (this.scanLowerLayer(middlePointer)) {
            middlePointer = middlePointer.offset(EnumFacing.DOWN);
        }
        this.renderY = middlePointer.y + 1;
        if (this.height < 3 || this.height > 18) {
            this.height = 0;
            return false;
        }
        this.structured = true;
        this.func_70296_d();
        return true;
    }

    public boolean scanTopLayer(Coord4D current) {
        EnumFacing right = MekanismUtils.getRight(this.facing);
        EnumFacing back = MekanismUtils.getBack(this.facing);
        for (int x = 0; x < 4; ++x) {
            for (int z = 0; z < 4; ++z) {
                Coord4D pointer = current.offset(right, x).offset(back, z);
                TileEntity pointerTile = pointer.getTileEntity((IBlockAccess)this.field_145850_b);
                int corner = this.getCorner(x, z);
                if (!(corner != -1 ? !this.addSolarPanel(pointer.getTileEntity((IBlockAccess)this.field_145850_b), corner) && (pointer.offset(EnumFacing.UP).getTileEntity((IBlockAccess)this.field_145850_b) instanceof TileEntityThermalEvaporationBlock || !this.addTankPart(pointerTile)) : (!(x != 1 && x != 2 || z != 1 && z != 2) ? !pointer.isAirBlock((IBlockAccess)this.field_145850_b) : pointer.offset(EnumFacing.UP).getTileEntity((IBlockAccess)this.field_145850_b) instanceof TileEntityThermalEvaporationBlock || !this.addTankPart(pointerTile)))) continue;
                return false;
            }
        }
        return true;
    }

    public int getMaxFluid() {
        return this.height * 4 * 64000;
    }

    public int getCorner(int x, int z) {
        if (x == 0 && z == 0) {
            return 0;
        }
        if (x == 0 && z == 3) {
            return 1;
        }
        if (x == 3 && z == 0) {
            return 2;
        }
        if (x == 3 && z == 3) {
            return 3;
        }
        return -1;
    }

    public boolean scanLowerLayer(Coord4D current) {
        EnumFacing right = MekanismUtils.getRight(this.facing);
        EnumFacing back = MekanismUtils.getBack(this.facing);
        boolean foundCenter = false;
        for (int x = 0; x < 4; ++x) {
            for (int z = 0; z < 4; ++z) {
                Coord4D pointer = current.offset(right, x).offset(back, z);
                TileEntity pointerTile = pointer.getTileEntity((IBlockAccess)this.field_145850_b);
                if (!(x != 1 && x != 2 || z != 1 && z != 2)) {
                    if (pointerTile instanceof TileEntityThermalEvaporationBlock) {
                        if (foundCenter) continue;
                        if (x == 1 && z == 1) {
                            foundCenter = true;
                            continue;
                        }
                        this.height = -1;
                        return false;
                    }
                    if (!foundCenter && pointer.isAirBlock((IBlockAccess)this.field_145850_b)) continue;
                    this.height = -1;
                    return false;
                }
                if (this.addTankPart(pointerTile)) continue;
                this.height = -1;
                return false;
            }
        }
        ++this.height;
        return !foundCenter;
    }

    public boolean addTankPart(TileEntity tile) {
        if (tile instanceof TileEntityThermalEvaporationBlock && (tile == this || !(tile instanceof TileEntityThermalEvaporationController))) {
            if (tile != this) {
                ((TileEntityThermalEvaporationBlock)tile).addToStructure(Coord4D.get(this));
                this.tankParts.add(Coord4D.get(tile));
            }
            return true;
        }
        if (tile != this && tile instanceof TileEntityThermalEvaporationController) {
            this.controllerConflict = true;
        }
        return false;
    }

    public boolean addSolarPanel(TileEntity tile, int i) {
        if (tile != null && !tile.func_145837_r() && CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.EVAPORATION_SOLAR_CAPABILITY, EnumFacing.DOWN)) {
            this.solars[i] = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.EVAPORATION_SOLAR_CAPABILITY, EnumFacing.DOWN);
            return true;
        }
        return false;
    }

    public int getScaledTempLevel(int i) {
        return (int)((double)i * Math.min(1.0, (double)this.getTemperature() / MekanismConfig.current().general.evaporationMaxTemp.val()));
    }

    public Coord4D getRenderLocation() {
        if (!this.structured) {
            return null;
        }
        EnumFacing right = MekanismUtils.getRight(this.facing);
        Coord4D startPoint = Coord4D.get(this).offset(right);
        startPoint = this.isLeftOnFace ? startPoint.offset(right) : startPoint;
        startPoint = startPoint.offset(right.func_176734_d()).offset(MekanismUtils.getBack(this.facing));
        startPoint.y = this.renderY;
        return startPoint;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            TileUtils.readTankData(dataStream, this.inputTank);
            TileUtils.readTankData(dataStream, this.outputTank);
            this.structured = dataStream.readBoolean();
            this.controllerConflict = dataStream.readBoolean();
            this.clientSolarAmount = dataStream.readInt();
            this.height = dataStream.readInt();
            this.temperature = dataStream.readFloat();
            this.biomeTemp = dataStream.readFloat();
            this.isLeftOnFace = dataStream.readBoolean();
            this.lastGain = dataStream.readFloat();
            this.totalLoss = dataStream.readFloat();
            this.renderY = dataStream.readInt();
            if (this.structured != this.clientStructured) {
                this.inputTank.setCapacity(this.getMaxFluid());
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
                if (this.structured) {
                    BlockPos corner1 = this.getRenderLocation().getPos().func_177972_a(this.facing).func_177972_a(this.facing.func_176735_f()).func_177977_b();
                    BlockPos corner2 = corner1.func_177967_a(this.facing.func_176734_d(), 3).func_177967_a(this.facing.func_176735_f().func_176734_d(), 3).func_177981_b(this.height - 1);
                    Mekanism.proxy.doMultiblockSparkle(this, corner1, corner2, tile -> tile instanceof TileEntityThermalEvaporationBlock);
                }
                this.clientStructured = this.structured;
            }
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        TileUtils.addTankData(data, this.inputTank);
        TileUtils.addTankData(data, this.outputTank);
        data.add(this.structured);
        data.add(this.controllerConflict);
        data.add(this.getActiveSolars());
        data.add(this.height);
        data.add(Float.valueOf(this.temperature));
        data.add(Float.valueOf(this.biomeTemp));
        data.add(this.isLeftOnFace);
        data.add(Float.valueOf(this.lastGain));
        data.add(Float.valueOf(this.totalLoss));
        data.add(this.renderY);
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.inputTank.readFromNBT(nbtTags.func_74775_l("waterTank"));
        this.outputTank.readFromNBT(nbtTags.func_74775_l("brineTank"));
        this.temperature = nbtTags.func_74760_g("temperature");
        this.partialInput = nbtTags.func_74769_h("partialWater");
        this.partialOutput = nbtTags.func_74769_h("partialBrine");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74782_a("waterTank", (NBTBase)this.inputTank.writeToNBT(new NBTTagCompound()));
        nbtTags.func_74782_a("brineTank", (NBTBase)this.outputTank.writeToNBT(new NBTTagCompound()));
        nbtTags.func_74776_a("temperature", this.temperature);
        nbtTags.func_74780_a("partialWater", this.partialInput);
        nbtTags.func_74780_a("partialBrine", this.partialOutput);
        return nbtTags;
    }

    @Override
    public boolean canSetFacing(@Nonnull EnumFacing facing) {
        return facing != EnumFacing.DOWN && facing != EnumFacing.UP;
    }

    @Override
    public TileEntityThermalEvaporationController getController() {
        return this.structured ? this : null;
    }

    public void clearStructure() {
        for (Coord4D tankPart : this.tankParts) {
            TileEntity tile = tankPart.getTileEntity((IBlockAccess)this.field_145850_b);
            if (!(tile instanceof TileEntityThermalEvaporationBlock)) continue;
            ((TileEntityThermalEvaporationBlock)tile).controllerGone();
        }
        this.tankParts.clear();
        this.solars = new IEvaporationSolar[]{null, null, null, null};
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public boolean getActive() {
        return this.structured;
    }

    @Override
    public void setActive(boolean active) {
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public boolean lightUpdate() {
        return false;
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.inputTank, this.outputTank};
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return this.getController() == null ? InventoryUtils.EMPTY : SLOTS;
    }

    @Override
    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        if (slot == 0) {
            return FluidContainerUtils.isFluidContainer(stack) && FluidUtil.getFluidContained((ItemStack)stack) != null;
        }
        if (slot == 2) {
            return FluidContainerUtils.isFluidContainer(stack) && FluidUtil.getFluidContained((ItemStack)stack) == null;
        }
        return false;
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return false;
        }
        return super.isCapabilityDisabled(capability, side);
    }
}

