/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mekanism.api.EnumColor;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.SideData;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ITierUpgradeable;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tier.BaseTier;
import mekanism.common.tier.GasTankTier;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.GasUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TileUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityGasTank
extends TileEntityContainerBlock
implements IGasHandler,
IRedstoneControl,
ISideConfiguration,
ISecurityTile,
ITierUpgradeable,
IComputerIntegration,
IComparatorSupport {
    private static final String[] methods = new String[]{"getMaxGas", "getStoredGas", "getGas"};
    public GasTank gasTank;
    public GasTankTier tier = GasTankTier.BASIC;
    public GasMode dumping;
    public int currentGasAmount;
    public int currentRedstoneLevel;
    public IRedstoneControl.RedstoneControl controlType;
    public TileComponentEjector ejectorComponent;
    public TileComponentConfig configComponent = new TileComponentConfig(this, TransmissionType.GAS, TransmissionType.ITEM);
    public TileComponentSecurity securityComponent;

    public TileEntityGasTank() {
        super("GasTank");
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("None", EnumColor.GREY, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Fill", EnumColor.DARK_BLUE, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Empty", EnumColor.DARK_RED, new int[]{1}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{2, 1, 0, 0, 0, 0});
        this.configComponent.setCanEject(TransmissionType.ITEM, false);
        this.configComponent.setIOConfig(TransmissionType.GAS);
        this.configComponent.setEjecting(TransmissionType.GAS, true);
        this.gasTank = new GasTank(this.tier.getStorage());
        this.inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
        this.dumping = GasMode.IDLE;
        this.controlType = IRedstoneControl.RedstoneControl.DISABLED;
        this.ejectorComponent = new TileComponentEjector(this);
        this.securityComponent = new TileComponentSecurity(this);
    }

    @Override
    public void onUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            int newGasAmount;
            TileUtils.drawGas((ItemStack)this.inventory.get(0), this.gasTank, this.tier != GasTankTier.CREATIVE);
            if (TileUtils.receiveGas((ItemStack)this.inventory.get(1), this.gasTank) && this.tier == GasTankTier.CREATIVE && this.gasTank.getGas() != null) {
                this.gasTank.getGas().amount = Integer.MAX_VALUE;
            }
            if (this.gasTank.getGas() != null && MekanismUtils.canFunction(this) && (this.tier == GasTankTier.CREATIVE || this.dumping != GasMode.DUMPING) && this.configComponent.isEjecting(TransmissionType.GAS)) {
                GasStack toSend = new GasStack(this.gasTank.getGas().getGas(), Math.min(this.gasTank.getStored(), this.tier.getOutput()));
                this.gasTank.draw(GasUtils.emit(toSend, this, this.configComponent.getSidesForData(TransmissionType.GAS, this.facing, 2)), this.tier != GasTankTier.CREATIVE);
            }
            if (this.tier != GasTankTier.CREATIVE) {
                if (this.dumping == GasMode.DUMPING) {
                    this.gasTank.draw(this.tier.getStorage() / 400, true);
                }
                if (this.dumping == GasMode.DUMPING_EXCESS && this.gasTank.getNeeded() < this.tier.getOutput()) {
                    this.gasTank.draw(this.tier.getOutput() - this.gasTank.getNeeded(), true);
                }
            }
            if ((newGasAmount = this.gasTank.getStored()) != this.currentGasAmount) {
                MekanismUtils.saveChunk(this);
            }
            this.currentGasAmount = newGasAmount;
            int newRedstoneLevel = this.getRedstoneLevel();
            if (newRedstoneLevel != this.currentRedstoneLevel) {
                this.func_70296_d();
                this.currentRedstoneLevel = newRedstoneLevel;
            }
        }
    }

    @Override
    public boolean upgrade(BaseTier upgradeTier) {
        if (upgradeTier.ordinal() != this.tier.ordinal() + 1) {
            return false;
        }
        this.tier = GasTankTier.values()[upgradeTier.ordinal()];
        this.gasTank.setMaxGas(this.tier.getStorage());
        Mekanism.packetHandler.sendUpdatePacket(this);
        this.func_70296_d();
        return true;
    }

    @Override
    @Nonnull
    public String func_70005_c_() {
        return LangUtils.localize("tile.GasTank" + this.tier.getBaseTier().getSimpleName() + ".name");
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack) == null;
        }
        if (slotID == 0) {
            return itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack) != null && ((IGasItem)itemstack.func_77973_b()).getGas((ItemStack)itemstack).amount == ((IGasItem)itemstack.func_77973_b()).getMaxGas(itemstack);
        }
        return false;
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        if (slotID == 0) {
            return itemstack.func_77973_b() instanceof IGasItem && (this.gasTank.getGas() == null || ((IGasItem)itemstack.func_77973_b()).canReceiveGas(itemstack, this.gasTank.getGas().getGas()));
        }
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IGasItem && (this.gasTank.getGas() == null || ((IGasItem)itemstack.func_77973_b()).canProvideGas(itemstack, this.gasTank.getGas().getGas()));
        }
        return false;
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        return this.configComponent.getOutput((TransmissionType)TransmissionType.ITEM, (EnumFacing)side, (EnumFacing)this.facing).availableSlots;
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.tier == GasTankTier.CREATIVE) {
            return stack != null ? stack.amount : 0;
        }
        return this.gasTank.receive(stack, doTransfer);
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        if (this.canDrawGas(side, null)) {
            return this.gasTank.draw(amount, doTransfer && this.tier != GasTankTier.CREATIVE);
        }
        return null;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        if (this.configComponent.hasSideForData(TransmissionType.GAS, this.facing, 2, side)) {
            return this.gasTank.canDraw(type);
        }
        return false;
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        if (this.configComponent.hasSideForData(TransmissionType.GAS, this.facing, 1, side)) {
            return this.gasTank.canReceive(type);
        }
        return false;
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.gasTank};
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        return this.configComponent.isCapabilityDisabled(capability, side, this.facing) || super.isCapabilityDisabled(capability, side);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int type = dataStream.readInt();
            if (type == 0) {
                int index = (this.dumping.ordinal() + 1) % GasMode.values().length;
                this.dumping = GasMode.values()[index];
            }
            for (EntityPlayer player : this.playersUsing) {
                Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(this), (EntityPlayerMP)player);
            }
            return;
        }
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            GasTankTier prevTier = this.tier;
            this.tier = GasTankTier.values()[dataStream.readInt()];
            this.gasTank.setMaxGas(this.tier.getStorage());
            TileUtils.readTankData(dataStream, this.gasTank);
            this.dumping = GasMode.values()[dataStream.readInt()];
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            if (prevTier != this.tier) {
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.tier = GasTankTier.values()[nbtTags.func_74762_e("tier")];
        this.gasTank.read(nbtTags.func_74775_l("gasTank"));
        this.dumping = GasMode.values()[nbtTags.func_74762_e("dumping")];
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("tier", this.tier.ordinal());
        nbtTags.func_74782_a("gasTank", (NBTBase)this.gasTank.write(new NBTTagCompound()));
        nbtTags.func_74768_a("dumping", this.dumping.ordinal());
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        return nbtTags;
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.tier.ordinal());
        TileUtils.addTankData(data, this.gasTank);
        data.add(this.dumping.ordinal());
        data.add(this.controlType.ordinal());
        return data;
    }

    @Override
    public boolean canSetFacing(@Nonnull EnumFacing facing) {
        return facing != EnumFacing.DOWN && facing != EnumFacing.UP;
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.gasTank.getStored(), this.gasTank.getMaxGas());
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    @Override
    public TileComponentEjector getEjector() {
        return this.ejectorComponent;
    }

    @Override
    public TileComponentConfig getConfig() {
        return this.configComponent;
    }

    @Override
    public EnumFacing getOrientation() {
        return this.facing;
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        switch (method) {
            case 0: {
                return new Object[]{this.gasTank.getMaxGas()};
            }
            case 1: {
                return new Object[]{this.gasTank.getStored()};
            }
            case 2: {
                return new Object[]{this.gasTank.getGas()};
            }
        }
        throw new NoSuchMethodException();
    }

    public static enum GasMode {
        IDLE("gui.idle"),
        DUMPING_EXCESS("gui.dumping"),
        DUMPING("gui.dumping_excess");

        private final String langKey;

        private GasMode(String langKey) {
            this.langKey = langKey;
        }

        public String getLangKey() {
            return this.langKey;
        }

        public static <T> T chooseByMode(GasMode dumping, T idleOption, T dumpingOption, T dumpingExcessOption) {
            switch (dumping) {
                case IDLE: {
                    return idleOption;
                }
                case DUMPING: {
                    return dumpingOption;
                }
                case DUMPING_EXCESS: {
                    return dumpingExcessOption;
                }
            }
            return idleOption;
        }
    }
}

