/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration;

import ic2.api.recipe.Recipes;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.infuse.InfuseObject;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.api.infuse.InfuseType;
import mekanism.common.Mekanism;
import mekanism.common.MekanismFluids;
import mekanism.common.MekanismItems;
import mekanism.common.Resource;
import mekanism.common.config.MekanismConfig;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.util.StackUtils;
import mekanism.common.world.DummyWorld;
import net.minecraft.block.BlockPlanks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;

@Mod.EventBusSubscriber(modid="mekanism")
public final class OreDictManager {
    private static final List<String> minorCompatIngot = Arrays.asList("Aluminum", "Draconium", "Iridium", "Mithril", "Nickel", "Platinum", "Uranium");
    private static final List<String> minorCompatGem = Arrays.asList("Amber", "Diamond", "Emerald", "Malachite", "Peridot", "Ruby", "Sapphire", "Tanzanite", "Topaz");

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void init(RegistryEvent.Register<IRecipe> event) {
        OreDictManager.addLogRecipes();
        for (ItemStack plankWood : OreDictionary.getOres((String)"plankWood", (boolean)false)) {
            ItemStack plank = StackUtils.size(plankWood, 1);
            if (!RecipeHandler.Recipe.PRECISION_SAWMILL.containsRecipe(plank)) {
                RecipeHandler.addPrecisionSawmillRecipe(plank, new ItemStack(Items.field_151055_y, 6), new ItemStack(MekanismItems.Sawdust), MekanismConfig.current().general.sawdustChancePlank.val());
            }
            RecipeHandler.addPRCRecipe(plank, new FluidStack(FluidRegistry.WATER, 20), new GasStack(MekanismFluids.Oxygen, 20), ItemStack.field_190927_a, new GasStack(MekanismFluids.Hydrogen, 20), 0.0, 30);
        }
        for (ItemStack slabWood : OreDictionary.getOres((String)"slabWood", (boolean)false)) {
            ItemStack slab = StackUtils.size(slabWood, 1);
            if (!RecipeHandler.Recipe.PRECISION_SAWMILL.containsRecipe(slab)) {
                RecipeHandler.addPrecisionSawmillRecipe(slab, new ItemStack(Items.field_151055_y, 3), new ItemStack(MekanismItems.Sawdust), MekanismConfig.current().general.sawdustChancePlank.val() / 2.0);
            }
            RecipeHandler.addPRCRecipe(slab, new FluidStack(FluidRegistry.WATER, 10), new GasStack(MekanismFluids.Oxygen, 10), ItemStack.field_190927_a, new GasStack(MekanismFluids.Hydrogen, 10), 0.0, 15);
        }
        for (ItemStack stickWood : OreDictionary.getOres((String)"stickWood", (boolean)false)) {
            ItemStack stick = StackUtils.size(stickWood, 1);
            if (!RecipeHandler.Recipe.PRECISION_SAWMILL.containsRecipe(stick)) {
                RecipeHandler.addPrecisionSawmillRecipe(stick, new ItemStack(MekanismItems.Sawdust));
            }
            RecipeHandler.addPRCRecipe(stick, new FluidStack(FluidRegistry.WATER, 4), new GasStack(MekanismFluids.Oxygen, 4), ItemStack.field_190927_a, new GasStack(MekanismFluids.Hydrogen, 4), 0.0, 6);
        }
        for (Object ore : OreDictionary.getOres((String)"oreNetherSteel", (boolean)false)) {
            RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size((ItemStack)ore, 1), new ItemStack(MekanismItems.OtherDust, 4, 1));
        }
        NonNullList oreDict = OreDictionary.getOres((String)"itemRubber", (boolean)false);
        if (oreDict.size() > 0) {
            Resource[] itemRubber = StackUtils.size((ItemStack)oreDict.get(0), 1);
            for (ItemStack rubber : OreDictionary.getOres((String)"woodRubber", (boolean)false)) {
                RecipeHandler.addPrecisionSawmillRecipe(StackUtils.size(rubber, 1), new ItemStack(Blocks.field_150344_f, BlockPlanks.EnumType.JUNGLE.func_176839_a(), 4), (ItemStack)itemRubber, 1.0);
            }
        }
        for (ItemStack sulfur : OreDictionary.getOres((String)"dustSulfur", (boolean)false)) {
            RecipeHandler.addChemicalOxidizerRecipe(StackUtils.size(sulfur, 1), new GasStack(MekanismFluids.SulfurDioxide, 100));
        }
        for (ItemStack salt : OreDictionary.getOres((String)"dustSalt", (boolean)false)) {
            RecipeHandler.addChemicalOxidizerRecipe(StackUtils.size(salt, 1), new GasStack(MekanismFluids.Brine, 15));
        }
        for (ItemStack dust : OreDictionary.getOres((String)"dustRefinedObsidian", (boolean)false)) {
            RecipeHandler.addOsmiumCompressorRecipe(StackUtils.size(dust, 1), new ItemStack(MekanismItems.Ingot, 1, 0));
            RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(dust, 1), new ItemStack(MekanismItems.CompressedObsidian));
            InfuseRegistry.registerInfuseObject(StackUtils.size(dust, 1), new InfuseObject(InfuseRegistry.get("OBSIDIAN"), 10));
        }
        for (Resource resource : Resource.values()) {
            Object ingot2;
            for (ItemStack clump : OreDictionary.getOres((String)("clump" + resource.getName()), (boolean)false)) {
                RecipeHandler.addCrusherRecipe(StackUtils.size(clump, 1), new ItemStack(MekanismItems.DirtyDust, 1, resource.ordinal()));
            }
            for (ItemStack shard : OreDictionary.getOres((String)("shard" + resource.getName()), (boolean)false)) {
                RecipeHandler.addPurificationChamberRecipe(StackUtils.size(shard, 1), new ItemStack(MekanismItems.Clump, 1, resource.ordinal()));
            }
            for (ItemStack crystal : OreDictionary.getOres((String)("crystal" + resource.getName()), (boolean)false)) {
                RecipeHandler.addChemicalInjectionChamberRecipe(StackUtils.size(crystal, 1), MekanismFluids.HydrogenChloride, new ItemStack(MekanismItems.Shard, 1, resource.ordinal()));
            }
            for (ItemStack dust : OreDictionary.getOres((String)("dustDirty" + resource.getName()), (boolean)false)) {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(dust, 1), new ItemStack(MekanismItems.Dust, 1, resource.ordinal()));
            }
            for (ItemStack ore : OreDictionary.getOres((String)("ore" + resource.getName()), (boolean)false)) {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), new ItemStack(MekanismItems.Dust, 2, resource.ordinal()));
                RecipeHandler.addPurificationChamberRecipe(StackUtils.size(ore, 1), new ItemStack(MekanismItems.Clump, 3, resource.ordinal()));
                RecipeHandler.addChemicalInjectionChamberRecipe(StackUtils.size(ore, 1), MekanismFluids.HydrogenChloride, new ItemStack(MekanismItems.Shard, 4, resource.ordinal()));
                RecipeHandler.addChemicalDissolutionChamberRecipe(StackUtils.size(ore, 1), new GasStack(GasRegistry.getGas(resource.getName()), 1000));
            }
            for (Object ingot2 : OreDictionary.getOres((String)("ingot" + resource.getName()), (boolean)false)) {
                RecipeHandler.addCrusherRecipe(StackUtils.size((ItemStack)ingot2, 1), new ItemStack(MekanismItems.Dust, 1, resource.ordinal()));
            }
            oreDict = OreDictionary.getOres((String)("ore" + resource.getName()), (boolean)false);
            if (oreDict.size() <= 0) continue;
            ItemStack ore = StackUtils.size((ItemStack)oreDict.get(0), 1);
            ingot2 = OreDictionary.getOres((String)("dust" + resource.getName()), (boolean)false).iterator();
            while (ingot2.hasNext()) {
                ItemStack dust = (ItemStack)ingot2.next();
                RecipeHandler.addCombinerRecipe(StackUtils.size(dust, 8), new ItemStack(Blocks.field_150347_e), ore);
            }
        }
        minorCompatIngot.forEach(OreDictManager::addStandardOredictMetal);
        minorCompatGem.forEach(OreDictManager::addStandardOredictGem);
        oreDict = OreDictionary.getOres((String)"dustYellorium", (boolean)false);
        if (oreDict.size() > 0) {
            ItemStack dustYellorium = StackUtils.size((ItemStack)oreDict.get(0), 2);
            for (ItemStack ore : OreDictionary.getOres((String)"oreYellorite", (boolean)false)) {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), dustYellorium);
            }
        }
        if ((oreDict = OreDictionary.getOres((String)"dustNetherQuartz", (boolean)false)).size() > 0) {
            ItemStack dustNeterQuartz = StackUtils.size((ItemStack)oreDict.get(0), 1);
            for (ItemStack gem : OreDictionary.getOres((String)"gemQuartz", (boolean)false)) {
                RecipeHandler.addCrusherRecipe(StackUtils.size(gem, 1), dustNeterQuartz);
            }
        }
        if ((oreDict = OreDictionary.getOres((String)"oreQuartz", (boolean)false)).size() > 0) {
            ItemStack oreQuartz = StackUtils.size((ItemStack)oreDict.get(0), 1);
            oreDict = OreDictionary.getOres((String)"dustQuartz", (boolean)false);
            if (oreDict.size() > 0) {
                for (ItemStack dust : oreDict) {
                    RecipeHandler.addCombinerRecipe(StackUtils.size(dust, 8), new ItemStack(Blocks.field_150347_e), oreQuartz);
                }
            } else {
                for (ItemStack gem : OreDictionary.getOres((String)"gemQuartz", (boolean)false)) {
                    RecipeHandler.addCombinerRecipe(StackUtils.size(gem, 8), new ItemStack(Blocks.field_150347_e), oreQuartz);
                }
            }
        }
        if ((oreDict = OreDictionary.getOres((String)"gemQuartz", (boolean)false)).size() > 0) {
            ItemStack gemQuartz = StackUtils.size((ItemStack)oreDict.get(0), 1);
            for (ItemStack dust : OreDictionary.getOres((String)"dustNetherQuartz", (boolean)false)) {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(dust, 1), gemQuartz);
            }
            gemQuartz = StackUtils.size(gemQuartz, 6);
            for (ItemStack ore : OreDictionary.getOres((String)"oreQuartz", (boolean)false)) {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), gemQuartz);
            }
        }
        if ((oreDict = OreDictionary.getOres((String)"dustLapis", (boolean)false)).size() > 0) {
            ItemStack dustLapis = StackUtils.size((ItemStack)oreDict.get(0), 1);
            for (ItemStack gem : OreDictionary.getOres((String)"gemLapis", (boolean)false)) {
                RecipeHandler.addCrusherRecipe(StackUtils.size(gem, 1), dustLapis);
            }
        }
        if ((oreDict = OreDictionary.getOres((String)"oreLapis", (boolean)false)).size() > 0) {
            ItemStack oreLapis = StackUtils.size((ItemStack)oreDict.get(0), 1);
            oreDict = OreDictionary.getOres((String)"dustLapis", (boolean)false);
            if (oreDict.size() > 0) {
                for (ItemStack dust : oreDict) {
                    RecipeHandler.addCombinerRecipe(StackUtils.size(dust, 16), new ItemStack(Blocks.field_150347_e), oreLapis);
                }
            } else {
                for (ItemStack gem : OreDictionary.getOres((String)"gemLapis", (boolean)false)) {
                    RecipeHandler.addCombinerRecipe(StackUtils.size(gem, 16), new ItemStack(Blocks.field_150347_e), oreLapis);
                }
            }
        }
        if ((oreDict = OreDictionary.getOres((String)"gemLapis", (boolean)false)).size() > 0) {
            ItemStack gemLapis = StackUtils.size((ItemStack)oreDict.get(0), 1);
            for (ItemStack dust : OreDictionary.getOres((String)"dustLapis", (boolean)false)) {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(dust, 1), gemLapis);
            }
            gemLapis = StackUtils.size(gemLapis, 12);
            for (ItemStack ore : OreDictionary.getOres((String)"oreLapis", (boolean)false)) {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), gemLapis);
            }
        }
        if ((oreDict = OreDictionary.getOres((String)"oreRedstone", (boolean)false)).size() > 0) {
            ItemStack oreRedstone = StackUtils.size((ItemStack)oreDict.get(0), 1);
            for (ItemStack dust : OreDictionary.getOres((String)"dustRedstone", (boolean)false)) {
                RecipeHandler.addCombinerRecipe(StackUtils.size(dust, 16), new ItemStack(Blocks.field_150347_e), oreRedstone);
            }
        }
        if ((oreDict = OreDictionary.getOres((String)"dustRedstone", (boolean)false)).size() > 0) {
            Iterator dustRedstone = StackUtils.size((ItemStack)oreDict.get(0), 12);
            for (ItemStack ore : OreDictionary.getOres((String)"oreRedstone", (boolean)false)) {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), (ItemStack)dustRedstone);
            }
        }
        for (ItemStack ore : OreDictionary.getOres((String)"oreCoal", (boolean)false)) {
            RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), new ItemStack(Items.field_151044_h, 2));
        }
        oreDict = OreDictionary.getOres((String)"oreAmethyst", (boolean)false);
        if (oreDict.size() > 0) {
            ItemStack oreAmethyst = StackUtils.size((ItemStack)oreDict.get(0), 1);
            oreDict = OreDictionary.getOres((String)"dustAmethyst", (boolean)false);
            if (oreDict.size() > 0) {
                for (ItemStack dust : oreDict) {
                    RecipeHandler.addCombinerRecipe(StackUtils.size(dust, 3), new ItemStack(Blocks.field_150377_bs), oreAmethyst);
                }
            } else {
                for (ItemStack gem : OreDictionary.getOres((String)"gemAmethyst", (boolean)false)) {
                    RecipeHandler.addCombinerRecipe(StackUtils.size(gem, 3), new ItemStack(Blocks.field_150377_bs), oreAmethyst);
                }
            }
        }
        if ((oreDict = OreDictionary.getOres((String)"gemAmethyst", (boolean)false)).size() > 0) {
            ItemStack gemAmethyst = StackUtils.size((ItemStack)oreDict.get(0), 2);
            for (ItemStack ore : OreDictionary.getOres((String)"oreAmethyst", (boolean)false)) {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), gemAmethyst);
            }
        }
        if ((oreDict = OreDictionary.getOres((String)"oreApatite", (boolean)false)).size() > 0) {
            ItemStack oreApatite = StackUtils.size((ItemStack)oreDict.get(0), 1);
            oreDict = OreDictionary.getOres((String)"dustApatite", (boolean)false);
            if (oreDict.size() > 0) {
                for (ItemStack dust : oreDict) {
                    RecipeHandler.addCombinerRecipe(StackUtils.size(dust, 6), new ItemStack(Blocks.field_150347_e), oreApatite);
                }
            } else {
                for (ItemStack gem : OreDictionary.getOres((String)"gemApatite", (boolean)false)) {
                    RecipeHandler.addCombinerRecipe(StackUtils.size(gem, 6), new ItemStack(Blocks.field_150347_e), oreApatite);
                }
            }
        }
        if ((oreDict = OreDictionary.getOres((String)"gemApatite", (boolean)false)).size() > 0) {
            ItemStack gemApatite = StackUtils.size((ItemStack)oreDict.get(0), 4);
            for (ItemStack ore : OreDictionary.getOres((String)"oreApatite", (boolean)false)) {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), gemApatite);
            }
        }
        InfuseType tinInfuseType = InfuseRegistry.get("TIN");
        for (ItemStack ingot : OreDictionary.getOres((String)"ingotCopper", (boolean)false)) {
            RecipeHandler.addMetallurgicInfuserRecipe(tinInfuseType, 10, StackUtils.size(ingot, 3), new ItemStack(MekanismItems.Ingot, 4, 2));
        }
        for (ItemStack ingot : OreDictionary.getOres((String)"ingotRefinedObsidian", (boolean)false)) {
            RecipeHandler.addCrusherRecipe(StackUtils.size(ingot, 1), new ItemStack(MekanismItems.OtherDust, 1, 5));
        }
        InfuseType redstoneInfuseType = InfuseRegistry.get("REDSTONE");
        for (ItemStack ingot : OreDictionary.getOres((String)"ingotOsmium", (boolean)false)) {
            RecipeHandler.addMetallurgicInfuserRecipe(redstoneInfuseType, 10, StackUtils.size(ingot, 1), new ItemStack(MekanismItems.ControlCircuit, 1, 0));
        }
        for (ItemStack ingot : OreDictionary.getOres((String)"ingotRedstone", (boolean)false)) {
            RecipeHandler.addCrusherRecipe(StackUtils.size(ingot, 1), new ItemStack(Items.field_151137_ax));
        }
        for (ItemStack ingot : OreDictionary.getOres((String)"ingotRefinedGlowstone", (boolean)false)) {
            RecipeHandler.addCrusherRecipe(StackUtils.size(ingot, 1), new ItemStack(Items.field_151114_aO));
        }
        for (Object dust : OreDictionary.getOres((String)"dustCoal", (boolean)false)) {
            RecipeHandler.addEnrichmentChamberRecipe((ItemStack)dust, new ItemStack(Items.field_151044_h));
        }
        for (Object dust : OreDictionary.getOres((String)"dustCharCoal", (boolean)false)) {
            RecipeHandler.addEnrichmentChamberRecipe((ItemStack)dust, new ItemStack(Items.field_151044_h, 1, 1));
        }
        oreDict = OreDictionary.getOres((String)"dustBronze", (boolean)false);
        if (oreDict.size() > 0) {
            ItemStack dustBronze = StackUtils.size((ItemStack)oreDict.get(0), 1);
            RecipeHandler.addCrusherRecipe(new ItemStack(MekanismItems.Ingot, 1, 2), dustBronze);
        }
        if (Mekanism.hooks.IC2Loaded) {
            OreDictManager.addIC2BronzeRecipe();
        }
        if ((oreDict = OreDictionary.getOres((String)"ingotSilver", (boolean)false)).size() > 0) {
            ItemStack ingotSilver = StackUtils.size((ItemStack)oreDict.get(0), 1);
            FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(MekanismItems.Dust, 1, Resource.SILVER.ordinal()), ingotSilver, 0.0f);
        }
        if ((oreDict = OreDictionary.getOres((String)"ingotLead", (boolean)false)).size() > 0) {
            ItemStack ingotLead = StackUtils.size((ItemStack)oreDict.get(0), 1);
            FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(MekanismItems.Dust, 1, Resource.LEAD.ordinal()), ingotLead, 0.0f);
        }
        if ((oreDict = OreDictionary.getOres((String)"dustCoal", (boolean)false)).size() > 0) {
            ItemStack dustCoal = StackUtils.size((ItemStack)oreDict.get(0), 1);
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_151044_h), dustCoal);
        }
        if ((oreDict = OreDictionary.getOres((String)"dustCharcoal", (boolean)false)).size() > 0) {
            ItemStack dustCharcoal = StackUtils.size((ItemStack)oreDict.get(0), 1);
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_151044_h, 1, 1), dustCharcoal);
        }
        if ((oreDict = OreDictionary.getOres((String)"dustSaltpeter", (boolean)false)).size() > 0) {
            ItemStack dustSaltpeter = StackUtils.size((ItemStack)oreDict.get(0), 1);
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_151016_H), dustSaltpeter);
        }
        if ((oreDict = OreDictionary.getOres((String)"itemSilicon", (boolean)false)).size() > 0) {
            Iterator itemSilicon = StackUtils.size((ItemStack)oreDict.get(0), 1);
            for (ItemStack sand : OreDictionary.getOres((String)"sand", (boolean)false)) {
                RecipeHandler.addCrusherRecipe(StackUtils.size(sand, 1), (ItemStack)itemSilicon);
            }
        }
        for (Object dust : OreDictionary.getOres((String)"dustSaltpeter", (boolean)false)) {
            RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size((ItemStack)dust, 1), new ItemStack(Items.field_151016_H));
        }
        for (ItemStack ingot : OreDictionary.getOres((String)"ingotSteel", (boolean)false)) {
            RecipeHandler.addCrusherRecipe(StackUtils.size(ingot, 1), new ItemStack(MekanismItems.OtherDust, 1, 1));
        }
        for (Object dust : OreDictionary.getOres((String)"dustLithium", (boolean)false)) {
            RecipeHandler.addChemicalOxidizerRecipe(StackUtils.size((ItemStack)dust, 1), new GasStack(MekanismFluids.Lithium, 100));
        }
        InfuseType diamondInfuseType = InfuseRegistry.get("DIAMOND");
        for (ItemStack dust : OreDictionary.getOres((String)"dustObsidian", (boolean)false)) {
            RecipeHandler.addCombinerRecipe(StackUtils.size(dust, 4), new ItemStack(Blocks.field_150347_e), new ItemStack(Blocks.field_150343_Z));
            RecipeHandler.addMetallurgicInfuserRecipe(diamondInfuseType, 10, StackUtils.size(dust, 1), new ItemStack(MekanismItems.OtherDust, 1, 5));
        }
        for (ItemStack dust : OreDictionary.getOres((String)"dustDiamond", (boolean)false)) {
            InfuseRegistry.registerInfuseObject(dust, new InfuseObject(diamondInfuseType, 10));
        }
        for (ItemStack dust : OreDictionary.getOres((String)"dustTin", (boolean)false)) {
            InfuseRegistry.registerInfuseObject(dust, new InfuseObject(tinInfuseType, 10));
        }
        for (ItemStack sapling : OreDictionary.getOres((String)"treeSapling", (boolean)false)) {
            if (sapling.func_77952_i() != 0 && sapling.func_77952_i() != Short.MAX_VALUE) continue;
            RecipeHandler.addCrusherRecipe(new ItemStack(sapling.func_77973_b(), 1, Short.MAX_VALUE), new ItemStack(MekanismItems.BioFuel, 2));
        }
        for (ItemStack coal : OreDictionary.getOres((String)"blockCoal", (boolean)false)) {
            RecipeHandler.addPRCRecipe(coal, new FluidStack(FluidRegistry.WATER, 1000), new GasStack(MekanismFluids.Oxygen, 1000), new ItemStack(MekanismItems.OtherDust, 9, 3), new GasStack(MekanismFluids.Hydrogen, 1000), 0.0, 900);
        }
        for (ItemStack coal : OreDictionary.getOres((String)"blockCharcoal", (boolean)false)) {
            RecipeHandler.addPRCRecipe(coal, new FluidStack(FluidRegistry.WATER, 1000), new GasStack(MekanismFluids.Oxygen, 1000), new ItemStack(MekanismItems.OtherDust, 9, 3), new GasStack(MekanismFluids.Hydrogen, 1000), 0.0, 900);
        }
        for (ItemStack coal : OreDictionary.getOres((String)"dustCoal", (boolean)false)) {
            RecipeHandler.addPRCRecipe(coal, new FluidStack(FluidRegistry.WATER, 100), new GasStack(MekanismFluids.Oxygen, 100), new ItemStack(MekanismItems.OtherDust, 1, 3), new GasStack(MekanismFluids.Hydrogen, 100), 0.0, 100);
        }
        for (ItemStack coal : OreDictionary.getOres((String)"dustCharcoal", (boolean)false)) {
            RecipeHandler.addPRCRecipe(coal, new FluidStack(FluidRegistry.WATER, 100), new GasStack(MekanismFluids.Oxygen, 100), new ItemStack(MekanismItems.OtherDust, 1, 3), new GasStack(MekanismFluids.Hydrogen, 100), 0.0, 100);
        }
        for (ItemStack sulfur : OreDictionary.getOres((String)"sulphur", (boolean)false)) {
            RecipeHandler.addEnrichmentChamberRecipe(sulfur, new ItemStack(Items.field_151016_H));
        }
        for (ItemStack sawdust : OreDictionary.getOres((String)"dustWood", (boolean)false)) {
            ItemStack dust;
            dust = StackUtils.size(sawdust, 8);
            RecipeHandler.addEnrichmentChamberRecipe(dust, new ItemStack(Items.field_151044_h, 1, 1));
            RecipeHandler.addPRCRecipe(sawdust, new FluidStack(FluidRegistry.WATER, 20), new GasStack(MekanismFluids.Oxygen, 20), ItemStack.field_190927_a, new GasStack(MekanismFluids.Hydrogen, 20), 0.0, 30);
        }
    }

    @Optional.Method(modid="ic2")
    private static void addIC2BronzeRecipe() {
        Recipes.macerator.addRecipe(Recipes.inputFactory.forOreDict("ingotBronze"), null, false, new ItemStack[]{StackUtils.size((ItemStack)OreDictionary.getOres((String)"dustBronze", (boolean)false).get(0), 1)});
    }

    private static void addLogRecipes() {
        Container tempContainer = new Container(){

            public boolean func_75145_c(@Nonnull EntityPlayer player) {
                return false;
            }
        };
        DummyWorld dummyWorld = null;
        try {
            dummyWorld = new DummyWorld();
        }
        catch (Exception exception) {
            // empty catch block
        }
        InventoryCrafting tempCrafting = new InventoryCrafting(tempContainer, 3, 3);
        for (int i = 1; i < 9; ++i) {
            tempCrafting.func_70299_a(i, ItemStack.field_190927_a);
        }
        NonNullList logs = OreDictionary.getOres((String)"logWood", (boolean)false);
        for (ItemStack log : logs) {
            RecipeHandler.addPRCRecipe(log, new FluidStack(FluidRegistry.WATER, 100), new GasStack(MekanismFluids.Oxygen, 100), ItemStack.field_190927_a, new GasStack(MekanismFluids.Hydrogen, 100), 0.0, 150);
        }
        for (ItemStack logEntry : logs) {
            if (logEntry.func_77952_i() == Short.MAX_VALUE) {
                for (int j = 0; j < 16; ++j) {
                    OreDictManager.addSawmillLog(tempCrafting, new ItemStack(logEntry.func_77973_b(), 1, j), dummyWorld);
                }
                continue;
            }
            OreDictManager.addSawmillLog(tempCrafting, StackUtils.size(logEntry, 1), dummyWorld);
        }
    }

    private static void addSawmillLog(InventoryCrafting tempCrafting, ItemStack log, DummyWorld world) {
        ItemStack resultEntry;
        tempCrafting.func_70299_a(0, log);
        IRecipe matchingRecipe = CraftingManager.func_192413_b((InventoryCrafting)tempCrafting, (World)world);
        ItemStack itemStack = resultEntry = matchingRecipe != null ? matchingRecipe.func_77571_b() : ItemStack.field_190927_a;
        if (!resultEntry.func_190926_b()) {
            RecipeHandler.addPrecisionSawmillRecipe(log, StackUtils.size(resultEntry, 6), new ItemStack(MekanismItems.Sawdust), MekanismConfig.current().general.sawdustChanceLog.val());
        }
    }

    public static void addStandardOredictMetal(String suffix) {
        NonNullList dusts = OreDictionary.getOres((String)("dust" + suffix), (boolean)false);
        NonNullList ores = OreDictionary.getOres((String)("ore" + suffix), (boolean)false);
        if (dusts.size() > 0) {
            for (ItemStack ore : ores) {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), StackUtils.size((ItemStack)dusts.get(0), 2));
            }
            for (ItemStack ingot : OreDictionary.getOres((String)("ingot" + suffix), (boolean)false)) {
                RecipeHandler.addCrusherRecipe(StackUtils.size(ingot, 1), StackUtils.size((ItemStack)dusts.get(0), 1));
            }
        }
        if (ores.size() > 0) {
            for (ItemStack dust : dusts) {
                RecipeHandler.addCombinerRecipe(StackUtils.size(dust, 8), new ItemStack(Blocks.field_150347_e), StackUtils.size((ItemStack)ores.get(0), 1));
            }
        }
    }

    public static void addStandardOredictGem(String suffix) {
        block8: {
            NonNullList gems = OreDictionary.getOres((String)("gem" + suffix), (boolean)false);
            NonNullList dusts = OreDictionary.getOres((String)("dust" + suffix), (boolean)false);
            NonNullList ores = OreDictionary.getOres((String)("ore" + suffix), (boolean)false);
            if (gems.size() > 0) {
                for (ItemStack ore : ores) {
                    RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), StackUtils.size((ItemStack)gems.get(0), 2));
                }
            }
            if (dusts.size() > 0) {
                for (ItemStack gem : gems) {
                    RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size((ItemStack)dusts.get(0), 1), StackUtils.size(gem, 1));
                    RecipeHandler.addCrusherRecipe(StackUtils.size(gem, 1), StackUtils.size((ItemStack)dusts.get(0), 1));
                }
            }
            if (ores.size() <= 0) break block8;
            ItemStack ore = StackUtils.size((ItemStack)ores.get(0), 1);
            ItemStack base = new ItemStack(Blocks.field_150347_e);
            if (dusts.size() > 0) {
                for (ItemStack dust : dusts) {
                    RecipeHandler.addCombinerRecipe(StackUtils.size(dust, 3), base, ore);
                }
            } else {
                for (ItemStack gem : gems) {
                    RecipeHandler.addCombinerRecipe(StackUtils.size(gem, 3), base, ore);
                }
            }
        }
    }
}

