/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.filter;

import mekanism.api.Coord4D;
import mekanism.client.gui.button.GuiButtonDisableableImage;
import mekanism.client.gui.filter.GuiModIDFilter;
import mekanism.common.Mekanism;
import mekanism.common.OreDictCache;
import mekanism.common.content.miner.MModIDFilter;
import mekanism.common.network.PacketDigitalMinerGui;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiMModIDFilter
extends GuiModIDFilter<MModIDFilter, TileEntityDigitalMiner> {
    public GuiMModIDFilter(EntityPlayer player, TileEntityDigitalMiner tile, int index) {
        super(player, tile);
        this.origFilter = (MModIDFilter)((TileEntityDigitalMiner)this.tileEntity).filters.get(index);
        this.filter = ((MModIDFilter)((TileEntityDigitalMiner)this.tileEntity).filters.get(index)).clone();
        this.updateStackList(((MModIDFilter)this.filter).getModID());
    }

    public GuiMModIDFilter(EntityPlayer player, TileEntityDigitalMiner tile) {
        super(player, tile);
        this.isNew = true;
        this.filter = new MModIDFilter();
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiMModIDFilter.png");
    }

    @Override
    protected void updateStackList(String modName) {
        this.iterStacks = OreDictCache.getModIDStacks(modName, true);
        this.stackSwitch = 0;
        this.stackIndex = -1;
    }

    @Override
    protected void addButtons() {
        this.saveButton = new GuiButton(0, this.field_147003_i + 27, this.field_147009_r + 62, 60, 20, LangUtils.localize("gui.save"));
        this.field_146292_n.add(this.saveButton);
        this.deleteButton = new GuiButton(1, this.field_147003_i + 89, this.field_147009_r + 62, 60, 20, LangUtils.localize("gui.delete"));
        this.field_146292_n.add(this.deleteButton);
        this.backButton = new GuiButtonDisableableImage(2, this.field_147003_i + 5, this.field_147009_r + 5, 11, 11, 176, 11, -11, this.getGuiLocation());
        this.field_146292_n.add(this.backButton);
        this.replaceButton = new GuiButtonDisableableImage(3, this.field_147003_i + 148, this.field_147009_r + 45, 14, 14, 199, 14, -14, this.getGuiLocation());
        this.field_146292_n.add(this.replaceButton);
        this.checkboxButton = new GuiButtonDisableableImage(4, this.field_147003_i + 131, this.field_147009_r + 47, 12, 12, 187, 12, -12, this.getGuiLocation());
        this.field_146292_n.add(this.checkboxButton);
    }

    @Override
    protected void sendPacketToServer(int guiID) {
        Mekanism.packetHandler.sendToServer(new PacketDigitalMinerGui.DigitalMinerGuiMessage(PacketDigitalMinerGui.MinerGuiPacket.SERVER, Coord4D.get(this.tileEntity), guiID, 0, 0));
    }
}

