/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gas;

import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import net.minecraft.nbt.NBTTagCompound;

public class GasStack {
    public int amount;
    private Gas type;

    public GasStack(int id, int quantity) {
        this.type = GasRegistry.getGas(id);
        this.amount = quantity;
    }

    public GasStack(Gas gas, int quantity) {
        this.type = gas;
        this.amount = quantity;
    }

    private GasStack() {
    }

    @Nullable
    public static GasStack readFromNBT(NBTTagCompound nbtTags) {
        if (nbtTags == null || nbtTags.func_82582_d()) {
            return null;
        }
        GasStack stack = new GasStack();
        stack.read(nbtTags);
        if (stack.getGas() == null || stack.amount <= 0) {
            return null;
        }
        return stack;
    }

    public Gas getGas() {
        return this.type;
    }

    public GasStack withAmount(int newAmount) {
        this.amount = newAmount;
        return this;
    }

    public NBTTagCompound write(NBTTagCompound nbtTags) {
        this.type.write(nbtTags);
        nbtTags.func_74768_a("amount", this.amount);
        return nbtTags;
    }

    public void read(NBTTagCompound nbtTags) {
        this.type = Gas.readFromNBT(nbtTags);
        this.amount = nbtTags.func_74762_e("amount");
    }

    public GasStack copy() {
        return new GasStack(this.type, this.amount);
    }

    public boolean isGasEqual(GasStack stack) {
        return stack != null && this.getGas() == stack.getGas();
    }

    public String toString() {
        return "[" + this.type + ", " + this.amount + "]";
    }

    public int hashCode() {
        return this.type == null ? 0 : this.type.getID();
    }
}

