/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.generator;

import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import reborncore.api.IToolDrop;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.FluidUtils;
import reborncore.common.util.Inventory;
import reborncore.common.util.Tank;
import techreborn.api.generator.EFluidGenerator;
import techreborn.api.generator.FluidGeneratorRecipe;
import techreborn.api.generator.FluidGeneratorRecipeList;
import techreborn.api.generator.GeneratorRecipeHelper;

public abstract class TileBaseFluidGenerator
extends TilePowerAcceptor
implements IToolDrop,
IInventoryProvider {
    private final FluidGeneratorRecipeList recipes;
    private final int euTick;
    private FluidGeneratorRecipe currentRecipe;
    private int ticksSinceLastChange;
    public final Tank tank;
    public final Inventory inventory;
    protected long lastOutput = 0L;
    double pendingWithdraw = 0.0;

    public TileBaseFluidGenerator(EFluidGenerator type, String tileName, int tankCapacity, int euTick) {
        this.recipes = GeneratorRecipeHelper.getFluidRecipesForGenerator(type);
        this.tank = new Tank(tileName, tankCapacity, (TileLegacyMachineBase)this);
        this.inventory = new Inventory(3, tileName, 64, (TileEntity)this);
        this.euTick = euTick;
        this.ticksSinceLastChange = 0;
    }

    public void func_73660_a() {
        super.func_73660_a();
        ++this.ticksSinceLastChange;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.ticksSinceLastChange >= 10) {
            if (!this.inventory.func_70301_a(0).func_190926_b()) {
                FluidUtils.drainContainers((IFluidHandler)this.tank, (IInventory)this.inventory, (int)0, (int)1);
                FluidUtils.fillContainers((IFluidHandler)this.tank, (IInventory)this.inventory, (int)0, (int)1, (Fluid)this.tank.getFluidType());
            }
            this.tank.setTileEntity((TileEntity)this);
            this.tank.compareAndUpdate();
            this.ticksSinceLastChange = 0;
        }
        if (this.tank.getFluidAmount() > 0) {
            if (this.currentRecipe == null || !FluidUtils.fluidEquals((Fluid)this.currentRecipe.getFluid(), (Fluid)this.tank.getFluidType())) {
                this.currentRecipe = this.getRecipes().getRecipeForFluid(this.tank.getFluidType()).orElse(null);
            }
            if (this.currentRecipe != null) {
                Integer euPerBucket = this.currentRecipe.getEnergyPerMb() * 1000;
                float millibucketsPerTick = (float)(this.euTick * 1000) / (float)euPerBucket.intValue();
                if (this.tryAddingEnergy(this.euTick)) {
                    this.pendingWithdraw += (double)millibucketsPerTick;
                    int currentWithdraw = (int)this.pendingWithdraw;
                    this.pendingWithdraw -= (double)currentWithdraw;
                    this.tank.drain(currentWithdraw, true);
                    this.lastOutput = this.field_145850_b.func_82737_E();
                }
            }
        }
        if (this.field_145850_b.func_82737_E() - this.lastOutput < 30L && !this.isActive()) {
            this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockMachineBase.ACTIVE, (Comparable)Boolean.valueOf(true)));
        } else if (this.field_145850_b.func_82737_E() - this.lastOutput > 30L && this.isActive()) {
            this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockMachineBase.ACTIVE, (Comparable)Boolean.valueOf(false)));
        }
    }

    public int getProgressScaled(int scale) {
        return this.isActive() ? this.ticksSinceLastChange * scale : 0;
    }

    protected boolean tryAddingEnergy(int amount) {
        if (this.getMaxPower() - this.getEnergy() >= (double)amount) {
            this.addEnergy(amount);
            return true;
        }
        if (this.getMaxPower() - this.getEnergy() > 0.0) {
            this.addEnergy(this.getMaxPower() - this.getEnergy());
            return true;
        }
        return false;
    }

    protected boolean acceptFluid() {
        FluidStack stack;
        if (!this.func_70301_a(0).func_190926_b() && (stack = FluidUtils.getFluidStackInContainer((ItemStack)this.func_70301_a(0))) != null) {
            return this.recipes.getRecipeForFluid(stack.getFluid()).isPresent();
        }
        return false;
    }

    public FluidGeneratorRecipeList getRecipes() {
        return this.recipes;
    }

    public double getBaseMaxOutput() {
        return this.euTick;
    }

    public double getBaseMaxInput() {
        return 0.0;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return false;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return true;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.tank.readFromNBT(tagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.tank.writeToNBT(tagCompound);
        return tagCompound;
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public int getTicksSinceLastChange() {
        return this.ticksSinceLastChange;
    }

    public void setTicksSinceLastChange(int ticksSinceLastChange) {
        this.ticksSinceLastChange = ticksSinceLastChange;
    }

    public int getTankAmount() {
        return this.tank.getFluidAmount();
    }

    public void setTankAmount(int amount) {
        this.tank.setFluidAmount(amount);
    }

    @Nullable
    public Tank getTank() {
        return this.tank;
    }
}

