/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.cable;

import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergyTile;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import reborncore.api.IListInfoProvider;
import reborncore.api.IToolDrop;
import reborncore.common.RebornCoreConfig;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.util.StringUtils;
import techreborn.blocks.cable.BlockCable;
import techreborn.blocks.cable.EnumCableType;
import techreborn.tiles.cable.ICable;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergyConductor", modid="ic2"), @Optional.Interface(iface="techreborn.tiles.cable.ICable", modid="ic2"), @Optional.Interface(iface="net.minecraft.util.ITickable", modid="ic2")})
public class TileCableEU
extends TileEntity
implements ITickable,
IListInfoProvider,
IToolDrop,
IEnergyConductor,
ICable {
    private int transferRate = 0;
    private EnumCableType cableType = null;
    protected boolean addedToEnet = false;
    protected boolean checkedConnections = false;
    private byte connectivity = 0;

    public TileCableEU() {
    }

    public TileCableEU(EnumCableType cableType) {
        this.cableType = cableType;
        this.transferRate = cableType.transferRate * RebornCoreConfig.euPerFU;
    }

    private void updateCableType() {
        if (this.cableType == null) {
            this.cableType = (EnumCableType)((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockCable.TYPE));
            this.transferRate = this.cableType.transferRate * RebornCoreConfig.euPerFU;
        }
    }

    @Optional.Method(modid="ic2")
    public void func_145843_s() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.addedToEnet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnet = false;
        }
        super.func_145843_s();
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.notifyBlockUpdate();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.connectivity = compound.func_74771_c("connectivity");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74774_a("connectivity", this.connectivity);
        return compound;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_189515_b(nbtTag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        this.notifyBlockUpdate();
    }

    private void notifyBlockUpdate() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
    }

    @Override
    @Optional.Method(modid="ic2")
    public void onNeighborChanged(Block neighbor, BlockPos neighborPos) {
        if (!this.field_145850_b.field_72995_K) {
            this.updateConnectivity();
        }
    }

    @Override
    @Optional.Method(modid="ic2")
    public void updateConnectivity() {
        World world = this.func_145831_w();
        byte newConnectivity = 0;
        int mask = 1;
        for (EnumFacing facing : EnumFacing.values()) {
            IEnergyTile energyTile = EnergyNet.instance.getTile(world, this.field_174879_c.func_177972_a(facing));
            if (energyTile != null) {
                newConnectivity = (byte)(newConnectivity | mask);
            }
            mask *= 2;
        }
        if (this.connectivity != newConnectivity) {
            this.connectivity = newConnectivity;
            this.func_70296_d();
        }
    }

    @Override
    @Optional.Method(modid="ic2")
    public byte getConnectivity() {
        return this.connectivity;
    }

    @Optional.Method(modid="ic2")
    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.cableType == null) {
            this.updateCableType();
        }
        if (!this.addedToEnet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnet = true;
        }
        if (!this.checkedConnections) {
            this.updateConnectivity();
            this.checkedConnections = true;
        }
    }

    public void addInfo(List<String> info, boolean isRealTile) {
        info.add(TextFormatting.GRAY + StringUtils.t((String)"techreborn.tooltip.transferRate") + ": " + TextFormatting.GOLD + PowerSystem.getLocaliszedPowerFormatted((int)(this.transferRate / RebornCoreConfig.euPerFU)) + "/t");
        info.add(TextFormatting.GRAY + StringUtils.t((String)"techreborn.tooltip.tier") + ": " + TextFormatting.GOLD + StringUtils.toFirstCapitalAllLowercase((String)this.cableType.tier.toString()));
    }

    public ItemStack getToolDrop(EntityPlayer playerIn) {
        return this.cableType.getStack();
    }

    @Optional.Method(modid="ic2")
    public double getConductionLoss() {
        return this.cableType.euCableLoss;
    }

    @Optional.Method(modid="ic2")
    public double getInsulationEnergyAbsorption() {
        switch (this.cableType) {
            case TIN: {
                return 3.0;
            }
            case COPPER: 
            case GOLD: 
            case HV: {
                return 0.0;
            }
            case ICOPPER: 
            case IGOLD: 
            case IHV: 
            case GLASSFIBER: 
            case SUPERCONDUCTOR: {
                return 2.147483647E9;
            }
        }
        return 2.147483647E9;
    }

    @Optional.Method(modid="ic2")
    public double getInsulationBreakdownEnergy() {
        return 9001.0;
    }

    @Optional.Method(modid="ic2")
    public double getConductorBreakdownEnergy() {
        return this.cableType.transferRate + 1;
    }

    @Optional.Method(modid="ic2")
    public void removeInsulation() {
    }

    @Optional.Method(modid="ic2")
    public void removeConductor() {
        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187658_bx, SoundCategory.BLOCKS, 0.5f, 2.6f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.8f);
        for (int l = 0; l < 8; ++l) {
            Minecraft.func_71410_x().field_71441_e.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)this.field_174879_c.func_177958_n() + Math.random(), (double)this.field_174879_c.func_177956_o() + 1.2, (double)this.field_174879_c.func_177952_p() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
        }
        this.field_145850_b.func_175698_g(this.field_174879_c);
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter iEnergyEmitter, EnumFacing enumFacing) {
        return true;
    }

    @Optional.Method(modid="ic2")
    public boolean emitsEnergyTo(IEnergyAcceptor iEnergyAcceptor, EnumFacing enumFacing) {
        return true;
    }
}

