/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.armor;

import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.common.powerSystem.ExternalPowerSystems;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.PoweredItemContainerProvider;
import reborncore.common.powerSystem.forge.ForgePowerItemManager;
import reborncore.common.util.ItemUtils;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModItems;
import techreborn.utils.TechRebornCreativeTab;

public class ItemLithiumBatpack
extends ItemArmor
implements IEnergyItemInfo {
    public static final int maxCharge = ConfigTechReborn.LithiumBatpackCharge;
    public double transferLimit = 10000.0;

    public ItemLithiumBatpack() {
        super(ItemArmor.ArmorMaterial.DIAMOND, 7, EntityEquipmentSlot.CHEST);
        this.func_77625_d(1);
        this.func_77655_b("techreborn.lithiumbatpack");
        this.func_77637_a(TechRebornCreativeTab.instance);
    }

    public static void distributePowerToInventory(World world, EntityPlayer player, ItemStack itemStack, int maxSend) {
        if (world.field_72995_K) {
            return;
        }
        ForgePowerItemManager capEnergy = new ForgePowerItemManager(itemStack);
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            if (player.field_71071_by.func_70301_a(i).func_190926_b()) continue;
            ExternalPowerSystems.chargeItem((ForgePowerItemManager)capEnergy, (ItemStack)player.field_71071_by.func_70301_a(i));
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        ItemLithiumBatpack.distributePowerToInventory(world, player, itemStack, (int)this.transferLimit);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ItemUtils.getPowerForDurabilityBar((ItemStack)stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return PowerSystem.getDisplayPower().colour;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new PoweredItemContainerProvider(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "techreborn:textures/models/lithiumbatpack.png";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> itemList) {
        if (!this.func_194125_a(par2CreativeTabs)) {
            return;
        }
        ItemStack uncharged = new ItemStack(ModItems.LITHIUM_BATTERY_PACK);
        ItemStack charged = new ItemStack(ModItems.LITHIUM_BATTERY_PACK);
        ForgePowerItemManager capEnergy = new ForgePowerItemManager(charged);
        capEnergy.setEnergyStored(capEnergy.getMaxEnergyStored());
        itemList.add((Object)uncharged);
        itemList.add((Object)charged);
    }

    public double getMaxPower(ItemStack stack) {
        return maxCharge;
    }

    public boolean canAcceptEnergy(ItemStack stack) {
        return true;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    public double getMaxTransfer(ItemStack stack) {
        return this.transferLimit;
    }
}

