/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks.cable;

import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import reborncore.api.power.EnumPowerTier;
import reborncore.common.registration.impl.ConfigRegistryFactory;
import techreborn.init.ModBlocks;

public enum EnumCableType implements IStringSerializable
{
    COPPER("copper", "techreborn:blocks/cables/copper_cable", 128, 12.0, true, EnumPowerTier.MEDIUM, (double)0.2f),
    TIN("tin", "techreborn:blocks/cables/tin_cable", 32, 12.0, true, EnumPowerTier.LOW, (double)0.2f),
    GOLD("gold", "techreborn:blocks/cables/gold_cable", 512, 12.0, true, EnumPowerTier.HIGH, (double)0.4f),
    HV("hv", "techreborn:blocks/cables/hv_cable", 2048, 12.0, true, EnumPowerTier.EXTREME, (double)0.8f),
    GLASSFIBER("glassfiber", "techreborn:blocks/cables/glass_fiber_cable", 8192, 12.0, false, EnumPowerTier.INSANE, (double)0.025f),
    ICOPPER("insulatedcopper", "techreborn:blocks/cables/copper_insulated_cable", 128, 10.0, false, EnumPowerTier.MEDIUM, (double)0.2f),
    IGOLD("insulatedgold", "techreborn:blocks/cables/gold_insulated_cable", 512, 10.0, false, EnumPowerTier.HIGH, (double)0.4f),
    IHV("insulatedhv", "techreborn:blocks/cables/hv_insulated_cable", 2048, 10.0, false, EnumPowerTier.EXTREME, (double)0.8f),
    SUPERCONDUCTOR("superconductor", "techreborn:blocks/cables/superconductor_cable", 0x1FFFFFFF, 10.0, false, EnumPowerTier.INFINITE, 0.0);

    public String textureName = "minecraft:blocks/iron_block";
    public int transferRate = 128;
    public int defaultTransferRate = 128;
    public double cableThickness = 3.0;
    public boolean canKill = false;
    public boolean defaultCanKill = false;
    public EnumPowerTier tier;
    public double euCableLoss;
    private String friendlyName;

    private EnumCableType(String friendlyName, String textureName, int transferRate, double cableThickness, boolean canKill, EnumPowerTier tier, double euCableLoss) {
        this.friendlyName = friendlyName;
        this.textureName = textureName;
        this.transferRate = transferRate;
        this.defaultTransferRate = transferRate;
        this.cableThickness = cableThickness / 2.0;
        this.canKill = canKill;
        this.defaultCanKill = canKill;
        this.tier = tier;
        this.euCableLoss = euCableLoss;
    }

    public String func_176610_l() {
        return this.friendlyName.toLowerCase();
    }

    public ItemStack getStack() {
        return new ItemStack(ModBlocks.CABLE, 1, this.ordinal());
    }

    public ItemStack getStack(int amount) {
        return new ItemStack(ModBlocks.CABLE, amount, this.ordinal());
    }

    @SubscribeEvent
    public static void handleConfig(ConfigRegistryFactory.RebornRegistryEvent event) {
        Configuration config = event.getConfiguration("techreborn", "misc");
        for (EnumCableType cableType : EnumCableType.values()) {
            cableType.transferRate = config.getInt(cableType.friendlyName + "_transfer_rate", "cable", cableType.defaultTransferRate, 0, Integer.MAX_VALUE, "Cable transfer rate");
            cableType.canKill = config.getBoolean(cableType.friendlyName + "_do_damage", "cable", cableType.defaultCanKill, "Set to true to allow cable to do damge to enties that come in contact with it");
        }
    }
}

