/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.module;

import com.google.common.collect.Lists;
import com.valkyrieofnight.vlib.core.IModInfo;
import com.valkyrieofnight.vlib.core.io.json.config.JsonConfig;
import com.valkyrieofnight.vlib.core.network.PacketDispatcher;
import com.valkyrieofnight.vlib.module.IFeature3;
import com.valkyrieofnight.vlib.module.config.IConfig;
import com.valkyrieofnight.vlib.module.config.PropMapWrapper;
import com.valkyrieofnight.vlib.module.interfaces.IClientInit;
import com.valkyrieofnight.vlib.module.interfaces.IClientInitPost;
import com.valkyrieofnight.vlib.module.interfaces.IClientInitPre;
import com.valkyrieofnight.vlib.module.interfaces.ICommonInit;
import com.valkyrieofnight.vlib.module.interfaces.ICommonInitPost;
import com.valkyrieofnight.vlib.module.interfaces.ICommonInitPre;
import com.valkyrieofnight.vlib.module.interfaces.IEventRegisterBlocks;
import com.valkyrieofnight.vlib.module.interfaces.IEventRegisterItems;
import com.valkyrieofnight.vlib.module.interfaces.IEventRegisterModels;
import com.valkyrieofnight.vlib.module.interfaces.IFeatureNeedsConfig;
import com.valkyrieofnight.vlib.module.interfaces.IFeatureNeedsParent;
import com.valkyrieofnight.vlib.module.interfaces.INetworkRegisterPacket;
import com.valkyrieofnight.vlib.module.interfaces.IServerInit;
import com.valkyrieofnight.vlib.module.interfaces.IServerInitPost;
import com.valkyrieofnight.vlib.module.interfaces.IServerInitPre;
import com.valkyrieofnight.vlib.module.interfaces.IServerStarting;
import java.io.File;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class VLModule3 {
    private final String id;
    private boolean enabled;
    private VLModule3 parent;
    private IModInfo namespace;
    private JsonConfig config;
    private IConfig iConfig;
    private File configLocation;
    private List<VLModule3> children = Lists.newArrayList();
    private List<IFeature3> features = Lists.newArrayList();
    private boolean initialized = false;

    public VLModule3(String id) {
        this.id = id;
    }

    public final void moduleSetup() {
        this.setup();
        for (VLModule3 mod : this.children) {
            mod.moduleSetup();
        }
    }

    public final void moduleInitPre() {
        this.enabled = this.canDisable() ? this.iConfig.getBoolean("enabled", this.isEnabledByDefualt(), "valkyrielib.module.enabled") : true;
        this.moduleInitPre(this.iConfig);
        for (VLModule3 vlModule3 : this.children) {
            vlModule3.moduleInitPre();
        }
        for (IFeature3 fet : this.features) {
            fet.initFeature(fet.getConfig(this.iConfig));
        }
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public abstract boolean isEnabledByDefualt();

    public boolean canDisable() {
        return true;
    }

    protected abstract void setup();

    protected abstract void moduleInitPre(IConfig var1);

    public final void setModInfo(IModInfo namespace) {
        this.namespace = namespace;
    }

    public final IModInfo getNamespace() {
        return this.namespace;
    }

    public final String getID() {
        return this.id;
    }

    public final IConfig getConfig() {
        return this.iConfig;
    }

    protected final void setParentIfNone(VLModule3 module) {
        if (this.parent == null) {
            this.parent = module;
        }
    }

    protected final boolean hasParent() {
        return this.parent != null;
    }

    public final void addChild(VLModule3 module) {
        if (this.initialized || module == null) {
            return;
        }
        if (module.hasParent()) {
            return;
        }
        this.children.add(module);
        module.setParentIfNone(this);
        module.setModInfo(this.namespace);
    }

    public IConfig getGlobalConfig() {
        if (this.parent == null) {
            return this.iConfig;
        }
        return this.parent.getGlobalConfig();
    }

    public final void addFeature(IFeature3 feature) {
        if (feature == null) {
            return;
        }
        if (feature instanceof IFeatureNeedsParent) {
            ((IFeatureNeedsParent)((Object)feature)).provideParent(this);
        }
        this.features.add(feature);
    }

    public final String getLocation() {
        if (this.parent != null) {
            return this.parent.getLocation() + this.id + "/";
        }
        return this.id + "/";
    }

    protected final void loadConfigs(String baseDirectory, IConfig parentConfig) {
        String str = baseDirectory + this.getLocation() + this.getID() + ".json";
        this.configLocation = new File(str);
        this.config = new JsonConfig(str);
        this.config.setId(this.id);
        if (this.configLocation.exists()) {
            this.config.loadConfig();
        }
        this.iConfig = new PropMapWrapper(this.config);
        for (IFeature3 ft : this.features) {
            if (!(ft instanceof IFeatureNeedsConfig)) continue;
            ((IFeatureNeedsConfig)((Object)ft)).loadConfig(this.iConfig);
        }
        for (VLModule3 vlModule3 : this.children) {
            vlModule3.loadConfigs(baseDirectory, this.iConfig);
        }
    }

    protected final void saveConfigs() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.config != null) {
            List<String> data = this.config.dumpData();
            for (String string : data) {
            }
            this.config.saveConfig();
        }
        for (VLModule3 vlModule3 : this.children) {
            vlModule3.saveConfigs();
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected final void saveDocumentation() {
        if (this.getGlobalConfig().getBoolean("generate_documentation", true, "valkyrielib.documentation.version")) {
            this.config.saveDocumentation();
        }
        for (VLModule3 vlModule3 : this.children) {
            vlModule3.saveDocumentation();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final void clientInitPre(FMLPreInitializationEvent event) {
        if (this instanceof IClientInitPre) {
            ((IClientInitPre)((Object)this)).clientInitPre(event, this.iConfig);
        }
        for (IFeature3 ft : this.features) {
            if (!ft.isEnabled() || !(ft instanceof IClientInitPre)) continue;
            ((IClientInitPre)((Object)ft)).clientInitPre(event, ft.getConfig(this.iConfig));
        }
        for (VLModule3 vlm : this.children) {
            if (!vlm.isEnabled()) continue;
            vlm.clientInitPre(event);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final void clientInit(FMLInitializationEvent event) {
        if (this instanceof IClientInit) {
            ((IClientInit)((Object)this)).clientInit(event, this.iConfig);
        }
        for (IFeature3 ft : this.features) {
            if (!ft.isEnabled() || !(ft instanceof IClientInit)) continue;
            ((IClientInit)((Object)ft)).clientInit(event, ft.getConfig(this.iConfig));
        }
        for (VLModule3 vlm : this.children) {
            if (!vlm.isEnabled()) continue;
            vlm.clientInit(event);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final void clientInitPost(FMLPostInitializationEvent event) {
        if (this instanceof IClientInitPost) {
            ((IClientInitPost)((Object)this)).clientInitPost(event, this.iConfig);
        }
        for (IFeature3 ft : this.features) {
            if (!ft.isEnabled() || !(ft instanceof IClientInitPost)) continue;
            ((IClientInitPost)((Object)ft)).clientInitPost(event, ft.getConfig(this.iConfig));
        }
        for (VLModule3 vlm : this.children) {
            if (!vlm.isEnabled()) continue;
            vlm.clientInitPost(event);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final void registerEventModels(ModelRegistryEvent event) {
        if (this instanceof IEventRegisterModels) {
            ((IEventRegisterModels)((Object)this)).registerEventModels(event, this.iConfig);
        }
        for (IFeature3 ft : this.features) {
            if (!ft.isEnabled() || !(ft instanceof IEventRegisterModels)) continue;
            ((IEventRegisterModels)((Object)ft)).registerEventModels(event, ft.getConfig(this.iConfig));
        }
        for (VLModule3 vlm : this.children) {
            if (!vlm.isEnabled()) continue;
            vlm.registerEventModels(event);
        }
    }

    public final void commonInitPre(FMLPreInitializationEvent event) {
        this.initialized = true;
        if (this instanceof ICommonInitPre) {
            ((ICommonInitPre)((Object)this)).commonInitPre(event, this.iConfig);
        }
        for (IFeature3 ft : this.features) {
            if (!ft.isEnabled() || !(ft instanceof ICommonInitPre)) continue;
            ((ICommonInitPre)((Object)ft)).commonInitPre(event, ft.getConfig(this.iConfig));
        }
        for (VLModule3 vlm : this.children) {
            if (!vlm.isEnabled()) continue;
            vlm.commonInitPre(event);
        }
    }

    public final void commonInit(FMLInitializationEvent event) {
        if (this instanceof ICommonInit) {
            ((ICommonInit)((Object)this)).commonInit(event, this.iConfig);
        }
        for (IFeature3 ft : this.features) {
            if (!ft.isEnabled() || !(ft instanceof ICommonInit)) continue;
            ((ICommonInit)((Object)ft)).commonInit(event, ft.getConfig(this.iConfig));
        }
        for (VLModule3 vlm : this.children) {
            if (!vlm.isEnabled()) continue;
            vlm.commonInit(event);
        }
    }

    public final void commonInitPost(FMLPostInitializationEvent event) {
        if (this instanceof ICommonInitPost) {
            ((ICommonInitPost)((Object)this)).commonInitPost(event, this.iConfig);
        }
        for (IFeature3 ft : this.features) {
            if (!ft.isEnabled() || !(ft instanceof ICommonInitPost)) continue;
            ((ICommonInitPost)((Object)ft)).commonInitPost(event, ft.getConfig(this.iConfig));
        }
        for (VLModule3 vlm : this.children) {
            if (!vlm.isEnabled()) continue;
            vlm.commonInitPost(event);
        }
    }

    public final void registerEventBlocks(RegistryEvent.Register<Block> event) {
        if (this instanceof IEventRegisterBlocks) {
            ((IEventRegisterBlocks)((Object)this)).registerEventBlocks(event, this.iConfig);
        }
        for (IFeature3 ft : this.features) {
            if (!ft.isEnabled() || !(ft instanceof IEventRegisterBlocks)) continue;
            ((IEventRegisterBlocks)((Object)ft)).registerEventBlocks(event, ft.getConfig(this.iConfig));
        }
        for (VLModule3 vlm : this.children) {
            if (!vlm.isEnabled()) continue;
            vlm.registerEventBlocks(event);
        }
    }

    public final void registerEventItems(RegistryEvent.Register<Item> event) {
        if (this instanceof IEventRegisterItems) {
            ((IEventRegisterItems)((Object)this)).registerEventItems(event, this.iConfig);
        }
        for (IFeature3 ft : this.features) {
            if (!ft.isEnabled() || !(ft instanceof IEventRegisterItems)) continue;
            ((IEventRegisterItems)((Object)ft)).registerEventItems(event, ft.getConfig(this.iConfig));
        }
        for (VLModule3 vlm : this.children) {
            if (!vlm.isEnabled()) continue;
            vlm.registerEventItems(event);
        }
    }

    @SideOnly(value=Side.SERVER)
    public final void serverInitPre(FMLPreInitializationEvent event) {
        if (this instanceof IServerInitPre) {
            ((IServerInitPre)((Object)this)).serverInitPre(event, this.iConfig);
        }
        for (IFeature3 ft : this.features) {
            if (!ft.isEnabled() || !(ft instanceof IServerInitPre)) continue;
            ((IServerInitPre)((Object)ft)).serverInitPre(event, ft.getConfig(this.iConfig));
        }
        for (VLModule3 vlm : this.children) {
            if (!vlm.isEnabled()) continue;
            vlm.serverInitPre(event);
        }
    }

    @SideOnly(value=Side.SERVER)
    public final void serverInit(FMLInitializationEvent event) {
        if (this instanceof IServerInit) {
            ((IServerInit)((Object)this)).serverInit(event, this.iConfig);
        }
        for (IFeature3 ft : this.features) {
            if (!ft.isEnabled() || !(ft instanceof IServerInit)) continue;
            ((IServerInit)((Object)ft)).serverInit(event, ft.getConfig(this.iConfig));
        }
        for (VLModule3 vlm : this.children) {
            if (!vlm.isEnabled()) continue;
            vlm.serverInit(event);
        }
    }

    @SideOnly(value=Side.SERVER)
    public final void serverInitPost(FMLPostInitializationEvent event) {
        if (this instanceof IServerInitPost) {
            ((IServerInitPost)((Object)this)).serverInitPost(event, this.iConfig);
        }
        for (IFeature3 ft : this.features) {
            if (!ft.isEnabled() || !(ft instanceof IServerInitPost)) continue;
            ((IServerInitPost)((Object)ft)).serverInitPost(event, ft.getConfig(this.iConfig));
        }
        for (VLModule3 vlm : this.children) {
            if (!vlm.isEnabled()) continue;
            vlm.serverInitPost(event);
        }
    }

    public final void serverStarting(FMLServerStartingEvent event) {
        if (this instanceof IServerStarting) {
            ((IServerStarting)((Object)this)).serverStarting(event, this.iConfig);
        }
        for (IFeature3 ft : this.features) {
            if (!ft.isEnabled() || !(ft instanceof IServerStarting)) continue;
            ((IServerStarting)((Object)ft)).serverStarting(event, ft.getConfig(this.iConfig));
        }
        for (VLModule3 vlm : this.children) {
            if (!vlm.isEnabled()) continue;
            vlm.serverStarting(event);
        }
    }

    public final void registerPackets(PacketDispatcher dispatcher) {
        if (this instanceof INetworkRegisterPacket) {
            ((INetworkRegisterPacket)((Object)this)).registerPackets(dispatcher, this.iConfig);
        }
        for (IFeature3 ft : this.features) {
            if (!ft.isEnabled() || !(ft instanceof INetworkRegisterPacket)) continue;
            ((INetworkRegisterPacket)((Object)ft)).registerPackets(dispatcher, ft.getConfig(this.iConfig));
        }
        for (VLModule3 vlm : this.children) {
            if (!vlm.isEnabled()) continue;
            vlm.registerPackets(dispatcher);
        }
    }
}

