/*
 * Decompiled with CFR 0.152.
 */
package magicbees.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import magicbees.api.module.IConfigRegistry;
import magicbees.api.module.IConfiguration;
import net.minecraftforge.common.config.Configuration;

public final class ConfigHandler
implements IConfigRegistry {
    private final Configuration config;
    private final Set<IConfiguration> configs;
    private final Map<String, String> categoryComments;
    private boolean reloadBlocked;
    private boolean lock;

    public ConfigHandler(Configuration config) {
        this.config = (Configuration)Preconditions.checkNotNull((Object)config);
        this.configs = Sets.newHashSet();
        this.categoryComments = Maps.newHashMap();
        this.reloadBlocked = false;
        this.lock = false;
    }

    @Override
    public void registerConfig(IConfiguration config) {
        if (this.lock) {
            return;
        }
        this.reloadBlocked = true;
        if (this.configs.add(config)) {
            config.init(this);
        }
        this.reloadBlocked = false;
    }

    @Override
    public void registerCategoryComment(String category, String comment) {
        if (this.lock) {
            throw new IllegalStateException("Config comments have to be registered in config init!");
        }
        if (this.categoryComments.containsKey(category)) {
            throw new IllegalArgumentException("Comment for category " + category + " has already been registered.");
        }
        this.categoryComments.put(category, comment);
    }

    public void reload() {
        if (this.reloadBlocked) {
            return;
        }
        if (!this.lock) {
            this.lock = true;
        }
        this.config.load();
        for (Map.Entry<String, String> entry : this.categoryComments.entrySet()) {
            this.config.addCustomCategoryComment(entry.getKey(), entry.getValue());
        }
        for (IConfiguration c : this.configs) {
            c.reload(this.config);
        }
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }
}

