/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees;

import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpeciesBuilder;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IAlleleEffect;
import forestry.api.genetics.IEffectData;
import magicbees.bees.EnumBeeSpecies;
import magicbees.elec332.corerepack.compat.forestry.EffectData;
import magicbees.elec332.corerepack.compat.forestry.ForestryAlleles;
import magicbees.elec332.corerepack.compat.forestry.allele.AlleleEffectThrottled;
import magicbees.elec332.corerepack.compat.forestry.allele.AlleleFlowerProvider;
import magicbees.elec332.corerepack.compat.forestry.bee.BeeGenomeTemplate;
import magicbees.util.MagicBeesResourceLocation;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public final class BeeIntegrationInterface {
    public static final ResourceLocation bot_flowers_name = new MagicBeesResourceLocation("flowersBotania");
    public static final ResourceLocation bot_dreaming_name = new MagicBeesResourceLocation("effectDreaming");
    public static final ResourceLocation te_spawnBlizz_name = new MagicBeesResourceLocation("spawnBlizz");
    public static final ResourceLocation te_spawnBlitz_name = new MagicBeesResourceLocation("spawnBlitz");
    public static final ResourceLocation te_spawnBasalz_name = new MagicBeesResourceLocation("spawnBasalz");
    public static AlleleFlowerProvider flowersBotania;
    public static IAlleleEffect effectDreaming;
    public static IAlleleEffect effectSpawnBlizz;
    public static IAlleleEffect effectSpawnBlitz;
    public static IAlleleEffect effectSpawnBasalz;
    public static IBlockState blockRSAFluxedElectrum;
    public static ItemStack itemRSAFluxedElectrumNugget;
    public static IBlockState livingWood;
    public static IBlockState aeSkyStone;
    public static Item itemPetal;
    public static Item itemPastureSeed;
    public static Item itemManaResource;
    public static int seedTypes;

    public static void getTemplateTE(BeeGenomeTemplate template) {
        BeeGenomeTemplate ret = new BeeGenomeTemplate();
        ret.setHumidityTolerance(ForestryAlleles.TOLERANCE_BOTH_2);
        ret.setTemperatureTolerance(ForestryAlleles.TOLERANCE_BOTH_2);
        ret.setToleratesRain(ForestryAlleles.TRUE_RECESSIVE);
        ret.setSpeed(ForestryAlleles.SPEED_FAST);
        ret.setFertility(ForestryAlleles.FERTILITY_HIGH);
        ret.setLifeSpan(ForestryAlleles.LIFESPAN_LONGER);
        for (int i = 1; i < ret.getAlleles().length; ++i) {
            template.getAlleles()[i] = ret.getAlleles()[i];
        }
    }

    public static void getTemplateTENether(BeeGenomeTemplate template) {
        BeeIntegrationInterface.getTemplateTE(template);
        template.setHumidityTolerance(ForestryAlleles.TOLERANCE_NONE);
        template.setTemperatureTolerance(ForestryAlleles.TOLERANCE_NONE);
        template.setCaveDwelling(ForestryAlleles.TRUE_RECESSIVE);
        template.setSpeed(ForestryAlleles.SPEED_SLOW);
        template.setFertility(ForestryAlleles.FERTILITY_NORMAL);
        template.setFlowerProvider(ForestryAlleles.FLOWERS_NETHER);
        template.setEffect((IAlleleEffect)EnumBeeSpecies.getForestryAllele("effectIgnition"));
        template.setNeverSleeps(ForestryAlleles.TRUE_RECESSIVE);
    }

    public static void getTemplateTEEnd(BeeGenomeTemplate template) {
        BeeIntegrationInterface.getTemplateTE(template);
        template.setNeverSleeps(ForestryAlleles.TRUE_RECESSIVE);
        template.setCaveDwelling(ForestryAlleles.TRUE_RECESSIVE);
        template.setSpeed(ForestryAlleles.SPEED_FASTEST);
        template.setLifeSpan(ForestryAlleles.LIFESPAN_LONGEST);
    }

    public static void addPetals(IAlleleBeeSpeciesBuilder species, float chance) {
        if (itemPetal == null) {
            return;
        }
        for (int i = 0; i < EnumDyeColor.values().length; ++i) {
            species.addSpecialty(new ItemStack(itemPetal, 1, i), Float.valueOf(chance));
        }
    }

    private BeeIntegrationInterface() {
        throw new RuntimeException();
    }

    private static IAlleleBeeEffect getPlaceholderEffect(ResourceLocation name) {
        return new AlleleEffectThrottled(name){

            @Override
            public IEffectData doEffectThrottled(IBeeGenome beeGenome, IEffectData effectData, IBeeHousing beeHousing) {
                return effectData;
            }

            @Override
            public IEffectData validateStorage(IEffectData effectData) {
                if (effectData == null) {
                    return new EffectData(1, 0, 0);
                }
                return effectData;
            }
        };
    }

    static {
        Item nullItem = Items.field_151162_bE;
        IBlockState nullBlock = Blocks.field_150327_N.func_176223_P();
        flowersBotania = new AlleleFlowerProvider(bot_flowers_name, ForestryAlleles.FLOWERS_VANILLA.getProvider());
        effectDreaming = BeeIntegrationInterface.getPlaceholderEffect(bot_dreaming_name);
        effectSpawnBlizz = BeeIntegrationInterface.getPlaceholderEffect(te_spawnBlizz_name);
        effectSpawnBlitz = BeeIntegrationInterface.getPlaceholderEffect(te_spawnBlitz_name);
        effectSpawnBasalz = BeeIntegrationInterface.getPlaceholderEffect(te_spawnBasalz_name);
        livingWood = aeSkyStone = nullBlock;
        blockRSAFluxedElectrum = aeSkyStone;
        itemPastureSeed = itemManaResource = nullItem;
        itemPetal = itemManaResource;
        itemRSAFluxedElectrumNugget = new ItemStack(nullItem);
    }
}

