/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.items;

import blusunrize.immersiveengineering.client.ClientUtils;
import com.google.common.collect.HashMultiset;
import flaxbeard.immersivepetroleum.common.IPContent;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.WorldSavedData;

public class ItemSampleMap
extends ItemMap {
    public static ItemStack setupNewMap(World worldIn, double worldX, double worldZ, byte scale, boolean trackingPosition, boolean unlimitedTracking) {
        ItemStack itemstack = new ItemStack(IPContent.itemProjector, 1, worldIn.func_72841_b("map"));
        String s = "map_" + itemstack.func_77960_j();
        MapData mapdata = new MapData(s);
        worldIn.func_72823_a(s, (WorldSavedData)mapdata);
        mapdata.field_76197_d = scale;
        mapdata.func_176054_a(worldX, worldZ, (int)mapdata.field_76197_d);
        mapdata.field_76200_c = worldIn.field_73011_w.getDimension();
        mapdata.field_186210_e = trackingPosition;
        mapdata.field_191096_f = unlimitedTracking;
        mapdata.func_76185_a();
        return itemstack;
    }

    public ItemSampleMap(String name) {
        this.func_77655_b("immersivepetroleum." + name);
        IPContent.registeredIPItems.add((Item)this);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
    }

    public void func_77872_a(World worldIn, Entity viewer, MapData data) {
        if (worldIn.field_73011_w.getDimension() == data.field_76200_c && viewer instanceof EntityPlayer) {
            int scaleFactor = 1 << data.field_76197_d;
            int xCenter = data.field_76201_a;
            int zCenter = data.field_76199_b;
            int relPlayerX = MathHelper.func_76128_c((double)(viewer.field_70165_t - (double)xCenter)) / scaleFactor + 64;
            int relPlayerY = MathHelper.func_76128_c((double)(viewer.field_70161_v - (double)zCenter)) / scaleFactor + 64;
            int size = 128 / scaleFactor;
            if (worldIn.field_73011_w.func_177495_o()) {
                size /= 2;
            }
            MapData.MapInfo mapInfo = data.func_82568_a((EntityPlayer)viewer);
            ++mapInfo.field_82569_d;
            boolean flag = false;
            for (int x = relPlayerX - size + 1; x < relPlayerX + size; ++x) {
                if ((x & 0xF) != (mapInfo.field_82569_d & 0xF) && !flag) continue;
                flag = false;
                double d0 = 0.0;
                for (int y = relPlayerY - size - 1; y < relPlayerY + size; ++y) {
                    if (x < 0 || y < -1 || x >= 128 || y >= 128) continue;
                    int relX = x - relPlayerX;
                    int relY = y - relPlayerY;
                    boolean flag1 = relX * relX + relY * relY > (size - 2) * (size - 2);
                    int absX = (xCenter / scaleFactor + x - 64) * scaleFactor;
                    int absY = (zCenter / scaleFactor + y - 64) * scaleFactor;
                    HashMultiset multiset = HashMultiset.create();
                    Chunk chunk = worldIn.func_175726_f(new BlockPos(absX, 0, absY));
                    if (chunk.func_76621_g()) continue;
                    int chunkCornerX = absX & 0xF;
                    int chunkCornerY = absY & 0xF;
                    boolean k3 = false;
                    double d1 = 0.0;
                    if (y < 0 || relX * relX + relY * relY >= size * size || flag1 && (x + y & 1) == 0) continue;
                    byte b0 = data.field_76198_e[x + y * 128];
                    TextureAtlasSprite textureStone = ClientUtils.getSprite((ResourceLocation)new ResourceLocation("blocks/stone"));
                    int[][] texture = textureStone.func_147965_a(0);
                    int xIndex = (relX + size) % 5;
                    int yIndex = (relY + size) % 256;
                    if (texture.length == 0 || texture[0].length == 0) continue;
                    System.out.println(Integer.toHexString(texture[0][0]));
                    byte b1 = (byte)texture[0][0];
                    if (b0 == b1) continue;
                    data.field_76198_e[x + y * 128] = b1;
                    data.func_176053_a(x, y);
                    flag = true;
                }
            }
        }
    }
}

