/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.netmonitor;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import mcjty.lib.thirteen.Context;
import mcjty.rftools.items.netmonitor.GuiNetworkMonitor;
import mcjty.rftools.varia.BlockInfo;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketConnectedBlocksReady
implements IMessage {
    private int minx;
    private int miny;
    private int minz;
    private Map<BlockPos, BlockInfo> blockInfoMap;

    public void fromBytes(ByteBuf buf) {
        this.minx = buf.readInt();
        this.miny = buf.readInt();
        this.minz = buf.readInt();
        int size = buf.readInt();
        this.blockInfoMap = new HashMap<BlockPos, BlockInfo>();
        for (int i = 0; i < size; ++i) {
            BlockPos coordinate = new BlockPos(buf.readShort() + this.minx, buf.readShort() + this.miny, buf.readShort() + this.minz);
            BlockInfo blockInfo = new BlockInfo(coordinate, buf.readLong(), buf.readLong());
            this.blockInfoMap.put(coordinate, blockInfo);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.minx);
        buf.writeInt(this.miny);
        buf.writeInt(this.minz);
        buf.writeInt(this.blockInfoMap.size());
        for (Map.Entry<BlockPos, BlockInfo> me : this.blockInfoMap.entrySet()) {
            BlockPos c = me.getKey();
            buf.writeShort(c.func_177958_n() - this.minx);
            buf.writeShort(c.func_177956_o() - this.miny);
            buf.writeShort(c.func_177952_p() - this.minz);
            buf.writeLong(me.getValue().getStoredPower());
            buf.writeLong(me.getValue().getCapacity());
        }
    }

    public PacketConnectedBlocksReady() {
    }

    public PacketConnectedBlocksReady(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketConnectedBlocksReady(Map<BlockPos, BlockInfo> blockInfoMap, int minx, int miny, int minz) {
        this.blockInfoMap = new HashMap<BlockPos, BlockInfo>(blockInfoMap);
        this.minx = minx;
        this.miny = miny;
        this.minz = minz;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> GuiNetworkMonitor.setServerConnectedBlocks(this.blockInfoMap));
        ctx.setPacketHandled(true);
    }
}

