/*
 * Decompiled with CFR 0.152.
 */
package extracells.models.blocks;

import extracells.block.BlockCertusTank;
import extracells.models.BlankModel;
import extracells.models.ModelManager;
import extracells.models.blocks.ModelTankFluid;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelCertusTank
extends BlankModel {
    public static IBakedModel emptyTank;
    public static IBakedModel emptyTankAbove;
    public static IBakedModel emptyTankBelow;
    public static IBakedModel emptyTankMiddle;
    public static ModelTankFluid fluid;

    public static void onBakeModels(ModelBakeEvent event) {
        IRegistry registry = event.getModelRegistry();
        ResourceLocation location = new ResourceLocation("extracells", "certustank");
        emptyTank = (IBakedModel)registry.func_82594_a((Object)new ModelResourceLocation(location, "above=false,below=false,empty=true"));
        emptyTankAbove = (IBakedModel)registry.func_82594_a((Object)new ModelResourceLocation(location, "above=true,below=false,empty=true"));
        emptyTankBelow = (IBakedModel)registry.func_82594_a((Object)new ModelResourceLocation(location, "above=false,below=true,empty=true"));
        emptyTankMiddle = (IBakedModel)registry.func_82594_a((Object)new ModelResourceLocation(location, "above=true,below=true,empty=true"));
        ModelCertusTank model = new ModelCertusTank();
        registry.func_82595_a((Object)new ModelResourceLocation(location, "above=false,below=false,empty=false"), (Object)model);
        registry.func_82595_a((Object)new ModelResourceLocation(location, "above=true,below=false,empty=false"), (Object)model);
        registry.func_82595_a((Object)new ModelResourceLocation(location, "above=false,below=true,empty=false"), (Object)model);
        registry.func_82595_a((Object)new ModelResourceLocation(location, "above=true,below=true,empty=false"), (Object)model);
        registry.func_82595_a((Object)new ModelResourceLocation(location, "inventory"), (Object)model);
        ModelTankFluid.blockModels.invalidateAll();
        ModelTankFluid.itemModels.invalidateAll();
    }

    @Override
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (layer == BlockRenderLayer.TRANSLUCENT) {
            quads.addAll(fluid.func_188616_a(state, side, rand));
        } else {
            IBakedModel model = emptyTank;
            boolean below = (Boolean)state.func_177229_b((IProperty)BlockCertusTank.TANK_BELOW);
            boolean above = (Boolean)state.func_177229_b((IProperty)BlockCertusTank.TANK_ABOVE);
            if (above && !below) {
                model = emptyTankAbove;
            } else if (!above && below) {
                model = emptyTankBelow;
            } else if (above && below) {
                model = emptyTankMiddle;
            }
            quads.addAll(model.func_188616_a(state, side, rand));
        }
        return quads;
    }

    @Override
    public TextureAtlasSprite func_177554_e() {
        return emptyTank.func_177554_e();
    }

    @Override
    protected ItemOverrideList createOverrides() {
        return new TankOverrides();
    }

    static {
        fluid = new ModelTankFluid();
    }

    public static class TankOverrides
    extends ItemOverrideList {
        public TankOverrides() {
            super(Collections.emptyList());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack);
            return new PerspectiveMapWrapper((IBakedModel)new ItemModel(fluidStack), ModelManager.getDefaultBlockState());
        }
    }

    private static class ItemModel
    extends BlankModel {
        FluidStack stack;

        public ItemModel(FluidStack fluidStack) {
            this.stack = fluidStack;
        }

        @Override
        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            quads.addAll(emptyTank.func_188616_a(state, side, rand));
            if (this.stack != null) {
                quads.addAll(fluid.getQuads(this.stack));
            }
            return quads;
        }
    }
}

