/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.world.tools;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import org.dave.compactmachines3.init.Blockss;
import org.dave.compactmachines3.schema.BlockInformation;
import org.dave.compactmachines3.schema.Schema;
import org.dave.compactmachines3.tile.TileEntityMachine;
import org.dave.compactmachines3.utility.Logz;
import org.dave.compactmachines3.world.WorldSavedDataMachines;
import org.dave.compactmachines3.world.tools.DimensionTools;

public class StructureTools {
    public static int getCoordsForPos(BlockPos pos) {
        return StructureTools.getCoordsForPos(pos.func_177958_n());
    }

    public static int getCoordsForPos(int x) {
        return x >> 10;
    }

    public static EnumFacing getNextDirection(EnumFacing in) {
        switch (in) {
            case DOWN: {
                return EnumFacing.UP;
            }
            case UP: {
                return EnumFacing.NORTH;
            }
            case NORTH: {
                return EnumFacing.SOUTH;
            }
            case SOUTH: {
                return EnumFacing.WEST;
            }
            case WEST: {
                return EnumFacing.EAST;
            }
            case EAST: {
                return null;
            }
        }
        return null;
    }

    public static void setBiomeForCoords(int coords, Biome biome) {
        WorldServer machineWorld = DimensionTools.getServerMachineWorld();
        Chunk chunk = machineWorld.func_72964_e(coords << 10 >> 4, 0);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                chunk.func_76605_m()[z << 4 | x] = (byte)Biome.func_185362_a((Biome)biome);
            }
        }
    }

    public static void generateCubeForMachine(TileEntityMachine machine) {
        if (machine.coords != -1) {
            return;
        }
        machine.coords = WorldSavedDataMachines.reserveMachineId();
        Logz.info("Reserved id %d for machine", machine.coords);
        machine.func_70296_d();
        StructureTools.generateCube(machine);
    }

    private static void generateCube(TileEntityMachine machine) {
        int size = machine.getSize().getDimension();
        int startX = machine.coords * 1024 + size;
        int startY = 40 + size;
        int startZ = size;
        WorldServer machineWorld = DimensionTools.getServerMachineWorld();
        IBlockState state = Blockss.wall.func_176223_P();
        IBlockState barrier = Blocks.field_180401_cv.func_176223_P();
        StructureTools.generateCube((World)machineWorld, new BlockPos(startX, startY, startZ), size, state);
        StructureTools.generateCube((World)machineWorld, new BlockPos(startX + 1, startY + 1, startZ + 1), size + 2, barrier);
        StructureTools.generateCube((World)machineWorld, new BlockPos(startX + 2, startY + 2, startZ + 2), size + 4, barrier);
        StructureTools.generateCube((World)machineWorld, new BlockPos(startX + 3, startY + 3, startZ + 3), size + 6, barrier);
    }

    public static void generateCube(World world, BlockPos cornerPos, int size, IBlockState state) {
        for (BlockPos pos : StructureTools.getCubePositions(cornerPos, size + 1, size + 1, size + 1, true)) {
            world.func_175656_a(pos, state);
        }
    }

    public static EnumFacing getInsetWallFacing(BlockPos wallPos, int size) {
        int x = wallPos.func_177958_n() % 1024;
        int y = wallPos.func_177956_o();
        int z = wallPos.func_177952_p();
        if (y == 40) {
            return EnumFacing.UP;
        }
        if (y == 40 + size) {
            return EnumFacing.DOWN;
        }
        if (x == 0) {
            return EnumFacing.EAST;
        }
        if (x == 0 + size) {
            return EnumFacing.WEST;
        }
        if (z == 0) {
            return EnumFacing.SOUTH;
        }
        return EnumFacing.NORTH;
    }

    public static List<BlockPos> getCubePositions(BlockPos cornerPos, int width, int height, int depth, boolean includeFloor) {
        int minX = Math.min(cornerPos.func_177958_n(), cornerPos.func_177958_n() - (width - 1));
        int minY = Math.min(cornerPos.func_177956_o(), cornerPos.func_177956_o() - (height - 1));
        int minZ = Math.min(cornerPos.func_177952_p(), cornerPos.func_177952_p() - (depth - 1));
        int maxX = Math.max(cornerPos.func_177958_n(), cornerPos.func_177958_n() - (width - 1));
        int maxY = Math.max(cornerPos.func_177956_o(), cornerPos.func_177956_o() - (height - 1));
        int maxZ = Math.max(cornerPos.func_177952_p(), cornerPos.func_177952_p() - (depth - 1));
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (x != minX && z != minZ && x != maxX && y != maxY && z != maxZ && y != minY || !includeFloor && y == minY) continue;
                    BlockPos pos = new BlockPos(x, y, z);
                    list.add(pos);
                }
            }
        }
        return list;
    }

    public static List<BlockInformation> createNewSchema(int coords) {
        TileEntity machine = WorldSavedDataMachines.INSTANCE.getMachinePosition(coords).getTileEntity();
        if (machine != null && machine instanceof TileEntityMachine) {
            return StructureTools.createNewSchema((TileEntityMachine)machine);
        }
        return null;
    }

    public static List<BlockInformation> createNewSchema(TileEntityMachine machine) {
        ArrayList<BlockInformation> blockList = new ArrayList<BlockInformation>();
        WorldServer machineWorld = DimensionTools.getServerMachineWorld();
        int size = machine.getSize().getDimension();
        int startX = machine.coords * 1024 + size;
        int startY = 40 + size;
        int startZ = size;
        for (int x = 1; x <= size - 1; ++x) {
            for (int y = 1; y <= size - 1; ++y) {
                for (int z = 1; z <= size - 1; ++z) {
                    BlockPos absolutePos = new BlockPos(startX - x, startY - y, startZ - z);
                    BlockPos relativePos = new BlockPos(x - 1, y - 1, z - 1);
                    if (machineWorld.func_175623_d(absolutePos)) continue;
                    IBlockState state = machineWorld.func_180495_p(absolutePos);
                    Block block = state.func_177230_c();
                    NBTTagCompound nbt = null;
                    boolean writePositionData = false;
                    if (block.hasTileEntity(state)) {
                        boolean storedZ;
                        TileEntity te = machineWorld.func_175625_s(absolutePos);
                        nbt = new NBTTagCompound();
                        te.func_189515_b(nbt);
                        boolean storedX = nbt.func_74764_b("x") && nbt.func_74762_e("x") == absolutePos.func_177958_n();
                        boolean storedY = nbt.func_74764_b("y") && nbt.func_74762_e("y") == absolutePos.func_177956_o();
                        boolean bl = storedZ = nbt.func_74764_b("z") && nbt.func_74762_e("z") == absolutePos.func_177952_p();
                        if (storedX && storedY && storedZ) {
                            writePositionData = true;
                        }
                    }
                    blockList.add(new BlockInformation(relativePos, block, block.func_176201_c(state), nbt, writePositionData));
                }
            }
        }
        return blockList;
    }

    public static void restoreSchema(Schema schema, int coords) {
        List<BlockInformation> blockList = schema.getBlocks();
        TileEntity te = WorldSavedDataMachines.INSTANCE.getMachinePosition(coords).getTileEntity();
        if (te != null && te instanceof TileEntityMachine) {
            WorldServer machineWorld = DimensionTools.getServerMachineWorld();
            TileEntityMachine machine = (TileEntityMachine)te;
            int size = machine.getSize().getDimension();
            int startX = machine.coords * 1024 + size - 1;
            int startY = 40 + size - 1;
            int startZ = 0 + size - 1;
            for (BlockInformation bi : blockList) {
                BlockPos absolutePos = new BlockPos(startX - bi.position.func_177958_n(), startY - bi.position.func_177956_o(), startZ - bi.position.func_177952_p());
                IBlockState state = bi.block.func_176203_a(bi.meta);
                machineWorld.func_175656_a(absolutePos, state);
                if (bi.nbt == null) continue;
                TileEntity restoredTe = machineWorld.func_175625_s(absolutePos);
                if (restoredTe == null) {
                    restoredTe = bi.block.createTileEntity((World)machineWorld, state);
                }
                if (bi.writePositionData) {
                    bi.nbt.func_74768_a("x", absolutePos.func_177958_n());
                    bi.nbt.func_74768_a("y", absolutePos.func_177956_o());
                    bi.nbt.func_74768_a("z", absolutePos.func_177952_p());
                }
                restoredTe.func_145839_a(bi.nbt);
                restoredTe.func_70296_d();
            }
        }
    }
}

