/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.skyworld;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.dave.compactmachines3.init.Itemss;
import org.dave.compactmachines3.init.Triggerss;
import org.dave.compactmachines3.skyworld.SkyChunkGenerator;
import org.dave.compactmachines3.skyworld.SkyWorldSavedData;
import org.dave.compactmachines3.skyworld.SkyWorldType;
import org.dave.compactmachines3.utility.Logz;
import org.dave.compactmachines3.utility.ShrinkingDeviceUtils;
import org.dave.compactmachines3.world.tools.TeleportationTools;

public class SkyWorldEvents {
    private static Set<UUID> alreadyTriggered = new HashSet<UUID>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        World world = event.player.field_70170_p;
        if (world.field_72995_K || !(world instanceof WorldServer)) {
            return;
        }
        if (event.player.func_175149_v()) {
            return;
        }
        if (world.func_175624_G() instanceof SkyWorldType && !alreadyTriggered.contains(event.player.func_110124_au())) {
            Triggerss.IS_SKYWORLD.trigger((EntityPlayerMP)event.player);
            alreadyTriggered.add(event.player.func_110124_au());
        }
        WorldServer worldServer = (WorldServer)world;
        if (!(worldServer.func_72863_F().field_186029_c instanceof SkyChunkGenerator)) {
            return;
        }
        if (!event.player.func_184812_l_() && (event.player.field_70163_u > 49.0 || event.player.field_70163_u < 39.5)) {
            BlockPos spawnPoint = worldServer.func_175694_M();
            if (SkyWorldSavedData.instance.isHubMachineOwner(event.player)) {
                TeleportationTools.teleportToSkyworldHome(event.player);
            } else {
                event.player.func_70634_a((double)spawnPoint.func_177958_n() + 0.5, (double)spawnPoint.func_177956_o() + 1.0, (double)spawnPoint.func_177952_p() + 0.5);
            }
            return;
        }
        boolean givePSD = ((SkyChunkGenerator)worldServer.func_72863_F().field_186029_c).config.givePSD;
        boolean hasPSD = ShrinkingDeviceUtils.hasShrinkingDeviceInInventory(event.player);
        boolean hasAlreadyReceivedPSD = SkyWorldSavedData.instance.hasReceivedStartingInventory(event.player);
        if (givePSD && !hasPSD && !hasAlreadyReceivedPSD) {
            ItemStack psdStack = new ItemStack((Item)Itemss.psd, 1, 0);
            if (!event.player.func_191521_c(psdStack)) {
                EntityItem entityItem = new EntityItem(world, event.player.field_70165_t, event.player.field_70163_u + (double)event.player.func_70047_e() + 0.5, event.player.field_70161_v, psdStack);
                entityItem.lifespan = 2400;
                entityItem.func_174867_a(10);
                entityItem.field_70159_w = 0.0;
                entityItem.field_70181_x = 0.15f;
                entityItem.field_70179_y = 0.0;
                world.func_72838_d((Entity)entityItem);
            }
            SkyWorldSavedData.instance.addToStartingInventoryReceiverSet(event.player);
        }
    }

    @SubscribeEvent
    public static void createSpawnPoint(WorldEvent.CreateSpawnPosition event) {
        World world = event.getWorld();
        if (world.field_72995_K || !(world instanceof WorldServer)) {
            return;
        }
        WorldServer worldServer = (WorldServer)world;
        if (!(worldServer.func_72863_F().field_186029_c instanceof SkyChunkGenerator)) {
            return;
        }
        float centerPos = 11.5f;
        int heightPos = 43;
        Logz.info("World generator settings are: %s", ((SkyChunkGenerator)worldServer.func_72863_F().field_186029_c).config.getAsJsonString());
        Logz.info("Overriding world spawn point", new Object[0]);
        event.getWorld().func_175652_B(new BlockPos((double)centerPos, (double)heightPos, (double)centerPos));
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void preventPlacingInHub(BlockEvent.PlaceEvent event) {
        World world = event.getWorld();
        if (world.field_72995_K || !(world instanceof WorldServer)) {
            return;
        }
        WorldServer worldServer = (WorldServer)world;
        if (!(worldServer.func_72863_F().field_186029_c instanceof SkyChunkGenerator)) {
            return;
        }
        event.getPlayer().func_146105_b((ITextComponent)new TextComponentTranslation("hint.compactmachines3.skyworld.no_block_placing", new Object[0]), true);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void preventBreakingInHub(BlockEvent.BreakEvent event) {
        World world = event.getWorld();
        if (world.field_72995_K || !(world instanceof WorldServer)) {
            return;
        }
        WorldServer worldServer = (WorldServer)world;
        if (!(worldServer.func_72863_F().field_186029_c instanceof SkyChunkGenerator)) {
            return;
        }
        event.getPlayer().func_146105_b((ITextComponent)new TextComponentTranslation("hint.compactmachines3.skyworld.no_block_breaking", new Object[0]), true);
        event.setCanceled(true);
    }
}

