/*
 * Decompiled with CFR 0.152.
 */
package com.astro.discordsuite;

import com.astro.discordsuite.Client;
import com.astro.discordsuite.Modpack;
import com.astro.discordsuite.UrlUtils;
import com.astro.discordsuite.integration.CurseManifest;
import com.astro.discordsuite.integration.Dimension;
import com.astro.discordsuite.rpc.DiscordRichPresence;
import com.astro.discordsuite.rpc.RichPresenceBuilder;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Util;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import org.apache.commons.io.FileUtils;
import org.lwjgl.opengl.Display;

@Mod(modid="discordsuite", name="DiscordSuite", version="2.2.4", clientSideOnly=true, acceptedMinecraftVersions="*")
public class DiscordSuite {
    public static final String VERSION = "2.2.4";
    public static Client CLIENT;
    public static List<Modpack> PACKS;
    public static Gson GSON;
    public static CurseManifest CURSE_MANIFEST;
    public static int LATEST_VERSION;
    public static boolean update;
    public static boolean available;

    public DiscordSuite() {
        try {
            File file;
            File versionFile = new File("discordsuite/version");
            if (versionFile.exists()) {
                int version = Integer.parseInt(FileUtils.readFileToString((File)versionFile, (Charset)StandardCharsets.UTF_8));
                if (version < LATEST_VERSION) {
                    update = true;
                }
            } else {
                update = true;
            }
            if (Util.func_110647_a() == Util.EnumOS.WINDOWS) {
                try {
                    file = new File("discordsuite/win32-x86-64/discord-rpc.dll");
                    if (update && file.exists()) {
                        file.delete();
                    } else if (!file.exists()) {
                        update = true;
                    }
                    if (file.exists() || update) {
                        try {
                            if (update) {
                                FileUtils.copyURLToFile((URL)new URL("https://github.com/AstroInteractive/DiscordSuite/raw/master/DLL/win32-x86-64/discord-rpc.dll"), (File)file);
                            }
                            System.load(file.getAbsolutePath());
                        }
                        catch (Exception | UnsatisfiedLinkError throwable) {}
                    }
                }
                catch (Exception | UnsatisfiedLinkError e) {
                    File file2 = new File("discordsuite/win32-x86/discord-rpc.dll");
                    if (update && file2.exists()) {
                        file2.delete();
                    } else if (!file2.exists()) {
                        update = true;
                    }
                    try {
                        if (update) {
                            FileUtils.copyURLToFile((URL)new URL("https://github.com/AstroInteractive/DiscordSuite/raw/master/DLL/win32-x86/discord-rpc.dll"), (File)file2);
                        }
                        System.load(file2.getAbsolutePath());
                    }
                    catch (Exception | UnsatisfiedLinkError ignored) {
                        available = false;
                    }
                }
            }
            if (Util.func_110647_a() == Util.EnumOS.LINUX) {
                file = new File("discordsuite/win32-x86-64/discord-rpc.dll");
                if (update && file.exists()) {
                    file.delete();
                } else if (!file.exists()) {
                    update = true;
                }
                try {
                    if (update) {
                        FileUtils.copyURLToFile((URL)new URL("https://github.com/AstroInteractive/DiscordSuite/raw/master/DLL/linux-x86-64/libdiscord-rpc.so"), (File)file);
                    }
                    System.load(file.getAbsolutePath());
                }
                catch (Exception | UnsatisfiedLinkError ignored) {
                    available = false;
                }
            }
            if (Util.func_110647_a() == Util.EnumOS.OSX) {
                file = new File("discordsuite/win32-x86-64/discord-rpc.dll");
                if (update && file.exists()) {
                    file.delete();
                } else if (!file.exists()) {
                    update = true;
                }
                try {
                    if (update) {
                        FileUtils.copyURLToFile((URL)new URL("https://github.com/AstroInteractive/DiscordSuite/raw/master/DLL/darwin/libdiscord-rpc.dylib"), (File)file);
                    }
                    System.load(file.getAbsolutePath());
                }
                catch (Exception | UnsatisfiedLinkError ignored) {
                    available = false;
                }
            }
            if (update && available) {
                FileUtils.writeStringToFile((File)versionFile, (String)String.valueOf(LATEST_VERSION), (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (Exception | UnsatisfiedLinkError e) {
            e.printStackTrace();
        }
    }

    private static DiscordRichPresence buildDimensionPresence(World world) {
        Dimension dimension = Dimension.getDimension(world);
        return DiscordSuite.addDimensionInfo(new RichPresenceBuilder().withState("Playing"), dimension, world).build();
    }

    private static RichPresenceBuilder addDimensionInfo(RichPresenceBuilder builder, Dimension dimension, World world) {
        if (dimension == Dimension.UNKNOWN) {
            builder.withImage(dimension.getImage()).withDetails("In " + world.field_73011_w.func_186058_p().func_186065_b());
        } else {
            builder.withImage(dimension.getImage()).withDetails(dimension.getImage().getText());
        }
        return builder;
    }

    @Mod.EventHandler
    public void construction(FMLConstructionEvent event) {
        if (available) {
            MinecraftForge.EVENT_BUS.register((Object)this);
            try {
                CLIENT = new Client("385036947728367628");
                CLIENT.updateTimestamp();
                CLIENT.init();
                CLIENT.updatePresence(new RichPresenceBuilder().withDetails("Loading the game").build());
                if (CURSE_MANIFEST != null) {
                    Display.setTitle((String)DiscordSuite.CURSE_MANIFEST.name);
                }
            }
            catch (UnsatisfiedLinkError e) {
                available = false;
            }
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (available) {
            CLIENT.updatePresence(new RichPresenceBuilder().withDetails("Loading the game").withState("FMLPreInitialization").build());
        }
    }

    public static ByteBuffer createBuffer(BufferedImage bi) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bi, "png", out);
            return ByteBuffer.wrap(out.toByteArray());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (available) {
            CLIENT.updatePresence(new RichPresenceBuilder().withDetails("Loading the game").withState("FMLInitialization").build());
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (available) {
            CLIENT.updateTimestamp();
            CLIENT.updatePresence(new RichPresenceBuilder().withDetails("In the MainMenu").build());
        }
    }

    @Mod.EventHandler
    public void postInit(FMLServerStoppingEvent event) {
        if (available) {
            CLIENT.updateTimestamp();
            CLIENT.updatePresence(new RichPresenceBuilder().withDetails("In the MainMenu").build());
        }
    }

    @SubscribeEvent
    public void postInit(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        if (available) {
            CLIENT.updateTimestamp();
            CLIENT.updatePresence(new RichPresenceBuilder().withDetails("In the MainMenu").build());
        }
    }

    @SubscribeEvent
    public void worldLoad(EntityJoinWorldEvent event) {
        if (available && event.getEntity() == Minecraft.func_71410_x().field_71439_g) {
            CLIENT.updatePresence(DiscordSuite.buildDimensionPresence(Minecraft.func_71410_x().field_71439_g.func_130014_f_()));
        }
    }

    @SubscribeEvent
    public void dimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (available) {
            CLIENT.updatePresence(DiscordSuite.buildDimensionPresence(event.player.func_130014_f_()));
        }
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
        available = true;
        new Thread(() -> {
            try {
                PACKS = Lists.newArrayList((Object[])((Object[])GSON.fromJson(UrlUtils.getText("https://raw.githubusercontent.com/AstroInteractive/DiscordSuite/master/CursePacks.json"), Modpack[].class)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                LATEST_VERSION = Integer.parseInt(UrlUtils.getText("https://raw.githubusercontent.com/AstroInteractive/DiscordSuite/master/VERSION"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).start();
        try {
            CURSE_MANIFEST = (CurseManifest)GSON.fromJson(FileUtils.readFileToString((File)new File("manifest.json"), (Charset)StandardCharsets.UTF_8), CurseManifest.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

