/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.compactsolars.blocks;

import cpw.mods.compactsolars.CompactSolars;
import cpw.mods.compactsolars.common.CompactSolarType;
import cpw.mods.compactsolars.tileentity.TileEntityCompactSolar;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockCompactSolar
extends BlockContainer {
    public static final PropertyEnum<CompactSolarType> TYPE_PROP = PropertyEnum.func_177709_a((String)"type", CompactSolarType.class);
    private Random random;

    public BlockCompactSolar() {
        super(Material.field_151573_f);
        this.func_149711_c(3.0f);
        this.random = new Random();
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE_PROP, (Comparable)((Object)CompactSolarType.LOW_VOLTAGE)));
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return CompactSolarType.makeEntity(metadata);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_70093_af()) {
            return false;
        }
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof TileEntityCompactSolar) {
            TileEntityCompactSolar tecs = (TileEntityCompactSolar)te;
            playerIn.openGui((Object)CompactSolars.instance, tecs.getType().ordinal(), worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public int func_180651_a(IBlockState state) {
        return CompactSolarType.validateMeta(((CompactSolarType)((Object)state.func_177229_b(TYPE_PROP))).ordinal());
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityCompactSolar tileSolar = (TileEntityCompactSolar)world.func_175625_s(pos);
        if (tileSolar != null) {
            this.dropContent(0, tileSolar, world);
        }
        super.func_180663_b(world, pos, state);
    }

    public void dropContent(int newSize, TileEntityCompactSolar tileSolar, World world) {
        for (int slot = newSize; slot < tileSolar.func_70302_i_(); ++slot) {
            ItemStack itemstack = tileSolar.func_70301_a(slot);
            if (itemstack.func_190926_b()) continue;
            float f = this.random.nextFloat() * 0.8f + 0.1f;
            float f1 = this.random.nextFloat() * 0.8f + 0.1f;
            float f2 = this.random.nextFloat() * 0.8f + 0.1f;
            while (itemstack.func_190916_E() > 0) {
                int i1 = this.random.nextInt(21) + 10;
                if (i1 > itemstack.func_190916_E()) {
                    i1 = itemstack.func_190916_E();
                }
                itemstack.func_190918_g(i1);
                EntityItem entityitem = new EntityItem(world, (double)((float)tileSolar.func_174877_v().func_177958_n() + f), (double)((float)tileSolar.func_174877_v().func_177956_o() + (float)(newSize > 0 ? 1 : 0) + f1), (double)((float)tileSolar.func_174877_v().func_177952_p() + f2), new ItemStack(itemstack.func_77973_b(), i1, itemstack.func_77952_i()));
                float f3 = 0.05f;
                entityitem.field_70159_w = (float)this.random.nextGaussian() * f3;
                entityitem.field_70181_x = (float)this.random.nextGaussian() * f3 + 0.2f;
                entityitem.field_70179_y = (float)this.random.nextGaussian() * f3;
                if (itemstack.func_77942_o()) {
                    entityitem.func_92059_d().func_77982_d(itemstack.func_77978_p().func_74737_b());
                }
                world.func_72838_d((Entity)entityitem);
            }
        }
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (CompactSolarType type : CompactSolarType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, type.ordinal()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE_PROP, (Comparable)((Object)CompactSolarType.values()[meta]));
    }

    public int func_176201_c(IBlockState blockState) {
        return ((CompactSolarType)((Object)blockState.func_177229_b(TYPE_PROP))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE_PROP});
    }
}

