/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.Embers;
import teamroots.embers.RegistryManager;
import teamroots.embers.SoundManager;
import teamroots.embers.api.EmbersAPI;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.event.EmberEvent;
import teamroots.embers.api.itemmod.ItemModUtil;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.UpgradeUtil;
import teamroots.embers.block.BlockInfernoForge;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEmberActivationFX;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.tileentity.IMultiblockMachine;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityInfernoForgeOpening;
import teamroots.embers.util.Misc;
import teamroots.embers.util.sound.ISoundController;

public class TileEntityInfernoForge
extends TileEntity
implements ITileEntityBase,
ITickable,
IMultiblockMachine,
ISoundController {
    public static final double EMBER_COST = 16.0;
    public static final int MAX_LEVEL = 5;
    public static final int PROCESS_TIME = 200;
    public IEmberCapability capability = new DefaultEmberCapability();
    Random random = new Random();
    int progress = 0;
    int heat = 0;
    int ticksExisted = 0;
    public static final int SOUND_PROCESS = 1;
    public static final int[] SOUND_IDS = new int[]{1};
    HashSet<Integer> soundsPlaying = new HashSet();

    public TileEntityInfernoForge() {
        this.capability.setEmberCapacity(32000.0);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.capability.writeToNBT(tag);
        tag.func_74768_a("progress", this.progress);
        tag.func_74768_a("heat", this.heat);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.capability.readFromNBT(tag);
        if (tag.func_74764_b("progress")) {
            this.progress = tag.func_74762_e("progress");
        }
        if (tag.func_74764_b("heat")) {
            this.heat = tag.func_74762_e("heat");
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        ((BlockInfernoForge)state.func_177230_c()).cleanEdges(world, pos);
        world.func_175690_a(pos, null);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            this.handleSound();
        }
        List<IUpgradeProvider> upgrades = UpgradeUtil.getUpgrades(this.field_145850_b, this.field_174879_c, new EnumFacing[]{EnumFacing.DOWN});
        UpgradeUtil.verifyUpgrades(this, upgrades);
        if (UpgradeUtil.doTick(this, upgrades)) {
            return;
        }
        ++this.ticksExisted;
        if (this.progress > 0) {
            boolean cancel = UpgradeUtil.doWork(this, upgrades);
            double emberCost = UpgradeUtil.getTotalEmberConsumption(this, 16.0, upgrades);
            if (!cancel && this.capability.getEmber() >= emberCost) {
                UpgradeUtil.throwEvent(this, new EmberEvent(this, EmberEvent.EnumType.CONSUME, emberCost), upgrades);
                this.capability.removeAmount(emberCost, true);
                --this.progress;
                if (this.func_145831_w().field_72995_K) {
                    if (this.random.nextInt(10) == 0) {
                        if (this.random.nextInt(3) == 0) {
                            ParticleUtil.spawnParticleSpark(this.field_145850_b, (float)this.func_174877_v().func_177958_n() - 0.5f + 0.125f * (this.random.nextFloat() - 0.5f), (float)this.func_174877_v().func_177956_o() + 1.75f, (float)this.func_174877_v().func_177952_p() - 0.5f + 0.125f * (this.random.nextFloat() - 0.5f), 0.125f * (this.random.nextFloat() - 0.5f), 0.125f * this.random.nextFloat(), 0.125f * (this.random.nextFloat() - 0.5f), 255.0f, 64.0f, 16.0f, this.random.nextFloat() * 0.75f + 0.45f, 80);
                        }
                        if (this.random.nextInt(3) == 0) {
                            ParticleUtil.spawnParticleSpark(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + 1.5f + 0.125f * (this.random.nextFloat() - 0.5f), (float)this.func_174877_v().func_177956_o() + 1.75f, (float)this.func_174877_v().func_177952_p() - 0.5f + 0.125f * (this.random.nextFloat() - 0.5f), 0.125f * (this.random.nextFloat() - 0.5f), 0.125f * this.random.nextFloat(), 0.125f * (this.random.nextFloat() - 0.5f), 255.0f, 64.0f, 16.0f, this.random.nextFloat() * 0.75f + 0.45f, 80);
                        }
                        if (this.random.nextInt(3) == 0) {
                            ParticleUtil.spawnParticleSpark(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + 1.5f + 0.125f * (this.random.nextFloat() - 0.5f), (float)this.func_174877_v().func_177956_o() + 1.75f, (float)this.func_174877_v().func_177952_p() + 1.5f + 0.125f * (this.random.nextFloat() - 0.5f), 0.125f * (this.random.nextFloat() - 0.5f), 0.125f * this.random.nextFloat(), 0.125f * (this.random.nextFloat() - 0.5f), 255.0f, 64.0f, 16.0f, this.random.nextFloat() * 0.75f + 0.45f, 80);
                        }
                        if (this.random.nextInt(3) == 0) {
                            ParticleUtil.spawnParticleSpark(this.field_145850_b, (float)this.func_174877_v().func_177958_n() - 0.5f + 0.125f * (this.random.nextFloat() - 0.5f), (float)this.func_174877_v().func_177956_o() + 1.75f, (float)this.func_174877_v().func_177952_p() + 1.5f + 0.125f * (this.random.nextFloat() - 0.5f), 0.125f * (this.random.nextFloat() - 0.5f), 0.125f * this.random.nextFloat(), 0.125f * (this.random.nextFloat() - 0.5f), 255.0f, 64.0f, 16.0f, this.random.nextFloat() * 0.75f + 0.45f, 80);
                        }
                    }
                    ParticleUtil.spawnParticleSmoke(this.func_145831_w(), (float)this.func_174877_v().func_177958_n() - 0.3f, (float)this.func_174877_v().func_177956_o() + 1.85f, (float)this.func_174877_v().func_177952_p() - 0.3f, 0.025f * (this.random.nextFloat() - 0.5f), 0.05f * (this.random.nextFloat() + 1.0f), 0.025f * (this.random.nextFloat() - 0.5f), 72.0f, 72.0f, 72.0f, 1.0f, 3.0f + 3.0f * this.random.nextFloat(), 48);
                    ParticleUtil.spawnParticleSmoke(this.func_145831_w(), (float)this.func_174877_v().func_177958_n() + 1.3f, (float)this.func_174877_v().func_177956_o() + 1.85f, (float)this.func_174877_v().func_177952_p() - 0.3f, 0.025f * (this.random.nextFloat() - 0.5f), 0.05f * (this.random.nextFloat() + 1.0f), 0.025f * (this.random.nextFloat() - 0.5f), 72.0f, 72.0f, 72.0f, 1.0f, 3.0f + 3.0f * this.random.nextFloat(), 48);
                    ParticleUtil.spawnParticleSmoke(this.func_145831_w(), (float)this.func_174877_v().func_177958_n() + 1.3f, (float)this.func_174877_v().func_177956_o() + 1.85f, (float)this.func_174877_v().func_177952_p() + 1.3f, 0.025f * (this.random.nextFloat() - 0.5f), 0.05f * (this.random.nextFloat() + 1.0f), 0.025f * (this.random.nextFloat() - 0.5f), 72.0f, 72.0f, 72.0f, 1.0f, 3.0f + 3.0f * this.random.nextFloat(), 48);
                    ParticleUtil.spawnParticleSmoke(this.func_145831_w(), (float)this.func_174877_v().func_177958_n() - 0.3f, (float)this.func_174877_v().func_177956_o() + 1.85f, (float)this.func_174877_v().func_177952_p() + 1.3f, 0.025f * (this.random.nextFloat() - 0.5f), 0.05f * (this.random.nextFloat() + 1.0f), 0.025f * (this.random.nextFloat() - 0.5f), 72.0f, 72.0f, 72.0f, 1.0f, 3.0f + 3.0f * this.random.nextFloat(), 48);
                }
                List items = this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o() + 0.25, (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1)));
                for (EntityItem e : items) {
                    e.func_174867_a(20);
                }
                if (this.progress == 0 && !this.field_145850_b.field_72995_K) {
                    ItemStack pickedItem = ItemStack.field_190927_a;
                    double emberValue = 0.0;
                    for (EntityItem item : items) {
                        if (ItemModUtil.hasHeat(item.func_92059_d())) {
                            int maxLevel = UpgradeUtil.getOtherParameter((TileEntity)this, "max_level", 5, upgrades);
                            if (pickedItem.func_190926_b() && ItemModUtil.getLevel(item.func_92059_d()) <= maxLevel && ItemModUtil.getHeat(item.func_92059_d()) >= ItemModUtil.getMaxHeat(item.func_92059_d())) {
                                pickedItem = item.func_92059_d();
                                continue;
                            }
                            this.progress = 0;
                            this.func_70296_d();
                            return;
                        }
                        if (EmbersAPI.getEmberValue(item.func_92059_d()) > 0.0) {
                            emberValue += EmbersAPI.getEmberValue(item.func_92059_d());
                            continue;
                        }
                        this.progress = 0;
                        this.func_70296_d();
                        return;
                    }
                    if (!pickedItem.func_190926_b() && emberValue > 0.0) {
                        ItemStack itemStack = new ItemStack(RegistryManager.ember_cluster);
                        if (emberValue <= EmbersAPI.getEmberValue(itemStack) * 3.0) {
                            TileEntityInfernoForgeOpening opening = this.getOpening();
                            if (opening != null) {
                                opening.open();
                            }
                            boolean success = false;
                            for (EntityItem item1 : items) {
                                if (!ItemModUtil.hasHeat(item1.func_92059_d())) {
                                    this.field_145850_b.func_72900_e((Entity)item1);
                                    item1.func_70106_y();
                                    continue;
                                }
                                double chance = UpgradeUtil.getOtherParameter((TileEntity)this, "reforge_chance", Math.atan(emberValue / 1200.0) / 1.5707963267948966, upgrades);
                                if (!(Misc.random.nextDouble() < chance)) continue;
                                ItemStack stack = item1.func_92059_d();
                                ItemModUtil.setHeat(stack, 0.0f);
                                ItemModUtil.setLevel(stack, ItemModUtil.getLevel(stack) + 1);
                                item1.func_92058_a(stack);
                                this.progress = 0;
                                success = true;
                            }
                            if (!this.field_145850_b.field_72995_K) {
                                this.field_145850_b.func_184148_a(null, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.5, (double)this.func_174877_v().func_177952_p() + 0.5, success ? SoundManager.INFERNO_FORGE_SUCCESS : SoundManager.INFERNO_FORGE_FAIL, SoundCategory.BLOCKS, 1.0f, 1.0f);
                                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberActivationFX((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.5, (double)this.func_174877_v().func_177952_p() + 0.5));
                            }
                        }
                    }
                }
            } else {
                this.progress = 0;
            }
            this.func_70296_d();
        }
    }

    private TileEntityInfernoForgeOpening getOpening() {
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
        return tile instanceof TileEntityInfernoForgeOpening ? (TileEntityInfernoForgeOpening)tile : null;
    }

    public void updateProgress() {
        if (this.progress == 0) {
            List items = this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o() + 0.25, (double)this.func_174877_v().func_177952_p(), (double)(this.func_174877_v().func_177958_n() + 1), (double)(this.func_174877_v().func_177956_o() + 1), (double)(this.func_174877_v().func_177952_p() + 1)));
            ItemStack pickedItem = ItemStack.field_190927_a;
            double emberValue = 0.0;
            for (EntityItem item : items) {
                if (ItemModUtil.hasHeat(item.func_92059_d())) {
                    if (pickedItem.func_190926_b() && ItemModUtil.getLevel(item.func_92059_d()) < 5 && ItemModUtil.getHeat(item.func_92059_d()) >= ItemModUtil.getMaxHeat(item.func_92059_d())) {
                        pickedItem = item.func_92059_d();
                        continue;
                    }
                    return;
                }
                if (EmbersAPI.getEmberValue(item.func_92059_d()) > 0.0) {
                    emberValue += EmbersAPI.getEmberValue(item.func_92059_d());
                    continue;
                }
                return;
            }
            if (!pickedItem.func_190926_b() && emberValue > 0.0) {
                ItemStack itemStack = new ItemStack(RegistryManager.ember_cluster);
                if (emberValue < EmbersAPI.getEmberValue(itemStack) * 3.0) {
                    this.progress = 200;
                    this.field_145850_b.func_184148_a(null, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, SoundManager.INFERNO_FORGE_START, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    this.func_70296_d();
                }
            }
        }
    }

    @Override
    public void playSound(int id) {
        switch (id) {
            case 1: {
                Embers.proxy.playMachineSound(this, 1, SoundManager.INFERNO_FORGE_LOOP, SoundCategory.BLOCKS, true, 1.0f, 1.0f, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f);
            }
        }
        this.soundsPlaying.add(id);
    }

    @Override
    public void stopSound(int id) {
        this.soundsPlaying.remove(id);
    }

    @Override
    public boolean isSoundPlaying(int id) {
        return this.soundsPlaying.contains(id);
    }

    @Override
    public int[] getSoundIDs() {
        return SOUND_IDS;
    }

    @Override
    public boolean shouldPlaySound(int id) {
        return id == 1 && this.progress > 0;
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }
}

