/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.item.bauble;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.cap.IBaublesItemHandler;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;
import teamroots.embers.SoundManager;
import teamroots.embers.item.ItemBase;

public class ItemBaubleBase
extends ItemBase
implements IBauble {
    BaubleType type = BaubleType.CHARM;

    public ItemBaubleBase(String name, BaubleType type, boolean addToTab) {
        super(name, addToTab);
        this.type = type;
        this.func_77625_d(1);
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return this.type;
    }

    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundManager.BAUBLE_EQUIP, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
        player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundManager.BAUBLE_UNEQUIP, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ItemStack toEquip = stack.func_77946_l();
        toEquip.func_190920_e(1);
        if (this.canEquip(toEquip, (EntityLivingBase)player)) {
            if (world.field_72995_K) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
            IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int i = 0; i < baubles.getSlots(); ++i) {
                ItemStack stackInSlot;
                if (!baubles.isItemValidForSlot(i, toEquip, (EntityLivingBase)player) || !(stackInSlot = baubles.getStackInSlot(i)).func_190926_b() && !((IBauble)stackInSlot.func_77973_b()).canUnequip(stackInSlot, (EntityLivingBase)player)) continue;
                baubles.setStackInSlot(i, toEquip);
                stack.func_190918_g(1);
                if (!stackInSlot.func_190926_b()) {
                    ((IBauble)stackInSlot.func_77973_b()).onUnequipped(stackInSlot, (EntityLivingBase)player);
                    if (stack.func_190926_b()) {
                        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stackInSlot);
                    }
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stackInSlot);
                }
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }
}

