/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.item;

import java.text.DecimalFormat;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.embers.Embers;
import teamroots.embers.EventManager;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.item.ItemBase;
import teamroots.embers.util.Misc;

public abstract class ItemEmberStorage
extends ItemBase {
    public ItemEmberStorage(String name, boolean addToTab) {
        super(name, addToTab);
    }

    public ItemStack withFill(double ember) {
        ItemStack stack = new ItemStack((Item)this);
        if (stack.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) {
            IEmberCapability capability = (IEmberCapability)stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null);
            capability.setEmber(ember);
        }
        return stack;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            subItems.add((Object)new ItemStack((Item)this));
            subItems.add((Object)this.withFill(this.getCapacity()));
        }
    }

    public abstract double getCapacity();

    public boolean showDurabilityBar(ItemStack stack) {
        IEmberCapability capability;
        return stack.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null) && (capability = (IEmberCapability)stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null)).getEmber() < capability.getEmberCapacity();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) {
            IEmberCapability capability = (IEmberCapability)stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null);
            return (capability.getEmberCapacity() - capability.getEmber()) / capability.getEmberCapacity();
        }
        return 0.0;
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        if (stack.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) {
            IEmberCapability capability = (IEmberCapability)stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null);
            tooltip.add(ItemEmberStorage.formatEmber(capability.getEmber(), capability.getEmberCapacity()));
        }
    }

    public static String formatEmber(double ember, double emberCapacity) {
        DecimalFormat emberFormat = Embers.proxy.getDecimalFormat("embers.decimal_format.ember");
        return I18n.func_135052_a((String)"embers.tooltip.item.ember", (Object[])new Object[]{emberFormat.format(ember), emberFormat.format(emberCapacity)});
    }

    @SideOnly(value=Side.CLIENT)
    public static class ColorHandler
    implements IItemColor {
        public int func_186726_a(@Nonnull ItemStack stack, int tintIndex) {
            if (tintIndex == 1 && stack.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null)) {
                IEmberCapability capability = (IEmberCapability)stack.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null);
                float coeff = (float)(capability.getEmber() / capability.getEmberCapacity());
                float timerSine = ((float)Math.sin(8.0 * Math.toRadians(EventManager.ticks % 360)) + 1.0f) / 2.0f;
                int r = 255;
                int g = (int)(255.0f * (1.0f - coeff) + (64.0f * timerSine + 64.0f) * coeff);
                int b = (int)(255.0f * (1.0f - coeff) + 16.0f * coeff);
                return (r << 16) + (g << 8) + b;
            }
            return Misc.intColor(255, 255, 255);
        }
    }
}

