/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.modintegration.mfr;

import com.buuz135.industrial.api.plant.PlantRecollectable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shetiphian.core.client.Localization;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.block.BlockPlants;
import shetiphian.terraqueous.common.block.BlockTreeFoliageCB;

public class Recollectable {
    @SubscribeEvent
    public void register(RegistryEvent.Register<PlantRecollectable> event) {
        IForgeRegistry registry = event.getRegistry();
        if (Values.blockFlowerSingle != null && Values.blockFlowerCluster != null) {
            registry.register((IForgeRegistryEntry)new Flowers("flowers"));
        }
        if (Values.itemMultiFood != null) {
            if (Values.blockPlants != null) {
                registry.register((IForgeRegistryEntry)new Plants("plants"));
            }
            if (Values.blockTreeFoliageCB != null) {
                registry.register((IForgeRegistryEntry)new BananaStalk("bananastalk"));
            }
        }
    }

    public static class BananaStalk
    extends CommonRecollectable {
        BananaStalk(String name) {
            super(name);
        }

        public boolean canBeHarvested(World world, BlockPos pos, IBlockState state) {
            return this.isStalk(state);
        }

        private boolean isStalk(IBlockState state) {
            Block block = state.func_177230_c();
            if (block instanceof BlockTreeFoliageCB) {
                int meta = block.func_176201_c(state);
                return meta >= 8 && meta <= 11;
            }
            return false;
        }

        @Override
        protected void doHarvestOperation(NonNullList<ItemStack> drops, World world, BlockPos pos, IBlockState state) {
            IBlockState sState;
            Block block = state.func_177230_c();
            int meta = block.func_176201_c(state);
            block.getDrops(drops, (IBlockAccess)world, pos, state, 0);
            Function.removeBlock((World)world, (BlockPos)pos, (boolean)true);
            BlockPos.MutableBlockPos sPos = new BlockPos.MutableBlockPos(pos);
            if (meta != 8) {
                while (sPos.func_177956_o() > 1) {
                    sPos.func_185336_p(sPos.func_177956_o() - 1);
                    sState = world.func_180495_p((BlockPos)sPos);
                    if (!this.isStalk(sState)) break;
                    block.getDrops(drops, (IBlockAccess)world, (BlockPos)sPos, sState, 0);
                    Function.removeBlock((World)world, (BlockPos)sPos, (boolean)true);
                }
            }
            sPos.func_185336_p(pos.func_177956_o());
            while (sPos.func_177956_o() < world.func_72940_L() - 1) {
                sPos.func_185336_p(sPos.func_177956_o() + 1);
                sState = world.func_180495_p((BlockPos)sPos);
                if (!this.isStalk(sState)) break;
                block.getDrops(drops, (IBlockAccess)world, (BlockPos)sPos, sState, 0);
                Function.removeBlock((World)world, (BlockPos)sPos, (boolean)true);
            }
        }

        @Override
        public void getNames(List<String> names) {
            names.add(Localization.get((String)"tile.terraqueous.foliage.banana.stalk.name"));
        }
    }

    public static class Plants
    extends CommonRecollectable {
        Plants(String name) {
            super(name);
        }

        public boolean canBeHarvested(World world, BlockPos pos, IBlockState state) {
            if (state.func_177230_c() instanceof BlockPlants) {
                BlockPlants.EnumType type = BlockPlants.getEnumType(state);
                return type.func_176610_l().endsWith("fruit") || type.func_176610_l().endsWith("stem");
            }
            return false;
        }

        @Override
        public void doHarvestOperation(NonNullList<ItemStack> drops, World world, BlockPos pos, IBlockState state) {
            BlockPlants.EnumType type = BlockPlants.getEnumType(state);
            if (type == BlockPlants.EnumType.CACTUS_FRUIT) {
                drops.add((Object)Values.stacks.get("pricklypear", new int[]{world.field_73012_v.nextInt(2) + 1}));
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state.func_177226_a(BlockPlants.VARIANT, (Comparable)((Object)BlockPlants.EnumType.CACTUS_LARGE)), (boolean)true);
            } else if (type == BlockPlants.EnumType.PINEAPPLE_FRUIT) {
                drops.add((Object)Values.stacks.get("pineapple", new int[0]));
                Function.removeBlock((World)world, (BlockPos)pos, (boolean)true);
            } else if (type.func_176610_l().startsWith("pineapple") && (state = world.func_180495_p(pos = pos.func_177984_a())).func_177230_c() instanceof BlockPlants && BlockPlants.getEnumType(state) == BlockPlants.EnumType.PINEAPPLE_FRUIT) {
                drops.add((Object)Values.stacks.get("pineapple", new int[0]));
                Function.removeBlock((World)world, (BlockPos)pos, (boolean)true);
            }
        }

        @Override
        public void getNames(List<String> names) {
            names.add(Localization.get((String)"tile.terraqueous.plants.pineapple.plant.name"));
            names.add(Localization.get((String)"tile.terraqueous.plants.cactus.name"));
        }
    }

    public static class Flowers
    extends CommonRecollectable {
        Flowers(String name) {
            super(name);
        }

        public boolean canBeHarvested(World world, BlockPos pos, IBlockState state) {
            return state.func_177230_c() == Values.blockFlowerCluster;
        }

        @Override
        public void doHarvestOperation(NonNullList<ItemStack> drops, World world, BlockPos pos, IBlockState state) {
            int flower = state.func_177230_c().func_176201_c(state);
            Function.setBlock((World)world, (BlockPos)pos, (IBlockState)Values.blockFlowerSingle.func_176203_a(flower), (boolean)true);
            drops.add((Object)new ItemStack(Values.blockFlowerSingle, world.field_73012_v.nextInt(2) + 1, flower));
        }

        @Override
        public void getNames(List<String> names) {
            String cluster = Localization.get((String)"tile.terraqueous.flower.group.name");
            for (int damage = 0; damage < 16; damage = (int)((byte)(damage + 1))) {
                String color = EnumDyeColor.func_176766_a((int)damage).func_176762_d();
                names.add(Localization.get((String)("tile.terraqueous.flower." + color + ".name")) + " " + cluster);
            }
        }
    }

    private static abstract class CommonRecollectable
    extends PlantRecollectable {
        CommonRecollectable(String name) {
            super(name);
        }

        public final List<ItemStack> doHarvestOperation(World world, BlockPos pos, IBlockState state) {
            NonNullList drops = NonNullList.func_191196_a();
            this.doHarvestOperation((NonNullList<ItemStack>)drops, world, pos, state);
            return drops;
        }

        protected abstract void doHarvestOperation(NonNullList<ItemStack> var1, World var2, BlockPos var3, IBlockState var4);

        public final boolean shouldCheckNextPlant(World world, BlockPos pos, IBlockState state) {
            return true;
        }

        public final List<String> getRecollectablesNames() {
            ArrayList<String> names = new ArrayList<String>();
            this.getNames(names);
            return names;
        }

        protected abstract void getNames(List<String> var1);

        public final PlantRecollectable.Type getRecollectableType() {
            return PlantRecollectable.Type.PLANT;
        }
    }
}

