/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.worldgen.GenBase;

public class GenPlants
extends GenBase {
    private static List<Integer> allPlants = Arrays.asList(0, 1, 2, 3, 4, 5);

    @Override
    public void generate(Random random, World world, BlockPos pos, ChunkPos chunkPos) {
        if (Values.blockPlants == null || !Configuration.GENERATOR.generatePlants) {
            return;
        }
        Configuration.Menu_Generator.SubMenu_Plants config = Configuration.GENERATOR.PLANTS;
        int value = random.nextInt(100);
        if (this.ignoreBiome && value >= config.chunkChance) {
            return;
        }
        List<Integer> plants = this.getPlantsForBiome(world.func_175726_f(pos = this.getRandomXZ(random, pos)).func_177411_a(pos, world.func_72959_q()), value);
        if (!plants.isEmpty()) {
            pos = this.getTopBlock(world, pos);
            int plantMeta = plants.get(random.nextInt(plants.size()));
            BlockPos gPos = pos.func_177977_b();
            IBlockState gState = world.func_180495_p(gPos);
            Block gBlock = gState.func_177230_c();
            if (plantMeta >= 0 && plantMeta <= 2 && gBlock.canSustainPlant(gState, (IBlockAccess)world, gPos, EnumFacing.UP, (IPlantable)Blocks.field_150345_g)) {
                if (!this.canGenerateType(world, chunkPos, random, DecorateBiomeEvent.Decorate.EventType.PUMPKIN)) {
                    return;
                }
                if (plantMeta == 2) {
                    Function.setBlock((World)world, (BlockPos)pos, (IBlockState)Values.blockPlants.func_176203_a(plantMeta - 1), (boolean)false);
                    Function.setBlock((World)world, (BlockPos)pos.func_177984_a(), (IBlockState)Values.blockPlants.func_176203_a(plantMeta), (boolean)false);
                } else {
                    Function.setBlock((World)world, (BlockPos)pos, (IBlockState)Values.blockPlants.func_176203_a(plantMeta), (boolean)false);
                }
            }
            if (plantMeta >= 3 && plantMeta <= 6 && gBlock.canSustainPlant(gState, (IBlockAccess)world, gPos, EnumFacing.UP, (IPlantable)Blocks.field_150434_aF)) {
                if (!this.canGenerateType(world, chunkPos, random, DecorateBiomeEvent.Decorate.EventType.CACTUS)) {
                    return;
                }
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)Values.blockPlants.func_176203_a(plantMeta), (boolean)false);
            }
        }
    }

    private List<Integer> getPlantsForBiome(Biome biome, int value) {
        if (this.ignoreBiome) {
            return allPlants;
        }
        Configuration.Menu_Generator.SubMenu_Plants config = Configuration.GENERATOR.PLANTS;
        ArrayList<Integer> plantList = new ArrayList<Integer>();
        if (BiomeDictionary.hasAnyType((Biome)biome)) {
            if (config.generatePlant_Pineapple && value < config.chunkChance_Pineapple && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
                plantList.add(0);
                plantList.add(1);
                plantList.add(2);
            }
            if (config.generatePlant_CactusPear && value < config.chunkChance_CactusPear && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SANDY)) {
                plantList.add(3);
                plantList.add(4);
                plantList.add(5);
            }
        }
        return plantList;
    }
}

