/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.wrapper.InvWrapper;
import shetiphian.core.common.Function;
import shetiphian.core.common.inventory.ISidedWrapper;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.api.machines.CapabilityStormForge;
import shetiphian.terraqueous.api.machines.IStormForgeRechargeHandler;
import shetiphian.terraqueous.api.machines.IStormForgeRepairHandler;
import shetiphian.terraqueous.api.machines.IStormForgeStackHandler;
import shetiphian.terraqueous.api.machines.StormForgeRegistry;
import shetiphian.terraqueous.common.inventory.InventoryStormForge;
import shetiphian.terraqueous.common.misc.StormForgeHelper;
import shetiphian.terraqueous.common.tileentity.TileEntityAutoCrafting;

public class TileEntitySFController
extends TileEntityAutoCrafting.WithExp {
    public short delayTime;
    private boolean isWorking;
    public float renderRotation;

    public TileEntitySFController() {
        this.inventory = new InventoryStormForge((TileEntity)this);
        InventoryStormForge inv = (InventoryStormForge)this.inventory;
        this.sidedWrapper = new ISidedWrapper.SidedWrapper(-1, new InvWrapper[]{inv.getWrapper()});
        this.sidedWrapper.setFaceIndex(EnumFacing.NORTH, 0);
        this.sidedWrapper.setFaceIndex(EnumFacing.SOUTH, 0);
        this.sidedWrapper.setFaceIndex(EnumFacing.WEST, 0);
        this.sidedWrapper.setFaceIndex(EnumFacing.EAST, 0);
    }

    protected boolean saveFacing() {
        return false;
    }

    @Override
    protected void buildNBT(NBTTagCompound nbtTag) {
        super.buildNBT(nbtTag);
        nbtTag.func_74777_a("delayTime", this.delayTime);
        nbtTag.func_74757_a("isWorking", this.isWorking);
    }

    @Override
    protected void processNBT(NBTTagCompound nbtTag) {
        super.processNBT(nbtTag);
        this.delayTime = nbtTag.func_74765_d("delayTime");
        this.isWorking = nbtTag.func_74767_n("isWorking");
    }

    @Override
    public boolean rotateBlock(EnumFacing axis) {
        return false;
    }

    public void func_73660_a() {
        ItemStack processStack;
        Block block;
        int lightningChance;
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        boolean canBlockSeeSky = this.func_145831_w().func_175710_j(this.func_174877_v().func_177984_a());
        boolean wasStruck = false;
        boolean instantComplete = false;
        if (canBlockSeeSky && this.func_145831_w().func_72911_I() && this.func_145831_w().field_73012_v.nextInt(lightningChance = (int)(200.0f - this.func_145831_w().func_72819_i(1.0f) * 100.0f)) == 0) {
            wasStruck = true;
            this.func_145831_w().func_72942_c((Entity)new EntityLightningBolt(this.func_145831_w(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), false));
            if (this.func_145831_w().field_73012_v.nextInt(lightningChance * 2) == 0) {
                instantComplete = true;
            }
            StormForgeHelper.moveFire(this.func_145831_w(), this.func_174877_v());
        }
        if ((block = this.func_145831_w().func_180495_p(this.func_174877_v().func_177984_a()).func_177230_c()) == Blocks.field_150480_ab || block instanceof BlockFire) {
            Function.removeBlock((World)this.func_145831_w(), (BlockPos)this.func_174877_v().func_177984_a(), (boolean)true);
        }
        if ((processStack = this.inventory.func_70301_a(6)).func_190926_b()) {
            this.getNextItem(true);
        } else {
            boolean moveToOutput;
            boolean bl = moveToOutput = !this.isWorking;
            if (this.isWorking) {
                if (this.isSFStack(6)) {
                    this.delayTime = (short)(this.delayTime + 1);
                    IStormForgeStackHandler handler = this.getStackHandler(processStack);
                    if (handler != null) {
                        this.inventory.func_70299_a(6, handler.processStack(processStack, this.delayTime, wasStruck, this.func_145831_w(), this.func_174877_v()));
                        moveToOutput = handler.isFinished(processStack, this.delayTime, wasStruck, this.func_145831_w(), this.func_174877_v());
                    } else {
                        moveToOutput = true;
                    }
                    if (moveToOutput) {
                        this.delayTime = 0;
                    }
                } else {
                    boolean processed = false;
                    for (IStormForgeRechargeHandler iStormForgeRechargeHandler : StormForgeRegistry.getRechargeHandlers()) {
                        if (!iStormForgeRechargeHandler.handleStack(processStack)) continue;
                        processed = true;
                        boolean used = iStormForgeRechargeHandler.charge(processStack, this.getPower(iStormForgeRechargeHandler.multiplier(), wasStruck, !canBlockSeeSky), instantComplete);
                        moveToOutput = !used || iStormForgeRechargeHandler.isFull(processStack);
                        break;
                    }
                    if (!canBlockSeeSky && this.func_145831_w().field_73012_v.nextInt(10) < 4) {
                        return;
                    }
                    this.delayTime = (short)(this.delayTime + this.getValue(1, wasStruck, false));
                    if (!processed) {
                        for (IStormForgeRepairHandler iStormForgeRepairHandler : StormForgeRegistry.getRepairHandlers()) {
                            if (!iStormForgeRepairHandler.handleStack(processStack)) continue;
                            processed = true;
                            if (iStormForgeRepairHandler.isRepaired(processStack)) {
                                this.delayTime = 0;
                                moveToOutput = true;
                                break;
                            }
                            if (this.delayTime < Configuration.TWEAKS.STORMFORGE.sfTicksPerRepairPoint && !instantComplete) break;
                            this.delayTime = 0;
                            iStormForgeRepairHandler.repair(processStack, instantComplete);
                            if (wasStruck && !instantComplete) {
                                iStormForgeRepairHandler.repair(processStack, false);
                            }
                            moveToOutput = iStormForgeRepairHandler.isRepaired(processStack);
                            break;
                        }
                    }
                    if (!processed && this.isSmeltable(6)) {
                        processed = true;
                        if (this.delayTime >= Configuration.TWEAKS.STORMFORGE.sfTicksToSmelt || instantComplete) {
                            this.delayTime = 0;
                            ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(processStack);
                            if (!result.func_190926_b()) {
                                this.addExpForItem(result);
                                this.inventory.func_70299_a(6, result.func_77946_l());
                            }
                        }
                    }
                    if (!processed) {
                        moveToOutput = true;
                    }
                }
            }
            if (moveToOutput) {
                this.isWorking = false;
                processStack = this.inventory.func_70301_a(6);
                byte outputSlot = this.getOutputSlot(processStack, true);
                if (outputSlot > -1) {
                    ItemStack outputSlotStack = this.inventory.func_70301_a((int)outputSlot);
                    if (!outputSlotStack.func_190926_b()) {
                        outputSlotStack.func_190917_f(!processStack.func_190926_b() ? processStack.func_190916_E() : 1);
                    } else {
                        this.inventory.func_70299_a((int)outputSlot, processStack);
                    }
                    this.inventory.func_70299_a(6, ItemStack.field_190927_a);
                    this.getNextItem(false);
                    Function.syncTile((TileEntity)this);
                }
            }
        }
    }

    private void getNextItem(boolean syncOnMove) {
        for (int slot = 0; slot < 6; slot = (int)((byte)(slot + 1))) {
            ItemStack stackInSlot = this.inventory.func_70301_a(slot);
            if (stackInSlot.func_190926_b() || this.getOutputSlot(stackInSlot, false) <= -1) continue;
            this.inventory.func_70299_a(6, stackInSlot.func_77979_a(1));
            this.isWorking = true;
            if (stackInSlot.func_190926_b()) {
                this.inventory.func_70299_a(slot, ItemStack.field_190927_a);
            }
            this.delayTime = 0;
            if (syncOnMove) {
                Function.syncTile((TileEntity)this);
            }
            return;
        }
    }

    private double getPower(double multiplier, boolean wasStruck, boolean doReduction) {
        int base = this.getValue(Configuration.TWEAKS.STORMFORGE.sfPowerPerTickBase, wasStruck, doReduction);
        return (double)base * multiplier;
    }

    private int getValue(int base, boolean wasStruck, boolean doReduction) {
        float value = (float)base + (0.5f * (float)base * this.func_145831_w().func_72867_j(1.0f) + 0.75f * (float)base * this.func_145831_w().func_72819_i(1.0f) * 3.0f);
        return MathHelper.func_76123_f((float)(value *= (wasStruck ? 2.0f : 1.0f) * (doReduction ? 0.25f : 1.0f)));
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 3), (double)(this.func_174877_v().func_177956_o() - 1), (double)(this.func_174877_v().func_177952_p() - 3), (double)(this.func_174877_v().func_177958_n() + 4), (double)(this.func_174877_v().func_177956_o() + 4), (double)(this.func_174877_v().func_177952_p() + 4));
    }

    public void dropItems() {
        for (ItemStack itemStack : this.inventory.getContents()) {
            if (itemStack == null) continue;
            Function.dropItem((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (ItemStack)itemStack);
        }
        this.dropExp();
    }

    private byte getOutputSlot(ItemStack item, boolean currentItem) {
        ItemStack smelted;
        if (item == null) {
            return -1;
        }
        if (!currentItem && !(smelted = FurnaceRecipes.func_77602_a().func_151395_a(item)).func_190926_b()) {
            item = smelted.func_77946_l();
        }
        boolean useFreeSlot = !item.func_77985_e();
        for (int pass = 0; pass < 2; pass = (int)((byte)(pass + 1))) {
            for (byte slot = 7; slot < 13; slot = (byte)(slot + 1)) {
                int result;
                ItemStack stackInSlot;
                if (!(useFreeSlot ? this.inventory.func_70301_a((int)slot).func_190926_b() : !(stackInSlot = this.inventory.func_70301_a((int)slot)).func_190926_b() && stackInSlot.func_77969_a(item) && (result = stackInSlot.func_190916_E() + item.func_190916_E()) <= this.inventory.func_70297_j_() && result <= item.func_77976_d())) continue;
                return slot;
            }
            useFreeSlot = true;
        }
        return -1;
    }

    private IStormForgeStackHandler getStackHandler(ItemStack stack) {
        IStormForgeStackHandler handler = null;
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof IStormForgeStackHandler) {
                handler = (IStormForgeStackHandler)stack.func_77973_b();
            } else if (stack.hasCapability(CapabilityStormForge.SPECIAL_STACK, null)) {
                handler = (IStormForgeStackHandler)stack.getCapability(CapabilityStormForge.SPECIAL_STACK, null);
            } else {
                for (IStormForgeStackHandler stackhandler : StormForgeRegistry.getStackHandlers()) {
                    if (!stackhandler.handleStack(stack)) continue;
                    return stackhandler;
                }
            }
        }
        return handler;
    }

    private boolean isSFStack(int slotId) {
        IStormForgeStackHandler handler;
        ItemStack stackInSlot = this.inventory.func_70301_a(slotId);
        if (!stackInSlot.func_190926_b() && (handler = this.getStackHandler(stackInSlot)) != null) {
            return handler.handleStack(stackInSlot);
        }
        return false;
    }

    private boolean isChargeable(int slotId) {
        ItemStack stackInSlot = this.inventory.func_70301_a(slotId);
        if (!stackInSlot.func_190926_b()) {
            for (IStormForgeRechargeHandler handler : StormForgeRegistry.getRechargeHandlers()) {
                if (!handler.handleStack(stackInSlot)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRepairable(int slotId) {
        ItemStack stackInSlot = this.inventory.func_70301_a(slotId);
        if (!stackInSlot.func_190926_b()) {
            for (IStormForgeRepairHandler handler : StormForgeRegistry.getRepairHandlers()) {
                if (!handler.handleStack(stackInSlot)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSmeltable(int slotId) {
        ItemStack stackInSlot = this.inventory.func_70301_a(slotId);
        return !stackInSlot.func_190926_b() && !FurnaceRecipes.func_77602_a().func_151395_a(stackInSlot).func_190926_b();
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public ItemStack getCenterItem() {
        ItemStack stackInSlot = this.inventory.func_70301_a(6);
        return !stackInSlot.func_190926_b() && this.isWorking ? stackInSlot.func_77946_l() : ItemStack.field_190927_a;
    }

    @SideOnly(value=Side.CLIENT)
    public short getProcessType(byte slotId) {
        if (!this.inventory.func_70301_a((int)slotId).func_190926_b()) {
            if (slotId == 6 && !this.isWorking) {
                return -1;
            }
            if (this.isSFStack(slotId)) {
                return 4;
            }
            if (this.isChargeable(slotId)) {
                return 1;
            }
            if (this.isRepairable(slotId)) {
                return 2;
            }
            if (this.isSmeltable(slotId)) {
                return 3;
            }
            return 0;
        }
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean showBar() {
        if (this.isSFStack(6)) {
            ItemStack stackInSlot = this.inventory.func_70301_a(6);
            IStormForgeStackHandler handler = this.getStackHandler(stackInSlot);
            return handler != null && handler.showBar(stackInSlot);
        }
        return !this.isChargeable(6) && (this.isRepairable(6) || this.isSmeltable(6));
    }

    @SideOnly(value=Side.CLIENT)
    public int getProgressScaled(int graphicWidth) {
        int base = this.delayTime * graphicWidth;
        if (this.isSFStack(6)) {
            ItemStack stackInSlot = this.inventory.func_70301_a(6);
            IStormForgeStackHandler handler = this.getStackHandler(stackInSlot);
            int ticks = handler != null ? handler.ticksToComplete(stackInSlot) : 0;
            return ticks > 0 ? base / ticks : 0;
        }
        return this.isRepairable(6) ? base / Configuration.TWEAKS.STORMFORGE.sfTicksPerRepairPoint : (this.isSmeltable(6) ? base / Configuration.TWEAKS.STORMFORGE.sfTicksToSmelt : 0);
    }
}

