/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import shetiphian.core.common.Function;
import shetiphian.core.common.inventory.ISidedWrapper;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.terraqueous.common.inventory.ContainerCraftBench;
import shetiphian.terraqueous.common.inventory.InventoryCraftBench;
import shetiphian.terraqueous.common.tileentity.TileEntityCrafting;

public class TileEntityCraftBench
extends TileEntityCrafting {
    private FakePlayer fakePlayer;
    public GhostMatrix ghostMatrix = new GhostMatrix((TileEntity)this);
    public boolean isCloud;

    public TileEntityCraftBench() {
        this.inventory = new InventoryCraftBench(this);
        InventoryCraftBench inv = (InventoryCraftBench)this.inventory;
        this.sidedWrapper = new ISidedWrapper.SidedWrapper(-1, new InvWrapper[]{inv.getWrapperBasic(), inv.getWrapperOutput(), inv.getWrapperStorage()});
        this.sidedWrapper.setFaceIndex(EnumFacing.DOWN, 1);
        this.sidedWrapper.setFaceIndex(EnumFacing.UP, 2);
        this.sidedWrapper.setFaceIndex(EnumFacing.NORTH, 0);
        this.sidedWrapper.setFaceIndex(EnumFacing.SOUTH, 0);
        this.sidedWrapper.setFaceIndex(EnumFacing.WEST, 2);
        this.sidedWrapper.setFaceIndex(EnumFacing.EAST, 1);
    }

    public TileEntityCraftBench(boolean isCloud) {
        this();
        this.isCloud = isCloud;
    }

    @Override
    protected void buildNBT(NBTTagCompound nbtTag) {
        super.buildNBT(nbtTag);
        nbtTag.func_74757_a("isCloud", this.isCloud);
        this.ghostMatrix.writeToNBT(nbtTag);
    }

    @Override
    protected void processNBT(NBTTagCompound nbtTag) {
        super.processNBT(nbtTag);
        this.isCloud = nbtTag.func_74767_n("isCloud");
        this.ghostMatrix.readFromNBT(nbtTag);
    }

    @Override
    protected void processNBT_SaveOnly(NBTTagCompound nbtTag) {
        if (nbtTag.func_74764_b("itemOutput") || nbtTag.func_74764_b("itemsChest") || nbtTag.func_74764_b("itemsBuffer")) {
            ItemStack itemOutput = this.itemReader(nbtTag, "itemOutput");
            ItemStack[] itemsChest = this.listReader(nbtTag.func_150295_c("itemsChest", 10), 27);
            ItemStack[] itemsBuffer = this.listReader(nbtTag.func_150295_c("itemsBuffer", 10), 2);
            ItemStack[] contents = new ItemStack[30];
            contents[0] = itemOutput;
            System.arraycopy(itemsChest, 0, contents, 1, 27);
            System.arraycopy(itemsBuffer, 0, contents, 28, 2);
            ((InventoryCraftBench)this.inventory).setContents(contents);
        } else {
            super.processNBT_SaveOnly(nbtTag);
        }
    }

    public void dropItems() {
        for (int slotId = 1; slotId < this.inventory.getContents().length; ++slotId) {
            Function.dropItem((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (ItemStack)this.inventory.func_70301_a(slotId));
        }
    }

    public void setCraftResult(ItemStack stack) {
        this.inventory.func_70299_a(0, stack);
    }

    public boolean ghostCraftCanTakeStack() {
        return this.canCraft();
    }

    public void ghostCraftOnPickupFromSlot(EntityPlayer player, ItemStack stack) {
        this.doCraft(player, stack);
    }

    public boolean canCraft() {
        return this.getSourceSlots() != null;
    }

    @Nonnull
    public ItemStack doCraft(EntityPlayer player, ItemStack stack) {
        int index;
        byte[] sourceSlots = this.getSourceSlots();
        if (sourceSlots == null) {
            return ItemStack.field_190927_a;
        }
        GhostMatrix craftMatrix = new GhostMatrix((TileEntity)this);
        for (int index2 = 0; index2 < 9; index2 = (int)((byte)(index2 + 1))) {
            if (sourceSlots[index2] > -1) {
                ItemStack sourceStack = this.inventory.func_70301_a((int)sourceSlots[index2]);
                craftMatrix.copyStackTo(index2, !sourceStack.func_190926_b() ? sourceStack.func_77946_l().func_77979_a(1) : ItemStack.field_190927_a);
                continue;
            }
            craftMatrix.copyStackTo(index2, ItemStack.field_190927_a);
        }
        ContainerCraftBench.GhostMatrixCrafting ghostCrafting = new ContainerCraftBench.GhostMatrixCrafting((IInventory)craftMatrix);
        IRecipe recipe = this.findMatchingRecipe(ghostCrafting, this.func_145831_w());
        ItemStack tempStack = stack;
        if (recipe != null) {
            tempStack = recipe.func_77572_b((InventoryCrafting)ghostCrafting);
        }
        if (recipe == null || tempStack.func_190926_b()) {
            if (player != null && Function.areItemStacksEqual((ItemStack)player.field_71071_by.func_70445_o(), (ItemStack)stack)) {
                if (player.field_71071_by.func_70445_o().func_190916_E() > stack.func_190916_E()) {
                    player.field_71071_by.func_70445_o().func_190920_e(player.field_71071_by.func_70445_o().func_190916_E() - stack.func_190916_E());
                } else {
                    player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                }
            }
            return ItemStack.field_190927_a;
        }
        tempStack.func_190920_e(stack.func_190916_E());
        stack = tempStack;
        if (player == null) {
            if (this.fakePlayer == null && this.func_145831_w() instanceof WorldServer) {
                this.fakePlayer = new FakePlayer((WorldServer)this.func_145831_w(), new GameProfile(null, "TerraqueousCraftBench"));
            }
            player = this.fakePlayer;
        } else {
            player.field_71071_by.func_70437_b(stack);
        }
        if (player != null) {
            FMLCommonHandler.instance().firePlayerCraftingEvent(player, stack, (IInventory)craftMatrix);
            new ContainerCraftBench.SlotGhostCrafting(player, ghostCrafting).onPlayerCrafting(stack);
            ForgeHooks.setCraftingPlayer((EntityPlayer)player);
        }
        NonNullList remainingItems = CraftingManager.func_180303_b((InventoryCrafting)ghostCrafting, (World)this.func_145831_w());
        ForgeHooks.setCraftingPlayer(null);
        for (index = 0; index < remainingItems.size(); ++index) {
            ItemStack craftStack = craftMatrix.func_70301_a(index);
            ItemStack remainStack = (ItemStack)remainingItems.get(index);
            if (!craftStack.func_190926_b()) {
                craftMatrix.func_70298_a(index, 1);
                craftStack = craftMatrix.func_70301_a(index);
            }
            if (remainStack.func_190926_b()) continue;
            if (craftStack.func_190926_b()) {
                craftMatrix.func_70299_a(index, remainStack);
                continue;
            }
            if (ItemStack.func_179545_c((ItemStack)craftStack, (ItemStack)remainStack) && ItemStack.func_77970_a((ItemStack)craftStack, (ItemStack)remainStack)) {
                remainStack.func_190917_f(craftStack.func_190916_E());
                craftMatrix.func_70299_a(index, remainStack);
                continue;
            }
            if (player != null && player.field_71071_by.func_70441_a(remainStack)) continue;
            Function.dropItem((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (ItemStack)remainStack);
        }
        for (index = 0; index < 9; index = (int)((byte)(index + 1))) {
            if (sourceSlots[index] <= -1) continue;
            this.inventory.func_70298_a((int)sourceSlots[index], 1);
            ItemStack unusedStack = craftMatrix.func_70301_a(index);
            if (unusedStack.func_190926_b()) continue;
            if (unusedStack.func_77973_b().func_77645_m()) {
                this.inventory.func_70299_a((int)sourceSlots[index], unusedStack);
                continue;
            }
            int outputSlot = -1;
            if (FluidUtil.getFluidHandler((ItemStack)unusedStack) != null && (outputSlot = (int)this.getOutputSlot(new ItemStack[]{this.inventory.func_70301_a(28), this.inventory.func_70301_a(29)}, unusedStack, false)) > -1) {
                ItemStack stackInSlot = this.inventory.func_70301_a(28 + outputSlot);
                if (!stackInSlot.func_190926_b()) {
                    stackInSlot.func_190917_f(unusedStack.func_190916_E());
                } else {
                    this.inventory.func_70299_a(28 + outputSlot, unusedStack);
                }
            }
            if (outputSlot != -1) continue;
            ItemStack[] itemsChest = new ItemStack[27];
            System.arraycopy(this.inventory.getContents(), 1, itemsChest, 0, 27);
            outputSlot = this.getOutputSlot(itemsChest, unusedStack, false);
            if (outputSlot > -1) {
                ItemStack stackInSlot = this.inventory.func_70301_a(1 + outputSlot);
                if (!stackInSlot.func_190926_b()) {
                    stackInSlot.func_190917_f(unusedStack.func_190916_E());
                    continue;
                }
                this.inventory.func_70299_a(1 + outputSlot, unusedStack);
                continue;
            }
            Function.dropItem((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (ItemStack)unusedStack);
        }
        this.func_70296_d();
        return stack;
    }

    private byte[] getSourceSlots() {
        byte[] slots = new byte[9];
        ItemStack[] matrix = this.ghostMatrix.getContents();
        ItemStack[] chest = new ItemStack[this.inventory.getContents().length];
        for (int slotId = 0; slotId < chest.length; ++slotId) {
            ItemStack stackInSlot = this.inventory.func_70301_a(slotId);
            chest[slotId] = !stackInSlot.func_190926_b() ? stackInSlot.func_77946_l() : ItemStack.field_190927_a;
        }
        IRecipe recipe = this.findMatchingRecipe(new ContainerCraftBench.GhostMatrixCrafting((IInventory)this.ghostMatrix), this.func_145831_w());
        boolean useDictionary = recipe instanceof ShapelessOreRecipe || recipe instanceof ShapedOreRecipe;
        for (int matrixSlot = 0; matrixSlot < 9; matrixSlot = (int)((byte)(matrixSlot + 1))) {
            int chestSlot;
            ItemStack target = matrix[matrixSlot];
            if (target.func_190926_b()) {
                slots[matrixSlot] = -1;
                continue;
            }
            boolean foundItem = false;
            for (chestSlot = 1; chestSlot < 28; chestSlot = (int)((byte)(chestSlot + 1))) {
                if (chest[chestSlot].func_190926_b()) continue;
                if (target.func_77984_f()) {
                    target = target.func_77946_l();
                    target.func_77964_b(Short.MAX_VALUE);
                }
                if (!OreDictionary.itemMatches((ItemStack)target, (ItemStack)chest[chestSlot], (!target.func_77984_f() ? 1 : 0) != 0)) continue;
                foundItem = true;
                break;
            }
            if (!foundItem && useDictionary) {
                block3: for (chestSlot = 1; chestSlot < 28; chestSlot = (int)((byte)(chestSlot + 1))) {
                    if (chest[chestSlot].func_190926_b()) continue;
                    for (ItemStack oreStack : this.ghostMatrix.getAlternatives(matrixSlot, target)) {
                        if (!OreDictionary.itemMatches((ItemStack)oreStack, (ItemStack)chest[chestSlot], (boolean)false)) continue;
                        foundItem = true;
                        break block3;
                    }
                }
            }
            if (foundItem) {
                slots[matrixSlot] = chestSlot;
                chest[chestSlot].func_190918_g(1);
                if (!chest[chestSlot].func_190926_b()) continue;
                chest[chestSlot] = ItemStack.field_190927_a;
                continue;
            }
            return null;
        }
        return slots;
    }

    public IRecipe findMatchingRecipe(InventoryCrafting inventory, World world) {
        for (IRecipe recipe : CraftingManager.field_193380_a) {
            if (!recipe.func_77569_a(inventory, world)) continue;
            return recipe;
        }
        return null;
    }

    private static class GhostMatrix
    extends InventoryInternal {
        private HashMap<Integer, NonNullList<ItemStack>> oreCache = new HashMap();

        GhostMatrix(TileEntity invOwner) {
            super(invOwner, "ghostmatrix", 9, 1, "CraftBench-CraftMatrix");
        }

        public void func_70299_a(int slotId, ItemStack itemStack) {
            super.func_70299_a(slotId, itemStack);
            this.oreCache.remove(slotId);
        }

        NonNullList<ItemStack> getAlternatives(int slotId, ItemStack baseStack) {
            if (baseStack.func_190926_b()) {
                return OreDictionary.EMPTY_LIST;
            }
            NonNullList oreStacks = this.oreCache.get(slotId);
            if (oreStacks == null) {
                int[] oreIds;
                oreStacks = NonNullList.func_191196_a();
                for (int id : oreIds = OreDictionary.getOreIDs((ItemStack)baseStack)) {
                    oreStacks.addAll((Collection)OreDictionary.getOres((String)OreDictionary.getOreName((int)id)));
                }
                this.oreCache.put(slotId, (NonNullList<ItemStack>)oreStacks);
            }
            return oreStacks;
        }

        void copyStackTo(int slotId, ItemStack itemStack) {
            if (this.okSlotId(slotId) && !itemStack.func_190926_b()) {
                this.contents[slotId] = itemStack.func_77946_l();
                this.contents[slotId].func_190920_e(1);
            }
        }
    }
}

