/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.client.Localization;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.item.ItemBlockMulti;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.common.rgb16.RGB16StackHelper;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.client.misc.FoliageColor;
import shetiphian.terraqueous.common.block.BlockPergola;
import shetiphian.terraqueous.common.tileentity.TileEntityPergolaBase;
import shetiphian.terraqueous.common.tileentity.TileEntityPergolaGate;

public class ItemBlockPergola
extends ItemBlockMulti
implements IRGB16_Item,
IColored {
    public ItemBlockPergola(Block block) {
        super(block, "BlockPergola", Values.nameMapper);
    }

    public void getSubItems(NonNullList<ItemStack> list) {
        int index;
        for (EnumDyeColor dye : EnumDyeColor.values()) {
            list.add((Object)RGB16StackHelper.setRGB16((ItemStack)new ItemStack((Item)this, 1, 0), (String)dye.func_176610_l()));
        }
        for (index = 7; index < 9; index = (int)((byte)(index + 1))) {
            for (EnumDyeColor dye : EnumDyeColor.values()) {
                list.add((Object)RGB16StackHelper.setRGB16((ItemStack)new ItemStack((Item)this, 1, index), (String)dye.func_176610_l()));
            }
        }
        if (Configuration.BLOCKS.addPlants) {
            for (index = 1; index < 7; index = (int)((byte)(index + 1))) {
                list.add((Object)new ItemStack((Item)this, 1, index));
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b()) {
            return EnumActionResult.PASS;
        }
        int damage = stack.func_77952_i();
        if (damage > 0 && damage < 7) {
            IBlockState state = world.func_180495_p(pos);
            if ((state = state.func_185899_b((IBlockAccess)world, pos)).func_177230_c() instanceof BlockPergola) {
                boolean isGate;
                BlockPergola.EnumType type = BlockPergola.getEnumType(state);
                boolean bl = isGate = type.getBaseType() == BlockPergola.EnumBase.GATE;
                if (type.getCoverType() == BlockPergola.EnumCover.NONE) {
                    BlockPergola.EnumType newType = null;
                    switch (damage) {
                        case 1: 
                        case 2: {
                            if (damage == 1 || isGate) {
                                newType = BlockPergola.EnumType.withTypes(type.getBaseType(), BlockPergola.EnumCover.GRAPEVINE);
                                break;
                            }
                            newType = BlockPergola.EnumType.withTypes(type.getBaseType(), BlockPergola.EnumCover.GRAPEVINE_FRUIT);
                            break;
                        }
                        case 3: 
                        case 4: {
                            if (damage == 3 || isGate) {
                                newType = BlockPergola.EnumType.withTypes(type.getBaseType(), BlockPergola.EnumCover.LIFEVINE);
                                break;
                            }
                            newType = BlockPergola.EnumType.withTypes(type.getBaseType(), BlockPergola.EnumCover.LIFEVINE_FRUIT);
                            break;
                        }
                        case 5: 
                        case 6: {
                            newType = damage == 5 || isGate ? BlockPergola.EnumType.withTypes(type.getBaseType(), BlockPergola.EnumCover.DEATHVINE) : BlockPergola.EnumType.withTypes(type.getBaseType(), BlockPergola.EnumCover.DEATHVINE_FRUIT);
                        }
                    }
                    if (newType != null) {
                        if (isGate) {
                            TileEntity tile = world.func_175625_s(pos);
                            if (tile instanceof TileEntityPergolaGate) {
                                ((TileEntityPergolaGate)tile).setCover(newType.getCoverType());
                            }
                        } else {
                            Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state.func_177226_a(BlockPergola.VARIANT, (Comparable)((Object)newType)), (boolean)true);
                        }
                        if (!player.field_71075_bZ.field_75098_d) {
                            stack.func_190918_g(1);
                        }
                        return EnumActionResult.SUCCESS;
                    }
                }
            }
            return EnumActionResult.FAIL;
        }
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        int damage = stack.func_77952_i();
        if (damage < 7 && damage != 0) {
            return false;
        }
        if (!this.func_179223_d().func_176196_c(world, pos)) {
            return false;
        }
        if (!Function.setBlock((World)world, (BlockPos)pos, (IBlockState)newState, (boolean)false)) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (damage == 8) {
            if (tile instanceof TileEntityPergolaGate) {
                ((TileEntityPergolaGate)tile).setFacing(player.func_174811_aO().func_176734_d());
                ((TileEntityPergolaGate)tile).setDefaultStatus();
                ((TileEntityPergolaGate)tile).setRGB16(this.getRGB16(stack), null);
                Function.syncTile((TileEntity)tile);
                world.func_175685_c(pos, newState.func_177230_c(), true);
                return true;
            }
        } else if (tile instanceof TileEntityPergolaBase) {
            ((TileEntityPergolaBase)tile).setRGB16(this.getRGB16(stack), null);
            Function.syncTile((TileEntity)tile);
            world.func_175685_c(pos, newState.func_177230_c(), true);
            return true;
        }
        Function.removeBlock((World)world, (BlockPos)pos, (boolean)false);
        return false;
    }

    public short getRGB16(ItemStack stack) {
        int damage = stack.func_77952_i();
        if (damage == 0 || damage > 6) {
            return RGB16StackHelper.readColorTag((ItemStack)stack, (short)RGB16Helper.getIndexFor((String)"dyeWhite"));
        }
        return -1;
    }

    public boolean setRGB16(ItemStack stack, short rgbIndex) {
        int damage = stack.func_77952_i();
        return (damage == 0 || damage > 6) && RGB16StackHelper.writeColorTags((ItemStack)stack, (short)rgbIndex);
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (!data.stack.func_190926_b()) {
            int damage = data.stack.func_77952_i();
            if (index == 0 && (damage == 0 || damage > 6)) {
                return RGB16Helper.getColor((short)this.getRGB16(data.stack));
            }
            if (index == 1) {
                if (damage == 1 || damage == 2) {
                    return FoliageColor.getRenderColor(FoliageColor.EnumFoliage.GRAPEVINE);
                }
                if (damage == 3 || damage == 4) {
                    return FoliageColor.getRenderColor(FoliageColor.EnumFoliage.LIFEVINE);
                }
                if (damage == 5 || damage == 6) {
                    return FoliageColor.getRenderColor(FoliageColor.EnumFoliage.DEATHVINE);
                }
            }
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advancedTooltips) {
        int damage = stack.func_77952_i();
        if (damage == 0 || damage > 6) {
            tooltip.add(RGB16Helper.getTooltip((short)this.getRGB16(stack)));
        } else if (damage % 2 == 0) {
            tooltip.add(Localization.get((String)"info.terraqueous.withfruit.txt"));
        }
    }

    protected void addToNameMap() {
        this.add(0, "pergola/", "top", "top");
        this.add(1, "pergola/", "grapevine", "grapevine");
        this.add(2, "pergola/", "grapevine_fruit", "grapevine");
        this.add(3, "pergola/", "lifevine", "lifevine");
        this.add(4, "pergola/", "lifevine_fruit", "lifevine");
        this.add(5, "pergola/", "deathvine", "deathvine");
        this.add(6, "pergola/", "deathvine_fruit", "deathvine");
        this.add(7, "pergola/", "wall", "wall");
        this.add(8, "pergola/", "gate", "gate");
    }
}

