/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.Values;

public class BlockEarthOre
extends Block {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    private static Cache<Integer, Byte> cacheTeleport = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).build();
    private static AxisAlignedBB COLLISION = new AxisAlignedBB(0.01, 0.01, 0.01, 0.99, 0.99, 0.99);

    public BlockEarthOre() {
        super(Material.field_151576_e);
        this.func_149647_a((CreativeTabs)Values.tabTerraqueous);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(5.0f);
        this.func_149752_b(15.0f);
        this.setHarvestLevel("pickaxe", 2);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byValue(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return this.getEnumType(state).getValue();
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        EnumType type = this.getEnumType(state);
        return type.isOre() ? 3.0f : 5.0f;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return COLLISION;
    }

    public int func_180651_a(IBlockState state) {
        EnumType type = this.getEnumType(state);
        return type.getValue();
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        EnumType type = this.getEnumType(state);
        if (type.isOre()) {
            switch (type.getValue()) {
                case 0: {
                    Function.attemptAdd(drops, (ItemStack)Function.getOre((String)"dustEndimium", (int[])new int[]{1 + Function.random.nextInt(2 + fortune)}));
                    Function.attemptAdd(drops, (ItemStack)Function.getOre((String)"dustTinyEndimium", (int[])new int[]{2 + Function.random.nextInt(2 + fortune)}));
                    break;
                }
                case 1: {
                    Function.attemptAdd(drops, (ItemStack)Function.getOre((String)"dustBurnium", (int[])new int[]{1 + Function.random.nextInt(2 + fortune)}));
                    Function.attemptAdd(drops, (ItemStack)Function.getOre((String)"dustTinyBurnium", (int[])new int[]{2 + Function.random.nextInt(2 + fortune)}));
                }
            }
            return;
        }
        super.getDrops(drops, world, pos, state, fortune);
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        EnumType type = this.getEnumType(state);
        return type.isOre() || super.canSilkHarvest(world, pos, state, player);
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean isBeaconBase(IBlockAccess world, BlockPos pos, BlockPos beacon) {
        EnumType type = this.getEnumType(world.func_180495_p(pos));
        return !type.isOre();
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        EnumType type = this.getEnumType(state);
        if (entity instanceof EntityDragon && type.getBaseType() == EnumBase.ENDIMIUM) {
            return false;
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        this.func_180634_a(world, pos, world.func_180495_p(pos), entity);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        EnumType type = this.getEnumType(state);
        if (type != null && entity instanceof EntityLivingBase) {
            switch (type.getBaseType()) {
                case BURNIUM: {
                    if (entity.func_70045_F()) break;
                    entity.func_70097_a(DamageSource.field_76370_b, 1.0f);
                    entity.func_70015_d(type.isOre() ? 2 : 4);
                    break;
                }
                case ENDIMIUM: {
                    if (world.field_72995_K || cacheTeleport.getIfPresent((Object)entity.func_145782_y()) != null) break;
                    cacheTeleport.put((Object)entity.func_145782_y(), (Object)0);
                    if (entity instanceof EntityEnderman || entity instanceof EntityEndermite || entity instanceof EntityDragon) break;
                    BlockEarthOre.teleportEntity(world, pos, (EntityLivingBase)entity, type.isOre() ? 4 : 16);
                }
            }
        }
    }

    public static void teleportEntity(World world, BlockPos pos, EntityLivingBase entity, int distance) {
        int targetX = (int)(entity.field_70165_t + (double)world.field_73012_v.nextInt(distance * 2) - (double)distance);
        int targetY = (int)(entity.field_70163_u + (double)world.field_73012_v.nextInt(distance * 2) - (double)(distance / 4));
        int targetZ = (int)(entity.field_70161_v + (double)world.field_73012_v.nextInt(distance * 2) - (double)distance);
        double startX = entity.field_70165_t;
        double startY = entity.field_70163_u;
        double startZ = entity.field_70161_v;
        BlockPos target = new BlockPos(targetX, targetY, targetZ);
        if (world.func_175667_e(target)) {
            boolean spotGood = false;
            int height = MathHelper.func_76123_f((float)entity.field_70131_O);
            while (!spotGood && target.func_177956_o() > 0) {
                if (world.func_175623_d(target) && world.func_180495_p(target.func_177977_b()).func_185904_a().func_76230_c()) {
                    spotGood = true;
                    for (int check = 1; check < height; ++check) {
                        if (world.func_175623_d(target.func_177981_b(check))) continue;
                        spotGood = false;
                    }
                }
                if (spotGood) continue;
                target = target.func_177977_b();
            }
            if (spotGood) {
                if (entity instanceof EntityPlayer) {
                    entity.func_70634_a((double)((float)targetX + 0.5f), (double)target.func_177956_o(), (double)((float)targetZ + 0.5f));
                } else {
                    entity.func_70107_b((double)((float)targetX + 0.5f), (double)target.func_177956_o(), (double)((float)targetZ + 0.5f));
                }
                int short1 = 128;
                for (int l = 0; l < short1; ++l) {
                    double d6 = (double)l / ((double)short1 - 1.0);
                    float f = (world.field_73012_v.nextFloat() - 0.5f) * 0.2f;
                    float f1 = (world.field_73012_v.nextFloat() - 0.5f) * 0.2f;
                    float f2 = (world.field_73012_v.nextFloat() - 0.5f) * 0.2f;
                    double d7 = startX + (entity.field_70165_t - startX) * d6 + (world.field_73012_v.nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
                    double d8 = startY + (entity.field_70163_u - startY) * d6 + world.field_73012_v.nextDouble() * (double)entity.field_70131_O;
                    double d9 = startZ + (entity.field_70161_v - startZ) * d6 + (world.field_73012_v.nextDouble() - 0.5) * (double)entity.field_70130_N * 2.0;
                    world.func_175688_a(EnumParticleTypes.PORTAL, d7, d8, d9, (double)f, (double)f1, (double)f2, new int[0]);
                }
                world.func_184133_a(null, pos, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, 1.0f);
                entity.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            }
        }
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        IBlockState state = world.func_180495_p(pos);
        EnumType type = this.getEnumType(state);
        if (type.isOre()) {
            return false;
        }
        EnumStyle style = type.getStyleType();
        switch (style) {
            case ORE: {
                return false;
            }
            case BLOCK: {
                style = EnumStyle.SMOOTH;
                break;
            }
            case SMOOTH: {
                style = EnumStyle.GROOVE;
                break;
            }
            case GROOVE: {
                style = EnumStyle.RINGS;
                break;
            }
            case RINGS: {
                style = EnumStyle.BLOCK;
            }
        }
        state = state.func_177226_a(VARIANT, (Comparable)((Object)EnumType.withTypes(type.getBaseType(), style)));
        Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state, (boolean)true);
        return true;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumType type = this.getEnumType(state);
        return type.getLight();
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.TRANSLUCENT && this.getEnumType(state).getStyleType() == EnumStyle.ORE;
    }

    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getEnumType(state).getBaseType() == EnumBase.BURNIUM ? PathNodeType.DANGER_FIRE : super.getAiPathNodeType(state, world, pos);
    }

    private EnumType getEnumType(IBlockState state) {
        EnumType type;
        try {
            type = (EnumType)((Object)state.func_177229_b(VARIANT));
        }
        catch (Exception e) {
            type = EnumType.ENDIMIUM_ORE;
            Terraqueous.errorPropertyNotFound("BlockEarthOre.VARIANT", "ENDIMIUM_ORE", state.toString());
        }
        return type;
    }

    private static enum EnumStyle {
        ORE(0, 0),
        BLOCK(3, 2),
        SMOOTH(6, 2),
        GROOVE(9, 2),
        RINGS(12, 2);

        private final byte value;
        private final int light;

        private EnumStyle(int value, int light) {
            this.value = (byte)value;
            this.light = light;
        }

        public byte getValue() {
            return this.value;
        }

        public int getLight() {
            return this.light;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }

    private static enum EnumBase {
        ENDIMIUM(0, 4),
        BURNIUM(1, 8);

        private final byte value;
        private final int light;

        private EnumBase(int value, int light) {
            this.value = (byte)value;
            this.light = light;
        }

        public byte getValue() {
            return this.value;
        }

        public int getLight() {
            return this.light;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum EnumType implements IStringSerializable
    {
        ENDIMIUM_ORE(0, EnumBase.ENDIMIUM, EnumStyle.ORE),
        BURNIUM_ORE(1, EnumBase.BURNIUM, EnumStyle.ORE),
        ENDIMIUM_BLOCK(3, EnumBase.ENDIMIUM, EnumStyle.BLOCK),
        BURNIUM_BLOCK(4, EnumBase.BURNIUM, EnumStyle.BLOCK),
        ENDIMIUM_SMOOTH(6, EnumBase.ENDIMIUM, EnumStyle.SMOOTH),
        BURNIUM_SMOOTH(7, EnumBase.BURNIUM, EnumStyle.SMOOTH),
        ENDIMIUM_GROOVE(9, EnumBase.ENDIMIUM, EnumStyle.GROOVE),
        BURNIUM_GROOVE(10, EnumBase.BURNIUM, EnumStyle.GROOVE),
        ENDIMIUM_RINGS(12, EnumBase.ENDIMIUM, EnumStyle.RINGS),
        BURNIUM_RINGS(13, EnumBase.BURNIUM, EnumStyle.RINGS);

        private static final EnumType[] array;
        private final byte value;
        private final EnumBase base;
        private final EnumStyle style;

        private EnumType(int value, EnumBase base, EnumStyle style) {
            this.value = (byte)value;
            this.base = base;
            this.style = style;
        }

        public byte getValue() {
            return this.value;
        }

        public EnumBase getBaseType() {
            return this.base;
        }

        public EnumStyle getStyleType() {
            return this.style;
        }

        public int getLight() {
            return this.base.getLight() + this.style.getLight();
        }

        public boolean isOre() {
            return this.style != null && this.style == EnumStyle.ORE;
        }

        public IBlockState state() {
            if (Values.blockEarthOre != null) {
                return Values.blockEarthOre.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)this));
            }
            return null;
        }

        public static EnumType byValue(int value) {
            EnumType type = array[MathHelper.func_76125_a((int)value, (int)0, (int)(array.length - 1))];
            return type == null ? ENDIMIUM_ORE : type;
        }

        public static EnumType withTypes(EnumBase base, EnumStyle style) {
            int value = (base != null ? base.getValue() : (byte)0) + (style != null ? style.getValue() : (byte)0);
            return EnumType.byValue(value);
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            array = new EnumType[16];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType value;
                EnumType.array[value.getValue()] = value = enumTypeArray[i];
            }
        }
    }
}

