/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.client.model;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import shetiphian.terraqueous.common.block.BlockPergola;

public class ModelPergola_Composite
implements IBakedModel {
    private final Map<String, IBakedModel> models;

    public ModelPergola_Composite(Map<String, IBakedModel> models) {
        this.models = models;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.models.containsKey("top_bars") ? this.models.get("top_bars").func_177554_e() : null;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
        for (IBakedModel model : this.handleBlockState(state)) {
            quads.addAll(model.func_188616_a(state, side, rand));
        }
        return quads;
    }

    private List<IBakedModel> handleBlockState(IBlockState state) {
        IExtendedBlockState eState;
        IBlockState eibs;
        String savedType = null;
        if (state instanceof IExtendedBlockState && (eibs = (IBlockState)(eState = (IExtendedBlockState)state).getValue((IUnlistedProperty)BlockPergola.EIBS)) != null) {
            savedType = eibs.toString();
            savedType = savedType.substring("terraqueous:pergola[".length(), savedType.length() - 1);
        }
        if (Strings.isNullOrEmpty(savedType)) {
            savedType = "ed=none,nd=none,sd=none,wd=none,xd=none";
        }
        String[] properties = savedType.split(",");
        String property = properties[0] + "," + properties[1] + "," + properties[2] + "," + properties[3];
        List<IBakedModel> list = new ArrayList<IBakedModel>();
        BlockPergola.EnumType type = BlockPergola.getEnumType(state);
        BlockPergola.EnumCover cover = type.getCoverType();
        boolean hasVines = cover != BlockPergola.EnumCover.NONE;
        String fruit = !hasVines || !cover.toString().contains("fruit") ? "" : cover.toString().replace("vine_fruit", "");
        switch (type.getBaseType()) {
            case GATE: {
                property = !properties[0].contains("none") ? properties[0] : (!properties[1].contains("none") ? properties[1] : "ed=normal");
                property = property.replace("middle", "normal");
                property = property + "," + properties[4];
                list = this.getGateModels(list, property, hasVines);
                break;
            }
            case TOP: {
                if (property.contains("middle") && !property.equals("ed=middle,nd=middle,sd=middle,wd=middle")) {
                    property = property.replaceAll("middle", "normal");
                }
                property = property.replaceAll("bottom", "normal").replaceAll("top", "normal");
                property = property + "," + (properties[4].equals("xd=none") ? "xd=none" : "xd=normal");
                list = this.getTopModels(list, property, hasVines, fruit);
                break;
            }
            case WALL: {
                property = property + "," + (properties[4].equals("xd=middle") ? "xd=normal" : properties[4]);
                list = this.getWallModels(list, property, hasVines, fruit);
            }
        }
        return list;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    private List<IBakedModel> getGateModels(List<IBakedModel> list, String type, boolean hasVines) {
        if (type.contains("nd=top")) {
            this.addModel(list, this.models.get("gate_n_open_r"));
            if (hasVines) {
                this.addModel(list, this.models.get("vine_gate_n_open_r"));
            }
        } else if (type.contains("nd=bottom")) {
            this.addModel(list, this.models.get("gate_n_open_l"));
            if (hasVines) {
                this.addModel(list, this.models.get("vine_gate_n_open_l"));
            }
        } else if (type.contains("ed=top")) {
            this.addModel(list, this.models.get("gate_open_r"));
            if (hasVines) {
                this.addModel(list, this.models.get("vine_gate_open_r"));
            }
        } else if (type.contains("ed=bottom")) {
            this.addModel(list, this.models.get("gate_open_l"));
            if (hasVines) {
                this.addModel(list, this.models.get("vine_gate_open_l"));
            }
        } else {
            boolean top = type.contains("xd=top");
            boolean bars = top || type.contains("xd=middle");
            boolean north = type.contains("nd=normal");
            if (bars) {
                this.addModel(list, this.models.get(north ? "gate_n_bars" : "gate_bars"));
                if (top) {
                    this.addModel(list, this.models.get(north ? "gate_n_bar_top" : "gate_bar_top"));
                }
            } else {
                this.addModel(list, this.models.get(north ? "gate_n_closed" : "gate_closed"));
            }
            if (hasVines) {
                if (bars) {
                    this.addModel(list, this.models.get(north ? "vine_gate_n_bars" : "vine_gate_bars"));
                    if (top) {
                        this.addModel(list, this.models.get(north ? "vine_gate_n_bar_top" : "vine_gate_bar_top"));
                    }
                } else {
                    this.addModel(list, this.models.get(north ? "vine_gate_n_closed" : "vine_gate_closed"));
                }
            }
        }
        return list;
    }

    private List<IBakedModel> getTopModels(List<IBakedModel> list, String type, boolean hasVines, String fruit) {
        ArrayList<String> names = new ArrayList<String>();
        boolean hasPost = type.contains("xd=normal");
        names.add("top_bars");
        if (type.startsWith("ed=normal,nd=normal,sd=normal,wd=normal")) {
            names.add("top_beam_ew_single");
            if (hasPost) {
                names.add("top_post_l");
            }
        } else if (type.startsWith("ed=normal,nd=none,sd=normal,wd=none")) {
            names.add("top_beam_ew_dual");
            names.add("top_beam_ns_dual");
            names.add("top_cap_n_dual");
            names.add("top_cap_w_dual");
            if (hasPost) {
                names.add("top_post_l");
            } else {
                names.add("top_post_s");
                hasPost = true;
            }
        } else if (type.startsWith("ed=none,nd=none,sd=normal,wd=normal")) {
            names.add("top_beam_ew_dual");
            names.add("top_beam_ns_dual");
            names.add("top_cap_n_dual");
            names.add("top_cap_e_dual");
            if (hasPost) {
                names.add("top_post_l");
            } else {
                names.add("top_post_s");
                hasPost = true;
            }
        } else if (type.startsWith("ed=none,nd=normal,sd=none,wd=normal")) {
            names.add("top_beam_ew_dual");
            names.add("top_beam_ns_dual");
            names.add("top_cap_s_dual");
            names.add("top_cap_e_dual");
            if (hasPost) {
                names.add("top_post_l");
            } else {
                names.add("top_post_s");
                hasPost = true;
            }
        } else if (type.startsWith("ed=normal,nd=normal,sd=none,wd=none")) {
            names.add("top_beam_ew_dual");
            names.add("top_beam_ns_dual");
            names.add("top_cap_s_dual");
            names.add("top_cap_w_dual");
            if (hasPost) {
                names.add("top_post_l");
            } else {
                names.add("top_post_s");
                hasPost = true;
            }
        } else if (type.startsWith("ed=none,nd=none,sd=normal,wd=none")) {
            names.add("top_beam_ew_dual");
            names.add("top_beam_ns_dual");
            names.add("top_cap_n_dual");
            names.add("top_cap_e_dual");
            names.add("top_cap_w_dual");
            if (hasPost) {
                names.add("top_post_l");
            } else {
                names.add("top_post_s");
                hasPost = true;
            }
        } else if (type.startsWith("ed=none,nd=none,sd=none,wd=normal")) {
            names.add("top_beam_ew_dual");
            names.add("top_beam_ns_dual");
            names.add("top_cap_n_dual");
            names.add("top_cap_e_dual");
            names.add("top_cap_s_dual");
            if (hasPost) {
                names.add("top_post_l");
            } else {
                names.add("top_post_s");
                hasPost = true;
            }
        } else if (type.startsWith("ed=none,nd=normal,sd=none,wd=none")) {
            names.add("top_beam_ew_dual");
            names.add("top_beam_ns_dual");
            names.add("top_cap_e_dual");
            names.add("top_cap_s_dual");
            names.add("top_cap_w_dual");
            if (hasPost) {
                names.add("top_post_l");
            } else {
                names.add("top_post_s");
                hasPost = true;
            }
        } else if (type.startsWith("ed=normal,nd=none,sd=none,wd=none")) {
            names.add("top_beam_ew_dual");
            names.add("top_beam_ns_dual");
            names.add("top_cap_n_dual");
            names.add("top_cap_s_dual");
            names.add("top_cap_w_dual");
            if (hasPost) {
                names.add("top_post_l");
            } else {
                names.add("top_post_s");
                hasPost = true;
            }
        } else if (type.startsWith("ed=normal,nd=none,sd=normal,wd=normal")) {
            names.add("top_beam_ew_dual");
            if (hasPost) {
                names.add("top_post_l");
            }
        } else if (type.startsWith("ed=none,nd=normal,sd=normal,wd=normal")) {
            names.add("top_beam_ew_single");
            names.add("top_beam_ns_dual");
            names.add("top_cap_e_single");
            if (hasPost) {
                names.add("top_post_l");
            }
        } else if (type.startsWith("ed=normal,nd=normal,sd=none,wd=normal")) {
            names.add("top_beam_ew_dual");
            if (hasPost) {
                names.add("top_post_l");
            }
        } else if (type.startsWith("ed=normal,nd=normal,sd=normal,wd=none")) {
            names.add("top_beam_ew_single");
            names.add("top_beam_ns_dual");
            names.add("top_cap_w_single");
            if (hasPost) {
                names.add("top_post_l");
            }
        } else if (type.startsWith("ed=middle,nd=middle,sd=middle,wd=middle")) {
            names.add("top_beam_ew_single");
            names.add("top_beam_ew_dual");
            names.add("top_beam_ns_dual");
            if (hasPost) {
                names.add("top_post_l");
            } else {
                names.add("top_post_s");
                hasPost = true;
            }
        } else if (type.startsWith("ed=none,nd=none,sd=none,wd=none")) {
            names.add("top_beam_ew_dual");
            names.add("top_beam_ns_dual");
            names.add("top_cap_n_dual");
            names.add("top_cap_e_dual");
            names.add("top_cap_s_dual");
            names.add("top_cap_w_dual");
            if (hasPost) {
                names.add("top_post_l");
            } else {
                names.add("top_post_s");
                hasPost = true;
            }
        } else if (type.startsWith("ed=normal,nd=none,sd=none,wd=normal")) {
            names.add("top_beam_ew_dual");
            if (hasPost) {
                names.add("top_post_l");
            }
        } else if (type.startsWith("ed=none,nd=normal,sd=normal,wd=none")) {
            names.add("top_beam_ew_single");
            names.add("top_beam_ns_dual");
            names.add("top_cap_e_single");
            names.add("top_cap_w_single");
            if (hasPost) {
                names.add("top_post_l");
            }
        }
        for (String name : names) {
            this.addModel(list, this.models.get(name));
            if (name.startsWith("top_cap_") || !hasVines) continue;
            this.addModel(list, this.models.get("vine_" + name));
            if (Strings.isNullOrEmpty((String)fruit)) continue;
            if (hasPost) {
                this.addModel(list, this.models.get(fruit + "_fruit_top_hang_high"));
                continue;
            }
            this.addModel(list, this.models.get(fruit + "_fruit_top_hang_low"));
        }
        return list;
    }

    private List<IBakedModel> getWallModels(List<IBakedModel> list, String type, boolean hasVines, String fruit) {
        ArrayList<String> names = new ArrayList<String>();
        String[] properties = type.split(",");
        for (String property : properties) {
            String[] parts;
            if (property.contains("none") || (parts = property.split("=")).length != 2) continue;
            String name = "_" + parts[0].charAt(0) + (parts[1].equals("normal") ? "" : Character.valueOf(parts[1].charAt(0)));
            names.add("wall_part" + name.replace("x", "p"));
        }
        for (String name : names) {
            this.addModel(list, this.models.get(name));
            if (!hasVines) continue;
            this.addModel(list, this.models.get("vine_" + name));
            if (Strings.isNullOrEmpty((String)fruit)) continue;
            if (name.endsWith("b") || name.endsWith("m") || name.endsWith("t")) {
                name = name.substring(0, name.length() - 1);
            }
            this.addModel(list, this.models.get(fruit + "_fruit_" + name));
        }
        return list;
    }

    private List<IBakedModel> addModel(List<IBakedModel> list, IBakedModel model) {
        if (list != null && model != null) {
            list.add(model);
        }
        return list;
    }
}

