/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import shetiphian.terraqueous.client.model.ModelPergola_Composite;

public class ModelPergola_Base
implements IModel {
    private static final List<ResourceLocation> TEXTURES = new ArrayList<ResourceLocation>();
    private static final List<ModelData> MODELS = new ArrayList<ModelData>();

    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.copyOf(TEXTURES);
    }

    public Collection<ResourceLocation> getDependencies() {
        ArrayList<ResourceLocation> locations = new ArrayList<ResourceLocation>();
        for (ModelData modeldata : MODELS) {
            locations.add(modeldata.getLocation());
        }
        return ImmutableList.copyOf(locations);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        String[] fruits = new String[]{"grape", "life", "death"};
        HashMap<String, IBakedModel> bakedModels = new HashMap<String, IBakedModel>();
        for (ModelData modeldata : MODELS) {
            IModel unbaked = null;
            try {
                unbaked = ModelLoaderRegistry.getModel((ResourceLocation)modeldata.getLocation());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (unbaked == null) continue;
            if (modeldata.doRetexture()) {
                for (String fruit : fruits) {
                    HashMap textures = Maps.newHashMap();
                    textures.put("fruit", "terraqueous:blocks/plants/pergola_fruit_" + fruit);
                    IModel retextured = unbaked.retexture(ImmutableMap.copyOf((Map)textures));
                    IBakedModel baked = retextured.bake((IModelState)modeldata.getRotation(), format, bakedTextureGetter);
                    bakedModels.put(fruit + "_" + modeldata.getName(), baked);
                }
                continue;
            }
            IBakedModel baked = unbaked.bake((IModelState)modeldata.getRotation(), format, bakedTextureGetter);
            bakedModels.put(modeldata.getName(), baked);
        }
        return new ModelPergola_Composite(bakedModels);
    }

    static {
        TEXTURES.add(new ResourceLocation("terraqueous:blocks/plants/pergola_fruit_grape"));
        TEXTURES.add(new ResourceLocation("terraqueous:blocks/plants/pergola_fruit_life"));
        TEXTURES.add(new ResourceLocation("terraqueous:blocks/plants/pergola_fruit_death"));
        MODELS.add(new ModelData("gate_closed"));
        MODELS.add(new ModelData("gate_open_l"));
        MODELS.add(new ModelData("gate_open_r"));
        MODELS.add(new ModelData("gate_bars"));
        MODELS.add(new ModelData("gate_bar_top"));
        MODELS.add(new ModelData("gate_n_closed", "gate_closed", ModelRotation.X0_Y90));
        MODELS.add(new ModelData("gate_n_open_l", "gate_open_l", ModelRotation.X0_Y90));
        MODELS.add(new ModelData("gate_n_open_r", "gate_open_r", ModelRotation.X0_Y90));
        MODELS.add(new ModelData("gate_n_bars", "gate_bars", ModelRotation.X0_Y90));
        MODELS.add(new ModelData("gate_n_bar_top", "gate_bar_top", ModelRotation.X0_Y90));
        MODELS.add(new ModelData("vine_gate_closed"));
        MODELS.add(new ModelData("vine_gate_open_l"));
        MODELS.add(new ModelData("vine_gate_open_r"));
        MODELS.add(new ModelData("vine_gate_bars"));
        MODELS.add(new ModelData("vine_gate_bar_top"));
        MODELS.add(new ModelData("vine_gate_n_closed", "vine_gate_closed", ModelRotation.X0_Y90));
        MODELS.add(new ModelData("vine_gate_n_open_l", "vine_gate_open_l", ModelRotation.X0_Y90));
        MODELS.add(new ModelData("vine_gate_n_open_r", "vine_gate_open_r", ModelRotation.X0_Y90));
        MODELS.add(new ModelData("vine_gate_n_bars", "vine_gate_bars", ModelRotation.X0_Y90));
        MODELS.add(new ModelData("vine_gate_n_bar_top", "vine_gate_bar_top", ModelRotation.X0_Y90));
        MODELS.add(new ModelData("top_bars"));
        MODELS.add(new ModelData("top_beam_ew_dual"));
        MODELS.add(new ModelData("top_beam_ew_single"));
        MODELS.add(new ModelData("top_beam_ns_dual"));
        MODELS.add(new ModelData("top_cap_e_dual"));
        MODELS.add(new ModelData("top_cap_e_single"));
        MODELS.add(new ModelData("top_cap_n_dual"));
        MODELS.add(new ModelData("top_cap_s_dual"));
        MODELS.add(new ModelData("top_cap_w_dual"));
        MODELS.add(new ModelData("top_cap_w_single"));
        MODELS.add(new ModelData("top_post_l"));
        MODELS.add(new ModelData("top_post_s"));
        MODELS.add(new ModelData("vine_top_bars"));
        MODELS.add(new ModelData("vine_top_beam_ew_dual"));
        MODELS.add(new ModelData("vine_top_beam_ew_single"));
        MODELS.add(new ModelData("vine_top_beam_ns_dual"));
        MODELS.add(new ModelData("vine_top_post_l"));
        MODELS.add(new ModelData("vine_top_post_s"));
        MODELS.add(new ModelData("fruit_top_hang_high").setRetexture());
        MODELS.add(new ModelData("fruit_top_hang_low").setRetexture());
        MODELS.add(new ModelData("wall_part_e", "wall_part_n", ModelRotation.X0_Y90));
        MODELS.add(new ModelData("wall_part_eb", "wall_part_nb", ModelRotation.X0_Y90));
        MODELS.add(new ModelData("wall_part_em", "wall_part_nm", ModelRotation.X0_Y90));
        MODELS.add(new ModelData("wall_part_et", "wall_part_nt", ModelRotation.X0_Y90));
        MODELS.add(new ModelData("wall_part_n"));
        MODELS.add(new ModelData("wall_part_nb"));
        MODELS.add(new ModelData("wall_part_nm"));
        MODELS.add(new ModelData("wall_part_nt"));
        MODELS.add(new ModelData("wall_part_p"));
        MODELS.add(new ModelData("wall_part_pb"));
        MODELS.add(new ModelData("wall_part_pt"));
        MODELS.add(new ModelData("wall_part_s"));
        MODELS.add(new ModelData("wall_part_sb"));
        MODELS.add(new ModelData("wall_part_sm"));
        MODELS.add(new ModelData("wall_part_st"));
        MODELS.add(new ModelData("wall_part_w", "wall_part_s", ModelRotation.X0_Y90));
        MODELS.add(new ModelData("wall_part_wb", "wall_part_sb", ModelRotation.X0_Y90));
        MODELS.add(new ModelData("wall_part_wm", "wall_part_sm", ModelRotation.X0_Y90));
        MODELS.add(new ModelData("wall_part_wt", "wall_part_st", ModelRotation.X0_Y90));
        MODELS.add(new ModelData("vine_wall_part_e", "vine_wall_part_n", ModelRotation.X0_Y90));
        MODELS.add(new ModelData("vine_wall_part_eb", "vine_wall_part_nb", ModelRotation.X0_Y90));
        MODELS.add(new ModelData("vine_wall_part_em", "vine_wall_part_nm", ModelRotation.X0_Y90));
        MODELS.add(new ModelData("vine_wall_part_et", "vine_wall_part_nt", ModelRotation.X0_Y90));
        MODELS.add(new ModelData("vine_wall_part_n"));
        MODELS.add(new ModelData("vine_wall_part_nb"));
        MODELS.add(new ModelData("vine_wall_part_nm"));
        MODELS.add(new ModelData("vine_wall_part_nt"));
        MODELS.add(new ModelData("vine_wall_part_p"));
        MODELS.add(new ModelData("vine_wall_part_pb"));
        MODELS.add(new ModelData("vine_wall_part_pt"));
        MODELS.add(new ModelData("vine_wall_part_s"));
        MODELS.add(new ModelData("vine_wall_part_sb"));
        MODELS.add(new ModelData("vine_wall_part_sm"));
        MODELS.add(new ModelData("vine_wall_part_st"));
        MODELS.add(new ModelData("vine_wall_part_w", "vine_wall_part_s", ModelRotation.X0_Y90));
        MODELS.add(new ModelData("vine_wall_part_wb", "vine_wall_part_sb", ModelRotation.X0_Y90));
        MODELS.add(new ModelData("vine_wall_part_wm", "vine_wall_part_sm", ModelRotation.X0_Y90));
        MODELS.add(new ModelData("vine_wall_part_wt", "vine_wall_part_st", ModelRotation.X0_Y90));
        MODELS.add(new ModelData("fruit_wall_part_e", "fruit_wall_part_n", ModelRotation.X0_Y90).setRetexture());
        MODELS.add(new ModelData("fruit_wall_part_n").setRetexture());
        MODELS.add(new ModelData("fruit_wall_part_s").setRetexture());
        MODELS.add(new ModelData("fruit_wall_part_w", "fruit_wall_part_s", ModelRotation.X0_Y90).setRetexture());
    }

    private static class ModelData {
        private final String name;
        private final ModelRotation rotation;
        private final ResourceLocation location;
        private boolean retexture = false;

        ModelData(String name) {
            this(name, name, ModelRotation.X0_Y0);
        }

        ModelData(String name, String model, ModelRotation rotation) {
            this.name = name;
            this.rotation = rotation;
            this.location = new ResourceLocation("terraqueous:block/pergola/" + model);
        }

        ModelData setRetexture() {
            this.retexture = true;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public ModelRotation getRotation() {
            return this.rotation;
        }

        ResourceLocation getLocation() {
            return this.location;
        }

        boolean doRetexture() {
            return this.retexture;
        }
    }
}

