/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous;

import com.google.common.base.Strings;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shetiphian.core.common.RegistryHelper;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.common.rgb16.TileEntityRGB16;
import shetiphian.core.common.tileentity.TileEntityExtendedRedstone;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.cloud.CloudAPI;
import shetiphian.terraqueous.api.machines.CapabilityStormForge;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.block.BlockBorder;
import shetiphian.terraqueous.common.block.BlockCloudFancy;
import shetiphian.terraqueous.common.block.BlockClouds;
import shetiphian.terraqueous.common.block.BlockCrafting;
import shetiphian.terraqueous.common.block.BlockDoodad;
import shetiphian.terraqueous.common.block.BlockEarthOre;
import shetiphian.terraqueous.common.block.BlockEnderTable;
import shetiphian.terraqueous.common.block.BlockFlowerPot;
import shetiphian.terraqueous.common.block.BlockFlowers;
import shetiphian.terraqueous.common.block.BlockHay;
import shetiphian.terraqueous.common.block.BlockPergola;
import shetiphian.terraqueous.common.block.BlockPlanks;
import shetiphian.terraqueous.common.block.BlockPlants;
import shetiphian.terraqueous.common.block.BlockTallGrass;
import shetiphian.terraqueous.common.block.BlockTreeFoliage;
import shetiphian.terraqueous.common.block.BlockTreeFoliageCB;
import shetiphian.terraqueous.common.block.BlockTreeSapling;
import shetiphian.terraqueous.common.block.BlockTreeTrunk;
import shetiphian.terraqueous.common.block.BlockTypeCloud;
import shetiphian.terraqueous.common.block.BlockTypeEarth;
import shetiphian.terraqueous.common.entity.EntityCloudPainting;
import shetiphian.terraqueous.common.entity.EntityCoconut;
import shetiphian.terraqueous.common.entity.EntityEarthPainting;
import shetiphian.terraqueous.common.item.ItemBlockBorder;
import shetiphian.terraqueous.common.item.ItemBlockCloudFancy;
import shetiphian.terraqueous.common.item.ItemBlockClouds;
import shetiphian.terraqueous.common.item.ItemBlockCrafting;
import shetiphian.terraqueous.common.item.ItemBlockDoodad;
import shetiphian.terraqueous.common.item.ItemBlockEarthOre;
import shetiphian.terraqueous.common.item.ItemBlockEnderTable;
import shetiphian.terraqueous.common.item.ItemBlockFlowerPot;
import shetiphian.terraqueous.common.item.ItemBlockFlowers;
import shetiphian.terraqueous.common.item.ItemBlockHay;
import shetiphian.terraqueous.common.item.ItemBlockPergola;
import shetiphian.terraqueous.common.item.ItemBlockPlanks;
import shetiphian.terraqueous.common.item.ItemBlockPlants;
import shetiphian.terraqueous.common.item.ItemBlockSapling;
import shetiphian.terraqueous.common.item.ItemBlockTreeFoliage;
import shetiphian.terraqueous.common.item.ItemBlockTreeFoliageCB;
import shetiphian.terraqueous.common.item.ItemBlockTreeTrunk;
import shetiphian.terraqueous.common.item.ItemBlockType;
import shetiphian.terraqueous.common.item.ItemBurniumBelt;
import shetiphian.terraqueous.common.item.ItemCloudStaff;
import shetiphian.terraqueous.common.item.ItemCloudTalisman;
import shetiphian.terraqueous.common.item.ItemColorizer;
import shetiphian.terraqueous.common.item.ItemEquipable;
import shetiphian.terraqueous.common.item.ItemHammer;
import shetiphian.terraqueous.common.item.ItemMain;
import shetiphian.terraqueous.common.item.ItemMultiFood;
import shetiphian.terraqueous.common.item.ItemMultiTool;
import shetiphian.terraqueous.common.item.ItemPitchfork;
import shetiphian.terraqueous.common.item.ItemScythe;
import shetiphian.terraqueous.common.item.ItemToonTrotters;
import shetiphian.terraqueous.common.item.ItemWaterPearl;
import shetiphian.terraqueous.common.misc.DeathFruitHelper;
import shetiphian.terraqueous.common.misc.FoodAction;
import shetiphian.terraqueous.common.misc.FoodData;
import shetiphian.terraqueous.common.potion.PotionDisplacement;
import shetiphian.terraqueous.common.potion.PotionFirewater;
import shetiphian.terraqueous.common.tileentity.TileEntityCloudCraftFurnace;
import shetiphian.terraqueous.common.tileentity.TileEntityCloudFurnace;
import shetiphian.terraqueous.common.tileentity.TileEntityCraftBench;
import shetiphian.terraqueous.common.tileentity.TileEntityCraftFurnace;
import shetiphian.terraqueous.common.tileentity.TileEntityDoodad;
import shetiphian.terraqueous.common.tileentity.TileEntityEnderTable;
import shetiphian.terraqueous.common.tileentity.TileEntityFlowerPot;
import shetiphian.terraqueous.common.tileentity.TileEntityPergolaFrame;
import shetiphian.terraqueous.common.tileentity.TileEntityPergolaGate;
import shetiphian.terraqueous.common.tileentity.TileEntityPergolaWall;
import shetiphian.terraqueous.common.tileentity.TileEntitySFController;
import shetiphian.terraqueous.common.tileentity.TileEntitySFStatic;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeColored;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeDoor;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeFancyArch;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeFancyEdge;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeFence;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeGate;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeSlab;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeStairs;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeTrapdoor;
import shetiphian.terraqueous.common.worldgen.GenClouds;
import shetiphian.terraqueous.common.worldgen.GenDoodads;
import shetiphian.terraqueous.common.worldgen.GenFlowers;
import shetiphian.terraqueous.common.worldgen.GenPlants;
import shetiphian.terraqueous.common.worldgen.GenTrees;
import shetiphian.terraqueous.common.worldgen.VillageHandler_Vineyard;

public class Registry {
    static Registry INSTANCE = new Registry();

    void registerBlocks(IForgeRegistry<Block> registry) {
        if (Configuration.BLOCKS.addBorders) {
            RegistryHelper.register(registry, (Block)new BlockBorder(), (String)"terraqueous:border", (String)"terraqueous.border");
            RegistryHelper.register(TileEntityRGB16.class, (String)"terraqueous:border.rgb16");
            RegistryHelper.register(TileEntityExtendedRedstone.class, (String)"terraqueous:border.speed");
        }
        if (Configuration.BLOCKS.addClouds) {
            Configuration.BLOCKS.addEnderTable = true;
            RegistryHelper.register(registry, (Block)new BlockCloudFancy(), (String)"terraqueous:cloudfancy", (String)"terraqueous.cloudfancy");
            RegistryHelper.register(registry, (Block)new BlockClouds(), (String)"terraqueous:clouds", (String)"terraqueous.clouds");
            RegistryHelper.register(TileEntityTypeFancyArch.class, (String)"terraqueous:cloudfancy.arch");
            RegistryHelper.register(TileEntityTypeFancyEdge.class, (String)"terraqueous:cloudfancy.edge");
        }
        if (Configuration.BLOCKS.addCraftables_Cloud) {
            RegistryHelper.register(registry, (Block)new BlockTypeCloud(), (String)"terraqueous:type_cloud", (String)"terraqueous.typecloud");
        }
        if (Configuration.BLOCKS.addCraftables_Wood) {
            RegistryHelper.register(registry, (Block)new BlockTypeEarth(), (String)"terraqueous:type_earth", (String)"terraqueous.typeearth");
        }
        if (Configuration.BLOCKS.addCraftables_Cloud || Configuration.BLOCKS.addCraftables_Wood) {
            RegistryHelper.register(TileEntityTypeDoor.class, (String)"terraqueous:type.door");
            RegistryHelper.register(TileEntityTypeTrapdoor.class, (String)"terraqueous:type.trapdoor");
            RegistryHelper.register(TileEntityTypeGate.class, (String)"terraqueous:type.gate");
            RegistryHelper.register(TileEntityTypeFence.class, (String)"terraqueous:type.fence");
            RegistryHelper.register(TileEntityTypeStairs.class, (String)"terraqueous:type.stairs");
            RegistryHelper.register(TileEntityTypeSlab.class, (String)"terraqueous:type.slab");
            RegistryHelper.register(TileEntityTypeColored.class, (String)"terraqueous:type.colored");
        }
        if (Configuration.BLOCKS.addCrafting) {
            RegistryHelper.register(registry, (Block)new BlockCrafting(), (String)"terraqueous:crafting", (String)"terraqueous.crafting");
            RegistryHelper.register(TileEntityCloudFurnace.class, (String)"terraqueous:crafting.cloudfurnace");
            RegistryHelper.register(TileEntityCraftBench.class, (String)"terraqueous:crafting.craftbench");
            RegistryHelper.register(TileEntityCraftFurnace.class, (String)"terraqueous:crafting.craftfurnace");
            RegistryHelper.register(TileEntityCloudCraftFurnace.class, (String)"terraqueous:crafting.craftfurnace.cloud");
            RegistryHelper.register(TileEntitySFController.class, (String)"terraqueous:stormforge.controller");
            RegistryHelper.register(TileEntitySFStatic.class, (String)"terraqueous:stormforge.static");
        }
        if (Configuration.BLOCKS.addDoodads) {
            RegistryHelper.register(registry, (Block)new BlockDoodad(), (String)"terraqueous:doodads", (String)"terraqueous.doodad");
            RegistryHelper.register(TileEntityDoodad.class, (String)"terraqueous:doodad.doodad");
        }
        if (Configuration.BLOCKS.addEnderTable) {
            RegistryHelper.register(registry, (Block)new BlockEnderTable(), (String)"terraqueous:ender_table", (String)"terraqueous.endertable");
            RegistryHelper.register(TileEntityEnderTable.class, (String)"terraqueous:endertable.table");
        }
        if (Configuration.BLOCKS.addFlowerPots) {
            RegistryHelper.register(registry, (Block)new BlockFlowerPot(), (String)"terraqueous:flowerpot", (String)"terraqueous.flowerpot");
            RegistryHelper.register(TileEntityFlowerPot.class, (String)"terraqueous:flowerpot.flowerpot");
        }
        if (Configuration.BLOCKS.addFlowers) {
            RegistryHelper.register(registry, (Block)new BlockFlowers(), (String)"terraqueous:flowers_cluster", (String)"terraqueous.flowercluster");
            RegistryHelper.register(registry, (Block)new BlockFlowers(), (String)"terraqueous:flowers_single", (String)"terraqueous.flowersingle");
        }
        if (Configuration.BLOCKS.addHayBlocks) {
            RegistryHelper.register(registry, (Block)new BlockHay(), (String)"terraqueous:hay", (String)"terraqueous.hay");
        }
        if (Configuration.BLOCKS.addOres) {
            RegistryHelper.register(registry, (Block)new BlockEarthOre(), (String)"terraqueous:earth_ore", (String)"terraqueous.earthore");
        }
        if (Configuration.BLOCKS.addPergolas) {
            RegistryHelper.register(registry, (Block)new BlockPergola(), (String)"terraqueous:pergola", (String)"terraqueous.pergola");
            RegistryHelper.register(TileEntityPergolaFrame.class, (String)"terraqueous:pergola.frame");
            RegistryHelper.register(TileEntityPergolaWall.class, (String)"terraqueous:pergola.wall");
            RegistryHelper.register(TileEntityPergolaGate.class, (String)"terraqueous:pergola.gate");
        }
        if (Configuration.BLOCKS.addPlants) {
            RegistryHelper.register(registry, (Block)new BlockPlants(), (String)"terraqueous:plants", (String)"terraqueous.plants");
        }
        if (Configuration.BLOCKS.addTallGrass) {
            RegistryHelper.register(registry, (Block)new BlockTallGrass(), (String)"terraqueous:tall_grass", (String)"terraqueous.tallgrass");
        }
        if (Configuration.BLOCKS.addTrees) {
            RegistryHelper.register(registry, (Block)new BlockPlanks(), (String)"terraqueous:planks", (String)"terraqueous.planks");
            RegistryHelper.register(registry, (Block)new BlockTreeSapling(), (String)"terraqueous:sapling", (String)"terraqueous.sapling");
            RegistryHelper.register(registry, (Block)new BlockTreeTrunk(0), (String)"terraqueous:trunk1", (String)"terraqueous.trunk");
            RegistryHelper.register(registry, (Block)new BlockTreeTrunk(1), (String)"terraqueous:trunk2", (String)"terraqueous.trunk");
            RegistryHelper.register(registry, (Block)new BlockTreeFoliage(0), (String)"terraqueous:foliage1", (String)"terraqueous.foliage");
            RegistryHelper.register(registry, (Block)new BlockTreeFoliage(1), (String)"terraqueous:foliage2", (String)"terraqueous.foliage");
            RegistryHelper.register(registry, (Block)new BlockTreeFoliage(2), (String)"terraqueous:foliage3", (String)"terraqueous.foliage");
            RegistryHelper.register(registry, (Block)new BlockTreeFoliage(3), (String)"terraqueous:foliage4", (String)"terraqueous.foliage");
            RegistryHelper.register(registry, (Block)new BlockTreeFoliageCB(), (String)"terraqueous:foliage5", (String)"terraqueous.foliage");
        }
    }

    void registerItemBlocks(IForgeRegistry<Item> registry) {
        if (Configuration.BLOCKS.addBorders) {
            RegistryHelper.register(registry, (ItemBlock)new ItemBlockBorder(Values.blockBorder));
        }
        if (Configuration.BLOCKS.addClouds) {
            RegistryHelper.register(registry, (ItemBlock)new ItemBlockCloudFancy(Values.blockCloudFancy));
            RegistryHelper.register(registry, (ItemBlock)new ItemBlockClouds(Values.blockClouds));
        }
        if (Configuration.BLOCKS.addCraftables_Cloud) {
            RegistryHelper.register(registry, (ItemBlock)new ItemBlockType(Values.blockTypeCloud));
        }
        if (Configuration.BLOCKS.addCraftables_Wood) {
            RegistryHelper.register(registry, (ItemBlock)new ItemBlockType(Values.blockTypeEarth));
        }
        if (Configuration.BLOCKS.addCrafting) {
            RegistryHelper.register(registry, (ItemBlock)new ItemBlockCrafting(Values.blockCrafting));
        }
        if (Configuration.BLOCKS.addDoodads) {
            RegistryHelper.register(registry, (ItemBlock)new ItemBlockDoodad(Values.blockDoodad));
        }
        if (Configuration.BLOCKS.addEnderTable || Configuration.BLOCKS.addClouds) {
            RegistryHelper.register(registry, (ItemBlock)new ItemBlockEnderTable(Values.blockEnderTable));
        }
        if (Configuration.BLOCKS.addFlowerPots) {
            RegistryHelper.register(registry, (ItemBlock)new ItemBlockFlowerPot(Values.blockFlowerPot));
        }
        if (Configuration.BLOCKS.addFlowers) {
            RegistryHelper.register(registry, (ItemBlock)new ItemBlockFlowers(Values.blockFlowerCluster));
            RegistryHelper.register(registry, (ItemBlock)new ItemBlockFlowers(Values.blockFlowerSingle));
        }
        if (Configuration.BLOCKS.addHayBlocks) {
            RegistryHelper.register(registry, (ItemBlock)new ItemBlockHay(Values.blockHay));
        }
        if (Configuration.BLOCKS.addOres) {
            RegistryHelper.register(registry, (ItemBlock)new ItemBlockEarthOre(Values.blockEarthOre));
        }
        if (Configuration.BLOCKS.addPergolas) {
            RegistryHelper.register(registry, (ItemBlock)new ItemBlockPergola(Values.blockPergola));
        }
        if (Configuration.BLOCKS.addPlants) {
            RegistryHelper.register(registry, (ItemBlock)new ItemBlockPlants(Values.blockPlants));
        }
        if (Configuration.BLOCKS.addTrees) {
            RegistryHelper.register(registry, (ItemBlock)new ItemBlockPlanks(Values.blockPlanks));
            RegistryHelper.register(registry, (ItemBlock)new ItemBlockSapling(Values.blockSapling));
            RegistryHelper.register(registry, (ItemBlock)new ItemBlockTreeTrunk(Values.blockTreeTrunk1, 0));
            RegistryHelper.register(registry, (ItemBlock)new ItemBlockTreeTrunk(Values.blockTreeTrunk2, 1));
            RegistryHelper.register(registry, (ItemBlock)new ItemBlockTreeFoliage(Values.blockTreeFoliage1, 0));
            RegistryHelper.register(registry, (ItemBlock)new ItemBlockTreeFoliage(Values.blockTreeFoliage2, 1));
            RegistryHelper.register(registry, (ItemBlock)new ItemBlockTreeFoliage(Values.blockTreeFoliage3, 2));
            RegistryHelper.register(registry, (ItemBlock)new ItemBlockTreeFoliage(Values.blockTreeFoliage4, 3));
            RegistryHelper.register(registry, (ItemBlock)new ItemBlockTreeFoliageCB(Values.blockTreeFoliageCB));
        }
    }

    void registerItems(IForgeRegistry<Item> registry) {
        RegistryHelper.register(registry, (Item)new ItemMain(), (String)"terraqueous:item_main", (String)"terraqueous.itemmain");
        if (Configuration.ITEMS.addBurniumBelt) {
            RegistryHelper.register(registry, (Item)new ItemBurniumBelt(), (String)"terraqueous:burnium_belt", (String)"terraqueous.burnium_belt");
        }
        if (Configuration.BLOCKS.addClouds) {
            RegistryHelper.register(registry, (Item)new ItemCloudStaff(), (String)"terraqueous:cloud_staff", (String)"terraqueous.cloudstaff");
            RegistryHelper.register(registry, (Item)new ItemCloudTalisman(), (String)"terraqueous:cloud_talisman", (String)"terraqueous.cloudtalisman");
            CloudAPI.addCloudWalkItem("terraqueous:cloud_talisman", Short.MAX_VALUE);
        }
        if (Configuration.BLOCKS.addEnderTable) {
            RegistryHelper.register(registry, (Item)new ItemEquipable("EnderMonocle", EntityEquipmentSlot.HEAD), (String)"terraqueous:ender_monocle", (String)"terraqueous.endermonocle");
        }
        if (Configuration.ITEMS.addFood) {
            ArrayList<FoodData> foodList = new ArrayList<FoodData>();
            foodList.add(new FoodData("cherry").setHealAmount(2).setSaturationModifier(0.3f).setDietInfo(true, true, false, false, false));
            foodList.add(new FoodData("orange").setHealAmount(4).setSaturationModifier(0.3f).setDietInfo(true, true, false, false, false));
            foodList.add(new FoodData("pear").setHealAmount(3).setSaturationModifier(0.3f).setDietInfo(true, true, false, false, false));
            foodList.add(new FoodData("peach").setHealAmount(3).setSaturationModifier(0.3f).setDietInfo(true, true, false, false, false));
            foodList.add(new FoodData("mango").setHealAmount(3).setSaturationModifier(0.3f).setDietInfo(true, true, false, false, false));
            foodList.add(new FoodData("lemon").setHealAmount(3).setSaturationModifier(0.3f).setDietInfo(true, true, false, false, false));
            foodList.add(new FoodData("plum").setHealAmount(3).setSaturationModifier(0.3f).setDietInfo(true, true, false, false, false));
            foodList.add(new FoodData("coconut").setHealAmount(5).setSaturationModifier(0.4f).setDietInfo(true, true, false, false, false).setDamage(Values.damageCoconut, 1.0f).setFoodUseAction(new FoodAction.FoodActionSpawnEntity(EntityCoconut.class)));
            foodList.add(new FoodData("banana").setHealAmount(3).setSaturationModifier(0.3f).setDietInfo(true, true, false, false, false));
            foodList.add(new FoodData("pineapple").setHealAmount(5).setSaturationModifier(0.3f).setDietInfo(true, true, false, false, false).setFoodUseAction(new FoodAction.FoodActionPlaceBlock(BlockPlants.EnumType.PINEAPPLE_SMALL.state(), new EnumFacing[0])));
            foodList.add(new FoodData("pricklypear").setHealAmount(3).setSaturationModifier(0.3f).setDietInfo(true, true, false, false, false));
            foodList.add(new FoodData("grapes").setHealAmount(2).setSaturationModifier(0.3f).setDietInfo(true, true, false, false, false));
            foodList.add(new FoodData("lifefruit").setHealAmount(2).setSaturationModifier(0.0f).setDietInfo(true, true, true, true, false).setAlwaysEdible(true).setStackLimit(8).setFoodFinishAction(new FoodActionLifeFruit()));
            foodList.add(new FoodData("deathfruit").setHealAmount(0).setSaturationModifier(0.0f).setDietInfo(true, true, true, true, false).setAlwaysEdible(true).setStackLimit(8).setFoodFinishAction(new FoodActionDeathFruit()).setTooltip("info.terraqueous.deathfruit.txt"));
            RegistryHelper.register(registry, (Item)new ItemMultiFood(foodList), (String)"terraqueous:multifood", (String)"terraqueous.multifood");
        }
        if (Configuration.ITEMS.addTools) {
            RegistryHelper.register(registry, (Item)new ItemColorizer(), (String)"terraqueous:colorizer", (String)"terraqueous.colorizer");
            RegistryHelper.register(registry, (Item)new ItemHammer(), (String)"terraqueous:hammer", (String)"terraqueous.itemhammer");
            RegistryHelper.register(registry, (Item)new ItemMultiTool(), (String)"terraqueous:multitool", (String)"terraqueous.multitool");
            RegistryHelper.register(registry, (Item)new ItemPitchfork(), (String)"terraqueous:pitchfork", (String)"terraqueous.pitchfork");
            RegistryHelper.register(registry, (Item)new ItemScythe(), (String)"terraqueous:scythe", (String)"terraqueous.scythe");
        }
        if (Configuration.ITEMS.addToonTrotters) {
            RegistryHelper.register(registry, (Item)new ItemToonTrotters(), (String)"terraqueous:toon_trotters", (String)"terraqueous.toon_trotters");
        }
        if (Configuration.ITEMS.addWaterPearl) {
            RegistryHelper.register(registry, (Item)new ItemWaterPearl(), (String)"terraqueous:water_pearl", (String)"terraqueous.water_pearl");
        }
    }

    void registerPotionTypes(IForgeRegistry<PotionType> registry) {
        PotionFirewater firewater = new PotionFirewater();
        RegistryHelper.registerPotion((Potion)firewater, (String)"terraqueous:firewater");
        PotionType type = new PotionType("firewater", new PotionEffect[]{new PotionEffect((Potion)firewater, 1)});
        type.setRegistryName("terraqueous:firewater");
        registry.register((IForgeRegistryEntry)type);
        PotionDisplacement displacement = new PotionDisplacement();
        RegistryHelper.registerPotion((Potion)displacement, (String)"terraqueous:displacement");
        type = new PotionType("displacement", new PotionEffect[]{new PotionEffect((Potion)displacement, 1)});
        type.setRegistryName("terraqueous:displacement");
        registry.register((IForgeRegistryEntry)type);
    }

    void doRegistration() {
        this.registerEntities();
        this.registerSounds();
        this.setTabIcon();
        this.registerWorldGenerators();
        this.registerCustomRecipeTypes();
        this.registerCustomItemStacks();
        this.registerOreDictionaryEntries();
        CapabilityStormForge.register();
    }

    private void registerEntities() {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("terraqueous", "paintingearth"), EntityEarthPainting.class, (String)"paintingearth", (int)0, (Object)Terraqueous.INSTANCE, (int)160, (int)Integer.MAX_VALUE, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("terraqueous", "paintingcloud"), EntityCloudPainting.class, (String)"paintingcloud", (int)1, (Object)Terraqueous.INSTANCE, (int)160, (int)Integer.MAX_VALUE, (boolean)false);
        if (Configuration.ITEMS.addFood) {
            EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("terraqueous", "coconut"), EntityCoconut.class, (String)"coconut", (int)2, (Object)Terraqueous.INSTANCE, (int)160, (int)Integer.MAX_VALUE, (boolean)true);
        }
    }

    private void registerSounds() {
        Values.soundArc = RegistryHelper.registerSound((String)"terraqueous:arc");
        Values.soundSpark = RegistryHelper.registerSound((String)"terraqueous:spark");
        Values.soundHammer = RegistryHelper.registerSound((String)"terraqueous:hammer");
    }

    private void setTabIcon() {
        if (Values.itemMain != null) {
            Values.tabTerraqueous.setIcon(new ItemStack(Values.itemMain, 1, 477));
            return;
        }
        if (Values.blockFlowerSingle != null) {
            Values.tabTerraqueous.setIcon(new ItemStack(Values.blockFlowerSingle, 1, 4));
            return;
        }
        if (Values.blockPlants != null) {
            Values.tabTerraqueous.setIcon(new ItemStack(Values.blockPlants, 1, 5));
        }
    }

    private void registerWorldGenerators() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new GenClouds(), (int)10);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new GenDoodads(), (int)3);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new GenFlowers(), (int)1);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new GenPlants(), (int)1);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new GenTrees(), (int)2);
        GenTrees.setTreesActive();
        new GenFlowers().registerForBonemeal();
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageHandler_Vineyard());
    }

    private void registerCustomRecipeTypes() {
    }

    private void registerCustomItemStacks() {
        if (Values.blockCloudFancy != null) {
            Values.stacks.put("cloud_column", this.iStack(Values.blockCloudFancy, 1));
            Values.stacks.put("cloud_capital", this.iStack(Values.blockCloudFancy, 3));
            Values.stacks.put("cloud_arch", this.iStack(Values.blockCloudFancy, 4));
            Values.stacks.put("cloud_edge", this.iStack(Values.blockCloudFancy, 5));
        }
        if (Values.blockClouds != null) {
            Values.stacks.put("lightcloud_block", this.iStack(Values.blockClouds, 0));
            Values.stacks.put("densecloud_block", this.iStack(Values.blockClouds, 1));
            Values.stacks.put("stormcloud_block", this.iStack(Values.blockClouds, 2));
            Values.stacks.put("kickable_lightcloud_block", this.iStack(Values.blockClouds, 8));
            Values.stacks.put("kickable_densecloud_block", this.iStack(Values.blockClouds, 9));
            Values.stacks.put("kickable_stormcloud_block", this.iStack(Values.blockClouds, 10));
        }
        if (Values.blockCrafting != null) {
            Values.stacks.put("cloud_workbench", this.iStack(Values.blockCrafting, 0));
            Values.stacks.put("cloud_furnace", this.iStack(Values.blockCrafting, 1));
            Values.stacks.put("cloud_craftbench", this.iStack(Values.blockCrafting, 2));
            Values.stacks.put("cloud_craftfurnace", this.iStack(Values.blockCrafting, 3));
            Values.stacks.put("craftbench", this.iStack(Values.blockCrafting, 5));
            Values.stacks.put("craftfurnace", this.iStack(Values.blockCrafting, 6));
        }
        if (Values.blockDoodad != null) {
            Values.stacks.put("glass_shards", this.iStack(Values.blockDoodad, 6));
        }
        if (Values.blockEarthOre != null) {
            Values.stacks.put("endimium_ore", this.iStack(Values.blockEarthOre, 0));
            Values.stacks.put("burnium_ore", this.iStack(Values.blockEarthOre, 1));
            Values.stacks.put("endimium_block", this.iStack(Values.blockEarthOre, 3));
            Values.stacks.put("burnium_block", this.iStack(Values.blockEarthOre, 4));
        }
        if (Values.blockFlowerPot != null) {
            Values.stacks.put("flowerpot", this.iStackColored(Values.blockFlowerPot, 0, RGB16Helper.getIndexFor((int)10, (int)5, (int)4)));
            Values.stacks.put("planterpot", this.iStackColored(Values.blockFlowerPot, 1, RGB16Helper.getIndexFor((int)10, (int)5, (int)4)));
        }
        if (Values.blockHay != null) {
            Values.stacks.put("hayblock", this.iStack(Values.blockHay, 0));
            Values.stacks.put("haypile_large", this.iStack(Values.blockHay, 1));
            Values.stacks.put("haypile", this.iStack(Values.blockHay, 2));
            Values.stacks.put("haypile_small", this.iStack(Values.blockHay, 3));
            Values.stacks.put("thresh", this.iStack(Values.blockHay, 4));
            Values.stacks.put("loosehay", this.iStack(Values.blockHay, 5));
        }
        if (Values.blockPergola != null) {
            Values.stacks.put("pergolatop", this.iStackColored(Values.blockPergola, 0, RGB16Helper.getIndexFor((String)"dyeWhite")));
            Values.stacks.put("pergolawall", this.iStackColored(Values.blockPergola, 7, RGB16Helper.getIndexFor((String)"dyeWhite")));
            Values.stacks.put("pergolagate", this.iStackColored(Values.blockPergola, 8, RGB16Helper.getIndexFor((String)"dyeWhite")));
        }
        if (Values.blockPlants != null) {
            Values.stacks.put("cactus", this.iStack(Values.blockPlants, 3));
            Values.stacks.put("cactus_large", this.iStack(Values.blockPlants, 4));
            Values.stacks.put("cactus_fruit", this.iStack(Values.blockPlants, 5));
        }
        if (GenTrees.treesActive) {
            Values.stacks.put("apple_sapling", this.iStack(Values.blockSapling, 0));
            Values.stacks.put("cherry_sapling", this.iStack(Values.blockSapling, 1));
            Values.stacks.put("orange_sapling", this.iStack(Values.blockSapling, 2));
            Values.stacks.put("pear_sapling", this.iStack(Values.blockSapling, 3));
            Values.stacks.put("peach_sapling", this.iStack(Values.blockSapling, 4));
            Values.stacks.put("mango_sapling", this.iStack(Values.blockSapling, 5));
            Values.stacks.put("lemon_sapling", this.iStack(Values.blockSapling, 6));
            Values.stacks.put("plum_sapling", this.iStack(Values.blockSapling, 7));
            Values.stacks.put("coconut_sapling", this.iStack(Values.blockSapling, 8));
            Values.stacks.put("banana_sapling", this.iStack(Values.blockSapling, 9));
            Values.stacks.put("apple_planks", this.iStack(Values.blockPlanks, 0));
            Values.stacks.put("cherry_planks", this.iStack(Values.blockPlanks, 1));
            Values.stacks.put("orange_planks", this.iStack(Values.blockPlanks, 2));
            Values.stacks.put("pear_planks", this.iStack(Values.blockPlanks, 3));
            Values.stacks.put("peach_planks", this.iStack(Values.blockPlanks, 4));
            Values.stacks.put("mango_planks", this.iStack(Values.blockPlanks, 5));
            Values.stacks.put("lemon_planks", this.iStack(Values.blockPlanks, 6));
            Values.stacks.put("plum_planks", this.iStack(Values.blockPlanks, 7));
            Values.stacks.put("coconut_planks", this.iStack(Values.blockPlanks, 8));
            Values.stacks.put("banana_planks", this.iStack(Values.blockPlanks, 9));
            Values.stacks.put("apple_log", this.iStack(Values.blockTreeTrunk1, 0));
            Values.stacks.put("cherry_log", this.iStack(Values.blockTreeTrunk1, 1));
            Values.stacks.put("orange_log", this.iStack(Values.blockTreeTrunk1, 2));
            Values.stacks.put("pear_log", this.iStack(Values.blockTreeTrunk1, 3));
            Values.stacks.put("peach_log", this.iStack(Values.blockTreeTrunk1, 4));
            Values.stacks.put("mango_log", this.iStack(Values.blockTreeTrunk2, 0));
            Values.stacks.put("lemon_log", this.iStack(Values.blockTreeTrunk2, 1));
            Values.stacks.put("plum_log", this.iStack(Values.blockTreeTrunk2, 2));
            Values.stacks.put("coconut_log", this.iStack(Values.blockTreeTrunk2, 3));
            Values.stacks.put("banana_log", this.iStack(Values.blockTreeTrunk2, 4));
            Values.stacks.put("apple_leaves", this.iStack(Values.blockTreeFoliage1, 0));
            Values.stacks.put("cherry_leaves", this.iStack(Values.blockTreeFoliage1, 4));
            Values.stacks.put("orange_leaves", this.iStack(Values.blockTreeFoliage2, 0));
            Values.stacks.put("pear_leaves", this.iStack(Values.blockTreeFoliage2, 4));
            Values.stacks.put("peach_leaves", this.iStack(Values.blockTreeFoliage3, 0));
            Values.stacks.put("mango_leaves", this.iStack(Values.blockTreeFoliage3, 4));
            Values.stacks.put("lemon_leaves", this.iStack(Values.blockTreeFoliage4, 0));
            Values.stacks.put("plum_leaves", this.iStack(Values.blockTreeFoliage4, 4));
            Values.stacks.put("coconut_leaves", this.iStack(Values.blockTreeFoliageCB, 0));
            Values.stacks.put("banana_leaves", this.iStack(Values.blockTreeFoliageCB, 4));
        }
        if (Values.blockTypeCloud != null) {
            Values.stacks.put("lightcloud_door", this.iStack(Values.blockTypeCloud, 0));
            Values.stacks.put("densecloud_door", this.iStack(Values.blockTypeCloud, 1));
            Values.stacks.put("stormcloud_door", this.iStack(Values.blockTypeCloud, 2));
            Values.stacks.put("lightcloud_trapdoor", this.iStack(Values.blockTypeCloud, 10));
            Values.stacks.put("densecloud_trapdoor", this.iStack(Values.blockTypeCloud, 11));
            Values.stacks.put("stormcloud_trapdoor", this.iStack(Values.blockTypeCloud, 12));
            Values.stacks.put("lightcloud_gate", this.iStack(Values.blockTypeCloud, 20));
            Values.stacks.put("densecloud_gate", this.iStack(Values.blockTypeCloud, 21));
            Values.stacks.put("stormcloud_gate", this.iStack(Values.blockTypeCloud, 22));
            Values.stacks.put("lightcloud_wall", this.iStack(Values.blockTypeCloud, 30));
            Values.stacks.put("densecloud_wall", this.iStack(Values.blockTypeCloud, 31));
            Values.stacks.put("stormcloud_wall", this.iStack(Values.blockTypeCloud, 32));
            Values.stacks.put("lightcloud_stairs", this.iStack(Values.blockTypeCloud, 40));
            Values.stacks.put("densecloud_stairs", this.iStack(Values.blockTypeCloud, 41));
            Values.stacks.put("stormcloud_stairs", this.iStack(Values.blockTypeCloud, 42));
            Values.stacks.put("lightcloud_slab", this.iStack(Values.blockTypeCloud, 50));
            Values.stacks.put("densecloud_slab", this.iStack(Values.blockTypeCloud, 51));
            Values.stacks.put("stormcloud_slab", this.iStack(Values.blockTypeCloud, 52));
            Values.stacks.put("water_vapor", this.iStackColored(Values.blockTypeCloud, 110, RGB16Helper.getIndexFor((String)"dyeBlue")));
            Values.stacks.put("glow_vapor", this.iStackColored(Values.blockTypeCloud, 120, RGB16Helper.getIndexFor((String)"dyeBlue")));
        }
        if (Values.blockTypeEarth != null) {
            Values.stacks.put("applewood_door", this.iStack(Values.blockTypeEarth, 0));
            Values.stacks.put("cherrywood_door", this.iStack(Values.blockTypeEarth, 1));
            Values.stacks.put("orangewood_door", this.iStack(Values.blockTypeEarth, 2));
            Values.stacks.put("pearwood_door", this.iStack(Values.blockTypeEarth, 3));
            Values.stacks.put("peachwood_door", this.iStack(Values.blockTypeEarth, 4));
            Values.stacks.put("mangowood_door", this.iStack(Values.blockTypeEarth, 5));
            Values.stacks.put("lemonwood_door", this.iStack(Values.blockTypeEarth, 6));
            Values.stacks.put("plumwood_door", this.iStack(Values.blockTypeEarth, 7));
            Values.stacks.put("coconutwood_door", this.iStack(Values.blockTypeEarth, 8));
            Values.stacks.put("bananawood_door", this.iStack(Values.blockTypeEarth, 9));
            Values.stacks.put("applewood_trapdoor", this.iStack(Values.blockTypeEarth, 10));
            Values.stacks.put("cherrywood_trapdoor", this.iStack(Values.blockTypeEarth, 11));
            Values.stacks.put("orangewood_trapdoor", this.iStack(Values.blockTypeEarth, 12));
            Values.stacks.put("pearwood_trapdoor", this.iStack(Values.blockTypeEarth, 13));
            Values.stacks.put("peachwood_trapdoor", this.iStack(Values.blockTypeEarth, 14));
            Values.stacks.put("mangowood_trapdoor", this.iStack(Values.blockTypeEarth, 15));
            Values.stacks.put("lemonwood_trapdoor", this.iStack(Values.blockTypeEarth, 16));
            Values.stacks.put("plumwood_trapdoor", this.iStack(Values.blockTypeEarth, 17));
            Values.stacks.put("coconutwood_trapdoor", this.iStack(Values.blockTypeEarth, 18));
            Values.stacks.put("bananawood_trapdoor", this.iStack(Values.blockTypeEarth, 19));
            Values.stacks.put("applewood_gate", this.iStack(Values.blockTypeEarth, 20));
            Values.stacks.put("cherrywood_gate", this.iStack(Values.blockTypeEarth, 21));
            Values.stacks.put("orangewood_gate", this.iStack(Values.blockTypeEarth, 22));
            Values.stacks.put("pearwood_gate", this.iStack(Values.blockTypeEarth, 23));
            Values.stacks.put("peachwood_gate", this.iStack(Values.blockTypeEarth, 24));
            Values.stacks.put("mangowood_gate", this.iStack(Values.blockTypeEarth, 25));
            Values.stacks.put("lemonwood_gate", this.iStack(Values.blockTypeEarth, 26));
            Values.stacks.put("plumwood_gate", this.iStack(Values.blockTypeEarth, 27));
            Values.stacks.put("coconutwood_gate", this.iStack(Values.blockTypeEarth, 28));
            Values.stacks.put("bananawood_gate", this.iStack(Values.blockTypeEarth, 29));
            Values.stacks.put("applewood_fence", this.iStack(Values.blockTypeEarth, 30));
            Values.stacks.put("cherrywood_fence", this.iStack(Values.blockTypeEarth, 31));
            Values.stacks.put("orangewood_fence", this.iStack(Values.blockTypeEarth, 32));
            Values.stacks.put("pearwood_fence", this.iStack(Values.blockTypeEarth, 33));
            Values.stacks.put("peachwood_fence", this.iStack(Values.blockTypeEarth, 34));
            Values.stacks.put("mangowood_fence", this.iStack(Values.blockTypeEarth, 35));
            Values.stacks.put("lemonwood_fence", this.iStack(Values.blockTypeEarth, 36));
            Values.stacks.put("plumwood_fence", this.iStack(Values.blockTypeEarth, 37));
            Values.stacks.put("coconutwood_fence", this.iStack(Values.blockTypeEarth, 38));
            Values.stacks.put("bananawood_fence", this.iStack(Values.blockTypeEarth, 39));
            Values.stacks.put("applewood_stairs", this.iStack(Values.blockTypeEarth, 40));
            Values.stacks.put("cherrywood_stairs", this.iStack(Values.blockTypeEarth, 41));
            Values.stacks.put("orangewood_stairs", this.iStack(Values.blockTypeEarth, 42));
            Values.stacks.put("pearwood_stairs", this.iStack(Values.blockTypeEarth, 43));
            Values.stacks.put("peachwood_stairs", this.iStack(Values.blockTypeEarth, 44));
            Values.stacks.put("mangowood_stairs", this.iStack(Values.blockTypeEarth, 45));
            Values.stacks.put("lemonwood_stairs", this.iStack(Values.blockTypeEarth, 46));
            Values.stacks.put("plumwood_stairs", this.iStack(Values.blockTypeEarth, 47));
            Values.stacks.put("coconutwood_stairs", this.iStack(Values.blockTypeEarth, 48));
            Values.stacks.put("bananawood_stairs", this.iStack(Values.blockTypeEarth, 49));
            Values.stacks.put("applewood_slab", this.iStack(Values.blockTypeEarth, 50));
            Values.stacks.put("cherrywood_slab", this.iStack(Values.blockTypeEarth, 51));
            Values.stacks.put("orangewood_slab", this.iStack(Values.blockTypeEarth, 52));
            Values.stacks.put("pearwood_slab", this.iStack(Values.blockTypeEarth, 53));
            Values.stacks.put("peachwood_slab", this.iStack(Values.blockTypeEarth, 54));
            Values.stacks.put("mangowood_slab", this.iStack(Values.blockTypeEarth, 55));
            Values.stacks.put("lemonwood_slab", this.iStack(Values.blockTypeEarth, 56));
            Values.stacks.put("plumwood_slab", this.iStack(Values.blockTypeEarth, 57));
            Values.stacks.put("coconutwood_slab", this.iStack(Values.blockTypeEarth, 58));
            Values.stacks.put("bananawood_slab", this.iStack(Values.blockTypeEarth, 59));
            Values.stacks.put("paper_block", this.iStackColored(Values.blockTypeEarth, 110, RGB16Helper.getIndexFor((String)"dyeWhite")));
            Values.stacks.put("glow_paper", this.iStackColored(Values.blockTypeEarth, 120, RGB16Helper.getIndexFor((String)"dyeWhite")));
        }
        if (Values.itemCloudStaff != null) {
            Values.stacks.put("cloud_staff", ItemCloudStaff.newTool(ItemCloudStaff.EnumMode.LIGHT, false));
        }
        if (Values.itemColorizer != null) {
            Values.stacks.put("colorizer", this.iStack(Values.itemColorizer, 0));
            Values.stacks.put("colorizer_empty", this.iStack(Values.itemColorizer, 255));
        }
        if (Values.itemHammer != null) {
            Values.stacks.put("hammer", this.iStack(Values.itemHammer, 0));
        }
        if (Values.itemMultiFood != null) {
            Values.stacks.put("cherry", this.iStack(Values.itemMultiFood, 0));
            Values.stacks.put("orange", this.iStack(Values.itemMultiFood, 1));
            Values.stacks.put("pear", this.iStack(Values.itemMultiFood, 2));
            Values.stacks.put("peach", this.iStack(Values.itemMultiFood, 3));
            Values.stacks.put("mango", this.iStack(Values.itemMultiFood, 4));
            Values.stacks.put("lemon", this.iStack(Values.itemMultiFood, 5));
            Values.stacks.put("plum", this.iStack(Values.itemMultiFood, 6));
            Values.stacks.put("coconut", this.iStack(Values.itemMultiFood, 7));
            Values.stacks.put("banana", this.iStack(Values.itemMultiFood, 8));
            Values.stacks.put("pineapple", this.iStack(Values.itemMultiFood, 9));
            Values.stacks.put("pricklypear", this.iStack(Values.itemMultiFood, 10));
            Values.stacks.put("grapes", this.iStack(Values.itemMultiFood, 11));
            Values.stacks.put("lifefruit", this.iStack(Values.itemMultiFood, 12));
            Values.stacks.put("deathfruit", this.iStack(Values.itemMultiFood, 13));
        }
        if (Values.itemMultiTool != null) {
            Values.stacks.put("multitool", ItemMultiTool.newTool(ItemMultiTool.EnumType.PICKAXE));
        }
        if (Values.itemScythe != null) {
            Values.stacks.put("scythe", ItemScythe.newScythe(false));
            Values.stacks.put("sickle", ItemScythe.newScythe(true));
        }
        Values.stacks.put("paintbrush", this.iStack(Values.itemMain, 0));
        Values.stacks.put("painting_cloud", this.iStack(Values.itemMain, 1));
        Values.stacks.put("painting", this.iStack(Values.itemMain, 2));
        Values.stacks.put("talisman_unbaked", this.iStack(Values.itemMain, 3));
        Values.stacks.put("talisman_baked", this.iStack(Values.itemMain, 4));
        Values.stacks.put("talisman_assembled", this.iStack(Values.itemMain, 5));
        Values.stacks.put("burnium_gem", this.iStack(Values.itemMain, 50));
        Values.stacks.put("endimium_gem", this.iStack(Values.itemMain, 51));
        Values.stacks.put("leather_scraps", this.iStack(Values.itemMain, 100));
        Values.stacks.put("leather_boot1", this.iStack(Values.itemMain, 101));
        Values.stacks.put("leather_boot2", this.iStack(Values.itemMain, 102));
        Values.stacks.put("leather_belt", this.iStack(Values.itemMain, 103));
        Values.stacks.put("dye_black", this.iStack(Values.itemMain, 104));
        Values.stacks.put("dye_brown", this.iStack(Values.itemMain, 105));
        Values.stacks.put("dye_blue", this.iStack(Values.itemMain, 106));
        Values.stacks.put("dye_white", this.iStack(Values.itemMain, 107));
        Values.stacks.put("glass_shard", this.iStack(Values.itemMain, 108));
        Values.stacks.put("ender_book", this.iStack(Values.itemMain, 109));
        Values.stacks.put("ender_tinydust", this.iStack(Values.itemMain, 200));
        Values.stacks.put("ender_dust", this.iStack(Values.itemMain, 201));
        Values.stacks.put("iron_tinydust", this.iStack(Values.itemMain, 202));
        Values.stacks.put("iron_dust", this.iStack(Values.itemMain, 203));
        Values.stacks.put("gold_tinydust", this.iStack(Values.itemMain, 204));
        Values.stacks.put("gold_dust", this.iStack(Values.itemMain, 205));
        Values.stacks.put("coal_tinydust", this.iStack(Values.itemMain, 206));
        Values.stacks.put("coal_dust", this.iStack(Values.itemMain, 207));
        Values.stacks.put("diamond_tinydust", this.iStack(Values.itemMain, 208));
        Values.stacks.put("diamond_dust", this.iStack(Values.itemMain, 209));
        Values.stacks.put("emerald_tinydust", this.iStack(Values.itemMain, 210));
        Values.stacks.put("emerald_dust", this.iStack(Values.itemMain, 211));
        Values.stacks.put("lapis_tinydust", this.iStack(Values.itemMain, 212));
        Values.stacks.put("redstone_tinydust", this.iStack(Values.itemMain, 213));
        Values.stacks.put("sandstone_lump", this.iStack(Values.itemMain, 214));
        Values.stacks.put("gravel_lump", this.iStack(Values.itemMain, 215));
        Values.stacks.put("redsandstone_lump", this.iStack(Values.itemMain, 216));
        Values.stacks.put("burnium_tinydust", this.iStack(Values.itemMain, 250));
        Values.stacks.put("burnium_dust", this.iStack(Values.itemMain, 251));
        Values.stacks.put("endimium_tinydust", this.iStack(Values.itemMain, 252));
        Values.stacks.put("endimium_dust", this.iStack(Values.itemMain, 253));
        Values.stacks.put("scroll_strange", this.iStack(Values.itemMain, 477));
        Values.stacks.put("turtle_colorizer", this.iStack(Values.itemMain, 1000));
        Values.stacks.put("turtle_colorizer_right", this.iStack(Values.itemMain, 1001));
        Values.stacks.put("robot_colorizer", this.iStack(Values.itemMain, 1002));
    }

    private void registerOreDictionaryEntries() {
        if (Values.blockEarthOre != null) {
            this.registerToOreDictionary("oreEndimium", "endimium_ore");
            this.registerToOreDictionary("oreBurnium", "burnium_ore");
            this.registerToOreDictionary("blockEndimium", "endimium_block");
            this.registerToOreDictionary("blockBurnium", "burnium_block");
        }
        if (GenTrees.treesActive) {
            this.registerToOreDictionary("treeSapling", new ItemStack(Values.blockSapling, 1, Short.MAX_VALUE));
            this.registerToOreDictionary("plankWood", new ItemStack(Values.blockPlanks, 1, Short.MAX_VALUE));
            this.registerToOreDictionary("logWood", new ItemStack(Values.blockTreeTrunk1, 1, Short.MAX_VALUE));
            this.registerToOreDictionary("logWood", new ItemStack(Values.blockTreeTrunk2, 1, Short.MAX_VALUE));
            this.registerToOreDictionary("treeLeaves", new ItemStack(Values.blockTreeFoliage1, 1, Short.MAX_VALUE));
            this.registerToOreDictionary("treeLeaves", new ItemStack(Values.blockTreeFoliage2, 2, Short.MAX_VALUE));
            this.registerToOreDictionary("treeLeaves", new ItemStack(Values.blockTreeFoliage3, 3, Short.MAX_VALUE));
            this.registerToOreDictionary("treeLeaves", new ItemStack(Values.blockTreeFoliage4, 4, Short.MAX_VALUE));
            this.registerToOreDictionary("treeLeaves", new ItemStack(Values.blockTreeFoliageCB, 5, 0));
            this.registerToOreDictionary("treeLeaves", new ItemStack(Values.blockTreeFoliageCB, 5, 1));
            this.registerToOreDictionary("treeLeaves", new ItemStack(Values.blockTreeFoliageCB, 5, 8));
            this.registerToOreDictionary("treeLeaves", new ItemStack(Values.blockTreeFoliageCB, 5, 9));
        }
        if (Values.blockTypeEarth != null) {
            for (PlantAPI.TreeType tree : PlantAPI.TreeType.values()) {
                String name = tree.toString();
                this.registerToOreDictionary("doorWood", name + "wood_door");
                this.registerToOreDictionary("trapdoorWood", name + "wood_trapdoor");
                this.registerToOreDictionary("gateWood", name + "wood_gate");
                this.registerToOreDictionary("fenceWood", name + "wood_fence");
                this.registerToOreDictionary("stairWood", name + "wood_stairs");
                this.registerToOreDictionary("slabWood", name + "wood_slab");
            }
        }
        if (Values.itemMultiFood != null) {
            this.registerToOreDictionary("cropCherry", "cherry");
            this.registerToOreDictionary("cropOrange", "orange");
            this.registerToOreDictionary("cropPear", "pear");
            this.registerToOreDictionary("cropPeach", "peach");
            this.registerToOreDictionary("cropMango", "mango");
            this.registerToOreDictionary("cropLemon", "lemon");
            this.registerToOreDictionary("cropPlum", "plum");
            this.registerToOreDictionary("cropCoconut", "coconut");
            this.registerToOreDictionary("cropBanana", "banana");
            this.registerToOreDictionary("cropPineapple", "pineapple");
            this.registerToOreDictionary("cropPricklyPear", "pricklypear");
            this.registerToOreDictionary("cropGrapes", "grapes");
            this.registerToOreDictionary("cropLifeFruit", "lifefruit");
            this.registerToOreDictionary("cropDeathFruit", "deathfruit");
            this.registerToOreDictionary("cropPear", "pricklypear");
            this.registerToOreDictionary("cropGrape", "grapes");
            this.registerToOreDictionary("listAllcitrus", "orange");
            this.registerToOreDictionary("listAllcitrus", "lemon");
            this.registerToOreDictionary("listAllfruit", "cherry");
            this.registerToOreDictionary("listAllfruit", "orange");
            this.registerToOreDictionary("listAllfruit", "pear");
            this.registerToOreDictionary("listAllfruit", "peach");
            this.registerToOreDictionary("listAllfruit", "mango");
            this.registerToOreDictionary("listAllfruit", "lemon");
            this.registerToOreDictionary("listAllfruit", "plum");
            this.registerToOreDictionary("listAllfruit", "banana");
            this.registerToOreDictionary("listAllfruit", "pineapple");
            this.registerToOreDictionary("listAllfruit", "pricklypear");
            this.registerToOreDictionary("listAllfruit", "grapes");
        }
        if (Values.itemWaterPearl != null) {
            this.registerToOreDictionary("listAllwater", this.iStack(Values.itemWaterPearl, 0));
        }
        this.registerToOreDictionary("gemEndimium", "endimium_gem");
        this.registerToOreDictionary("gemBurnium", "burnium_gem");
        this.registerToOreDictionary("dyeBlack", "dye_black");
        this.registerToOreDictionary("dyeBrown", "dye_brown");
        this.registerToOreDictionary("dyeBlue", "dye_blue");
        this.registerToOreDictionary("dyeWhite", "dye_white");
        this.registerToOreDictionary("dye", "dye_black");
        this.registerToOreDictionary("dye", "dye_brown");
        this.registerToOreDictionary("dye", "dye_blue");
        this.registerToOreDictionary("dye", "dye_white");
        this.registerToOreDictionary("dustTinyBurnium", "burnium_tinydust");
        this.registerToOreDictionary("dustBurnium", "burnium_dust");
        this.registerToOreDictionary("dustTinyEndimium", "endimium_tinydust");
        this.registerToOreDictionary("dustEndimium", "endimium_dust");
        this.registerToOreDictionary("dustTinyEnder", "ender_tinydust");
        this.registerToOreDictionary("dustEnder", "ender_dust");
        this.registerToOreDictionary("dustTinyIron", "iron_tinydust");
        this.registerToOreDictionary("dustIron", "iron_dust");
        this.registerToOreDictionary("dustTinyGold", "gold_tinydust");
        this.registerToOreDictionary("dustGold", "gold_dust");
        this.registerToOreDictionary("dustTinyCoal", "coal_tinydust");
        this.registerToOreDictionary("dustCoal", "coal_dust");
        this.registerToOreDictionary("dustTinyDiamond", "diamond_tinydust");
        this.registerToOreDictionary("dustDiamond", "diamond_dust");
        this.registerToOreDictionary("dustTinyEmerald", "emerald_tinydust");
        this.registerToOreDictionary("dustEmerald", "emerald_dust");
        this.registerToOreDictionary("dustTinyLapis", "lapis_tinydust");
        this.registerToOreDictionary("dustTinyRedstone", "redstone_tinydust");
        this.registerToOreDictionary("lumpSandstone", "sandstone_lump");
        this.registerToOreDictionary("lumpGravel", "gravel_lump");
        this.registerToOreDictionary("lumpRedSandstone", "redsandstone_lump");
        this.registerToOreDictionary("wool", new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE));
        this.registerToOreDictionary("doorWood", new ItemStack((Block)Blocks.field_180413_ao));
        this.registerToOreDictionary("doorWood", new ItemStack((Block)Blocks.field_180414_ap));
        this.registerToOreDictionary("doorWood", new ItemStack((Block)Blocks.field_180412_aq));
        this.registerToOreDictionary("doorWood", new ItemStack((Block)Blocks.field_180411_ar));
        this.registerToOreDictionary("doorWood", new ItemStack((Block)Blocks.field_180410_as));
        this.registerToOreDictionary("doorWood", new ItemStack((Block)Blocks.field_180409_at));
        this.registerToOreDictionary("trapdoorWood", new ItemStack(Blocks.field_150415_aT));
        this.registerToOreDictionary("gateWood", new ItemStack(Blocks.field_180390_bo));
        this.registerToOreDictionary("gateWood", new ItemStack(Blocks.field_180391_bp));
        this.registerToOreDictionary("gateWood", new ItemStack(Blocks.field_180392_bq));
        this.registerToOreDictionary("gateWood", new ItemStack(Blocks.field_180386_br));
        this.registerToOreDictionary("gateWood", new ItemStack(Blocks.field_180387_bt));
        this.registerToOreDictionary("gateWood", new ItemStack(Blocks.field_180385_bs));
        this.registerToOreDictionary("fenceWood", new ItemStack(Blocks.field_180407_aO));
        this.registerToOreDictionary("fenceWood", new ItemStack(Blocks.field_180408_aP));
        this.registerToOreDictionary("fenceWood", new ItemStack(Blocks.field_180404_aQ));
        this.registerToOreDictionary("fenceWood", new ItemStack(Blocks.field_180403_aR));
        this.registerToOreDictionary("fenceWood", new ItemStack(Blocks.field_180405_aT));
        this.registerToOreDictionary("fenceWood", new ItemStack(Blocks.field_180406_aS));
    }

    private void registerToOreDictionary(String oreName, String stackName) {
        if (Strings.isNullOrEmpty((String)oreName) || Strings.isNullOrEmpty((String)stackName)) {
            return;
        }
        ItemStack stack = Values.stacks.get(stackName, new int[0]);
        this.registerToOreDictionary(oreName, stack);
    }

    private void registerToOreDictionary(String oreName, ItemStack stack) {
        if (Strings.isNullOrEmpty((String)oreName)) {
            return;
        }
        if (stack.func_190926_b()) {
            return;
        }
        OreDictionary.registerOre((String)oreName, (ItemStack)stack);
    }

    private ItemStack iStack(Item item, int metadata) {
        return new ItemStack(item, 1, metadata);
    }

    private ItemStack iStackColored(Block block, int metadata, short rgbIndex) {
        ItemStack stack = this.iStack(block, metadata);
        if (stack.func_77973_b() instanceof IRGB16_Item) {
            ((IRGB16_Item)stack.func_77973_b()).setRGB16(stack, rgbIndex);
        }
        return stack;
    }

    private ItemStack iStack(Block block, int metadata) {
        return new ItemStack(block, 1, metadata);
    }

    private class FoodActionDeathFruit
    extends FoodAction {
        private FoodActionDeathFruit() {
        }

        @Override
        public ItemStack doFinishAction(ItemStack stack, World world, EntityPlayer player) {
            DeathFruitHelper.INSTANCE.onPlayerEat(player);
            return stack;
        }
    }

    private class FoodActionLifeFruit
    extends FoodAction {
        private FoodActionLifeFruit() {
        }

        @Override
        public ItemStack doFinishAction(ItemStack stack, World world, EntityPlayer player) {
            if (player != null) {
                IAttributeInstance attribute = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
                int baseHealth = (int)attribute.func_111125_b();
                int health = (int)player.func_110143_aJ();
                if (health < baseHealth) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76432_h, 1, 0, false, false));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 600, 0, false, false));
                } else if (player.func_110139_bj() < (float)baseHealth) {
                    player.func_110149_m(Math.min(player.func_110139_bj() + 2.0f, (float)baseHealth));
                } else {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 1200, 0, false, false));
                    player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 600, 0, false, false));
                }
            }
            return stack;
        }
    }
}

